/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util.tar;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.util.tar.Messages;
import eu.geclipse.core.util.tar.TarEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarInputStream {
    private static final int BLOCK_SZ = 512;
    private static final int BLOCK_MASK = 511;
    private InputStream tarStream;
    private TarEntry currentEntry;
    private boolean dataPending;

    public TarInputStream(InputStream inStream) {
        this.tarStream = inStream;
        this.currentEntry = null;
        this.dataPending = false;
    }

    public TarEntry getNextEntry() throws ProblemException {
        TarEntry nextEntry;
        if (this.currentEntry != null && this.dataPending) {
            this.copyEntryContents(null);
        }
        try {
            byte[] block = new byte[512];
            this.readBlock(block, 512);
            nextEntry = new TarEntry(block);
            if (nextEntry.isNull()) {
                this.readBlock(block, 512);
                nextEntry = new TarEntry(block);
            }
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.unspecified", (Throwable)ioExc, "eu.geclipse.core");
        }
        if (!nextEntry.isNull()) {
            if (nextEntry.getSize() > 0L) {
                this.dataPending = true;
            }
            this.currentEntry = nextEntry;
        }
        return nextEntry.isNull() ? null : this.currentEntry;
    }

    private void readBlock(byte[] block, int size) throws IOException, ProblemException {
        int off = 0;
        int len = size;
        int n = 0;
        do {
            if ((n = this.tarStream.read(block, off, len)) == -1) {
                throw new ProblemException("eu.geclipse.core.problem.io.corruptedFile", Messages.getString("TarInputStream.EOF_reading_tar"), "eu.geclipse.core");
            }
            len -= n;
        } while ((off += n) < size);
    }

    public void copyEntryContents(OutputStream outStream) throws ProblemException {
        long size = this.currentEntry.getSize();
        long blocks = size / 512L;
        int remain = (int)size & 0x1FF;
        if (remain != 0) {
            ++blocks;
        }
        byte[] buffer = new byte[512];
        int oSize = 512;
        try {
            while (blocks > 0L) {
                this.readBlock(buffer, 512);
                if (outStream != null) {
                    if (blocks == 1L && remain != 0) {
                        oSize = remain;
                    }
                    outStream.write(buffer, 0, oSize);
                }
                --blocks;
            }
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.io.unspecified", (Throwable)ioExc, "eu.geclipse.core");
        }
        this.dataPending = false;
    }
}

