/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.glue;

import eu.geclipse.info.glue.AbstractGlueTable;
import eu.geclipse.info.glue.GlueSE;
import eu.geclipse.info.glue.GlueSEAccessProtocolCapability;
import eu.geclipse.info.glue.GlueSEAccessProtocolSupportedSecurity;
import eu.geclipse.info.glue.GlueUtility;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import javax.naming.directory.Attributes;

public class GlueSEAccessProtocol
extends AbstractGlueTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String UniqueID;
    public String keyName = "UniqueID";
    public GlueSE glueSE;
    public String Type;
    public Long Port;
    public String Version;
    public Long AccessTime;
    public String LocalID;
    public String Endpoint;
    public ArrayList<GlueSEAccessProtocolCapability> glueSEAccessProtocolCapabilityList = new ArrayList();
    public ArrayList<GlueSEAccessProtocolSupportedSecurity> glueSEAccessProtocolSupportedSecurityList = new ArrayList();

    public String getID() {
        return this.UniqueID;
    }

    public void setID(String id) {
        this.UniqueID = id;
    }

    public void processGlueRecord(Attributes attributes) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.UniqueID = GlueUtility.getStringAttribute("GlueChunkKey", attributes);
        this.UniqueID = this.UniqueID.substring(this.UniqueID.indexOf(61) + 1);
        this.Endpoint = GlueUtility.getStringAttribute("GlueSEAccessProtocolEndpoint", attributes);
        this.Port = GlueUtility.getLongAttribute("GlueSEAccessProtocolPort", attributes);
        this.Type = GlueUtility.getStringAttribute("GlueSEAccessProtocolType", attributes);
        this.Version = GlueUtility.getStringAttribute("GlueSEAccessProtocolVersion", attributes);
        this.setRetrievalTime(sdf.format(cal.getTime()));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.Endpoint == null ? 0 : this.Endpoint.hashCode());
        result = 31 * result + (this.Port == null ? 0 : this.Port.hashCode());
        result = 31 * result + (this.Type == null ? 0 : this.Type.hashCode());
        result = 31 * result + (this.Version == null ? 0 : this.Version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlueSEAccessProtocol other = (GlueSEAccessProtocol)obj;
        if (this.Endpoint == null ? other.Endpoint != null : !this.Endpoint.equals(other.Endpoint)) {
            return false;
        }
        if (this.Port == null ? other.Port != null : !this.Port.equals(other.Port)) {
            return false;
        }
        if (this.Type == null ? other.Type != null : !this.Type.equals(other.Type)) {
            return false;
        }
        return !(this.Version == null ? other.Version != null : !this.Version.equals(other.Version));
    }
}

