/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.model;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.info.glue.GlueQuery;
import eu.geclipse.info.glue.GlueSA;
import eu.geclipse.info.glue.GlueSE;
import eu.geclipse.info.glue.GlueSEAccessProtocol;
import eu.geclipse.info.model.GridGlueElement;
import eu.geclipse.info.model.GridGlueService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class GridGlueStorage
extends GridGlueElement
implements IGridStorage {
    public GridGlueStorage(IGridContainer parent, GlueSE glueSE) {
        super(parent, glueSE);
    }

    public GlueSE getGlueSe() {
        return (GlueSE)this.getGlueElement();
    }

    public String getName() {
        GlueSE se = this.getGlueSe();
        return "SE @ " + se.UniqueID;
    }

    protected IVirtualOrganization getVo() {
        IVirtualOrganization result = null;
        IGridProject project = this.getProject();
        if (project != null) {
            result = project.getVO();
        } else {
            IGridContainer parent = this.getParent();
            while (parent != null) {
                if (parent instanceof IVirtualOrganization) {
                    result = (IVirtualOrganization)parent;
                    break;
                }
                parent = parent.getParent();
            }
        }
        return result;
    }

    public URI getURI() {
        URI uri = null;
        try {
            uri = new URI(this.getGlueSe().UniqueID);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return uri;
    }

    public String getHostName() {
        String str = null;
        URI uri = this.getURI();
        if (uri != null && (str = uri.getHost()) == null) {
            str = uri.getPath();
        }
        return str;
    }

    public IMountable.MountPoint getMountPoint(IMountable.MountPointID mountID) {
        IMountable.MountPoint result = null;
        ArrayList<GlueSEAccessProtocol> apList = this.getGlueSe().glueSEAccessProtocolList;
        if (apList != null) {
            for (GlueSEAccessProtocol ap : apList) {
                String uid = this.getAccessProtocolUID(ap);
                if (!mountID.getUID().equals(uid)) continue;
                result = this.getMountPoint(ap);
                break;
            }
        }
        return result;
    }

    public IMountable.MountPointID[] getMountPointIDs() {
        ArrayList<IMountable.MountPointID> mountIDs = new ArrayList<IMountable.MountPointID>();
        ArrayList<GlueSEAccessProtocol> apList = this.getGlueSe().glueSEAccessProtocolList;
        if (apList != null) {
            for (GlueSEAccessProtocol ap : apList) {
                String uid = this.getAccessProtocolUID(ap);
                String scheme = this.getAccessProtocolScheme(ap);
                IMountable.MountPointID mountID = new IMountable.MountPointID(uid, scheme);
                mountIDs.add(mountID);
            }
        }
        return mountIDs.toArray(new IMountable.MountPointID[mountIDs.size()]);
    }

    protected IMountable.MountPoint getSrmMountPoint(GridGlueService srmService) {
        IMountable.MountPoint result = null;
        ArrayList<GlueSEAccessProtocol> apList = this.getGlueSe().glueSEAccessProtocolList;
        if (apList != null) {
            for (GlueSEAccessProtocol ap : apList) {
                String scheme = this.getAccessProtocolScheme(ap);
                if (!"srm".equals(scheme)) continue;
                result = this.getMountPoint(ap);
                break;
            }
        }
        return result;
    }

    private String getAccessProtocolUID(GlueSEAccessProtocol ap) {
        String scheme = this.getAccessProtocolScheme(ap);
        return String.format("%s:%d", scheme, ap.Port);
    }

    private String getAccessProtocolScheme(GlueSEAccessProtocol ap) {
        return ap.Type.toLowerCase();
    }

    private IMountable.MountPoint getMountPoint(GlueSEAccessProtocol ap) {
        IMountable.MountPoint result = null;
        String scheme = this.getAccessProtocolScheme(ap);
        String host = this.getGlueSe().UniqueID;
        int port = ap.Port.intValue();
        String path = this.getMountPath();
        try {
            URI uri = new URI(scheme, null, host, port, path, null, null);
            String name = String.format("%s @ %s.%d", scheme, host, port);
            result = new IMountable.MountPoint(name, uri);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return result;
    }

    private String getMountPath() {
        String path = null;
        IVirtualOrganization vo = this.getVo();
        for (GlueSA sa : this.getGlueSe().glueSAList) {
            if (vo != null && !GlueQuery.saSupportsVO(sa, vo.getName())) continue;
            path = sa.Path;
            if (path.endsWith("/")) break;
            path = String.valueOf(path) + "/";
            break;
        }
        return path;
    }
}

