/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.adapters.jsdl;

import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.DocumentRoot;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.ui.adapters.jsdl.JsdlAdaptersFactory;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStageTypeAdapter
extends JsdlAdaptersFactory {
    private boolean isNotifyAllowed = true;
    private boolean adapterRefreshed = false;
    private DocumentRoot documentRoot = JsdlFactory.eINSTANCE.createDocumentRoot();
    private DataStagingType dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
    private SourceTargetType sourceTargetType = JsdlFactory.eINSTANCE.createSourceTargetType();
    private Hashtable<Integer, TableViewer> tableFeaturesMap = new Hashtable();
    private JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();

    public DataStageTypeAdapter(JobDefinitionType jobDefinitionRoot) {
        this.getTypeForAdapter(jobDefinitionRoot);
    }

    protected void contentChanged() {
        if (this.isNotifyAllowed) {
            this.fireNotifyChanged(null);
        }
    }

    private void getTypeForAdapter(JobDefinitionType jobDefinitionRoot) {
        this.jobDescriptionType = jobDefinitionRoot.getJobDescription();
    }

    public void setContent(JobDefinitionType jobDefinitionRoot) {
        this.adapterRefreshed = true;
        this.getTypeForAdapter(jobDefinitionRoot);
    }

    public void attachToStageIn(TableViewer widget) {
        Integer featureID = 4;
        this.tableFeaturesMap.put(featureID, widget);
        widget.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return ((DataStagingType)element).getSource() != null;
            }
        });
    }

    public void attachToStageOut(TableViewer widget) {
        Integer featureID = 5;
        this.tableFeaturesMap.put(featureID, widget);
        widget.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                return ((DataStagingType)element).getTarget() != null;
            }
        });
    }

    public void attachToDelete(Button button, final TableViewer viewer) {
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataStageTypeAdapter.this.performDelete(viewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    public void performAdd(TableViewer tableViewer, ArrayList<DataStagingType> dataStageList) {
        this.tableFeaturesMap.get(4);
        if (dataStageList.isEmpty()) {
            return;
        }
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i = 0;
        while (i < dataStageList.size()) {
            boolean exists = this.doesElementExists(this.dataStagingType, dataStageList.get(i), (EList<DataStagingType>)newInputList);
            if (!exists) {
                newInputList.add((Object)dataStageList.get(i));
                try {
                    this.jobDescriptionType.getDataStaging().addAll((Collection)newInputList);
                    tableViewer.setInput((Object)this.jobDescriptionType.getDataStaging());
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                tableViewer.refresh();
                this.contentChanged();
            } else {
                MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("DataStagingPage_DuplicateEntryDialog_Title"), (String)Messages.getString("DataStagingPage_New_DuplicateEntryDialog_Message"));
            }
            ++i;
        }
        newInputList = null;
    }

    protected void checkDataStageElement() {
        EStructuralFeature eStructuralFeature = this.documentRoot.eClass().getEStructuralFeature(3);
        ArrayList<DataStagingType> collection = new ArrayList<DataStagingType>();
        collection.add(this.dataStagingType);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, collection);
        }
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        for (Object feature : structSelection) {
            DataStagingType selectedDataStage = (DataStagingType)feature;
            try {
                EcoreUtil.remove((EObject)selectedDataStage);
            }
            catch (Exception e) {
                Activator.logException(e);
            }
            viewer.refresh();
            this.contentChanged();
        }
    }

    public void performEdit(TableViewer tableViewer, ArrayList<DataStagingType> dataStageList) {
        this.tableFeaturesMap.get(4);
        if (dataStageList.isEmpty()) {
            return;
        }
        EList newInputList = (EList)tableViewer.getInput();
        int featureID = 3;
        IStructuredSelection structSelection = (IStructuredSelection)tableViewer.getSelection();
        if (structSelection != null) {
            int i = 0;
            while (i < dataStageList.size()) {
                EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(featureID);
                Object oldDataStageElement = structSelection.getFirstElement();
                int index = ((List)this.jobDescriptionType.eGet(eStructuralFeature)).indexOf(oldDataStageElement);
                this.dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
                this.sourceTargetType = JsdlFactory.eINSTANCE.createSourceTargetType();
                this.dataStagingType = dataStageList.get(i);
                if (!this.doesElementExists((DataStagingType)oldDataStageElement, this.dataStagingType, (EList<DataStagingType>)newInputList)) {
                    ((List)this.jobDescriptionType.eGet(eStructuralFeature)).set(index, this.dataStagingType);
                    tableViewer.refresh();
                    this.contentChanged();
                } else {
                    MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("DataStagingPage_DuplicateEntryDialog_Title"), (String)Messages.getString("DataStagingPage_Edit_DuplicateEntryDialog_Message"));
                }
                ++i;
            }
        }
    }

    private boolean doesElementExists(DataStagingType oldDataStage, DataStagingType newDataStage, EList<DataStagingType> inputList) {
        boolean result = false;
        if (newDataStage.getSource() != null) {
            for (DataStagingType data : inputList) {
                if (data.equals(oldDataStage) || data.getSource() == null || !data.getFileName().equals(newDataStage.getFileName()) || !data.getSource().getURI().equals(newDataStage.getSource().getURI())) continue;
                result = true;
            }
        } else {
            for (DataStagingType data : inputList) {
                if (data.equals(oldDataStage) || data.getTarget() == null || !data.getFileName().equals(newDataStage.getFileName()) || !data.getTarget().getURI().equals(newDataStage.getTarget().getURI())) continue;
                result = true;
            }
        }
        return result;
    }

    public void load() {
        this.isNotifyAllowed = false;
        JobDescriptionType jobDescrEObject = this.jobDescriptionType;
        TableViewer tableName = null;
        TableViewer tableName2 = null;
        if (jobDescrEObject != null) {
            EClass eClass = jobDescrEObject.eClass();
            for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
                int featureID = eStructuralFeature.getFeatureID();
                if (!(eStructuralFeature instanceof EReference) || !jobDescrEObject.eIsSet(eStructuralFeature)) continue;
                switch (featureID) {
                    case 3: {
                        tableName = this.tableFeaturesMap.get(4);
                        tableName2 = this.tableFeaturesMap.get(5);
                        EList valueList = (EList)jobDescrEObject.eGet(eStructuralFeature);
                        tableName.setInput((Object)valueList);
                        tableName2.setInput((Object)valueList);
                        break;
                    }
                }
            }
        }
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
        this.isNotifyAllowed = true;
    }
}

