/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class CandidateHostsDialog
extends Dialog {
    protected CheckboxTableViewer hostsViewer = null;
    protected Composite panel = null;
    protected String title = null;
    protected List<MultipleInputDialog.Validator> validators = new ArrayList<MultipleInputDialog.Validator>();
    private IGridElement gridElement = null;
    private JSDLJobDescription jobDescription = null;
    private List<String> existingHostsInViewer = new ArrayList<String>();
    private String[] selectedHosts = null;

    public CandidateHostsDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x10000);
    }

    protected void configureShell(Shell shell) {
        shell.setSize(600, 300);
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control btnBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return btnBar;
    }

    private void enableOKButton(boolean value) {
        this.getButton(0).setEnabled(value);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        container.setLayout((Layout)new GridLayout(1, false));
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)gd);
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(1, false);
        this.panel.setLayout((Layout)layout);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.panel.setLayoutData((Object)gd);
        Label label = new Label(this.panel, 0);
        label.setText(Messages.getString("ResourcesPage_NewHostsDialogDescr"));
        label.setLayoutData((Object)new GridData(32));
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 100;
        Table table = new Table(this.panel, 2848);
        table.setLayoutData((Object)gd);
        this.hostsViewer = new CheckboxTableViewer(table);
        this.hostsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        FeatureLabelProvider hostsLabelProvider = new FeatureLabelProvider();
        hostsLabelProvider.setStringType(4);
        this.hostsViewer.setLabelProvider((IBaseLabelProvider)hostsLabelProvider);
        this.hostsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CandidateHostsDialog.this.setValue(CandidateHostsDialog.this.hostsViewer.getCheckedElements());
            }
        });
        try {
            ArrayList<String> computingElements = new ArrayList<String>();
            IGridResource[] gridComputings = this.jobDescription.getProject().getVO().getInfoService().fetchResources((IGridContainer)this.jobDescription.getProject().getVO(), this.jobDescription.getProject().getVO(), GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"), false, IGridComputing.class, (IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < gridComputings.length) {
                if (gridComputings[i].getName().indexOf(":") != -1) {
                    String hostnameOnly = gridComputings[i].getName().substring(gridComputings[i].getName().lastIndexOf(" ") + 1, gridComputings[i].getName().indexOf(":"));
                    if (this.existingHostsInViewer != null) {
                        if (!this.existingHostsInViewer.contains(hostnameOnly) && !computingElements.contains(hostnameOnly)) {
                            computingElements.add(hostnameOnly);
                        }
                    } else if (!computingElements.contains(hostnameOnly)) {
                        computingElements.add(hostnameOnly);
                    }
                }
                ++i;
            }
            this.hostsViewer.setInput(computingElements);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
        Dialog.applyDialogFont((Control)container);
        return parent;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public int open() {
        CandidateHostsDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.CANDIDATE_HOSTS_DIALOG";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    public void setDialogInput(IGridElement input) {
        this.gridElement = input;
        this.getJobDescription(this.gridElement);
    }

    public void setExistingCandidateHosts(Object input) {
        this.existingHostsInViewer = (List)input;
    }

    protected void setValue(Object[] value) {
        Object[] checkedElements = value;
        if (checkedElements != null && checkedElements.length > 0) {
            this.enableOKButton(true);
            this.selectedHosts = new String[checkedElements.length];
            int i = 0;
            while (i < checkedElements.length) {
                this.selectedHosts[i] = (String)checkedElements[i];
                ++i;
            }
        } else {
            this.enableOKButton(false);
        }
    }

    public Object[] getValue() {
        Object[] returnHosts = new String[this.selectedHosts.length];
        System.arraycopy(this.selectedHosts, 0, returnHosts, 0, this.selectedHosts.length);
        return returnHosts;
    }

    private JSDLJobDescription getJobDescription(IGridElement input) {
        this.jobDescription = input instanceof JSDLJobDescription ? (JSDLJobDescription)input : null;
        return this.jobDescription;
    }
}

