/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.posix.EnvironmentType;
import eu.geclipse.jsdl.model.posix.PosixFactory;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnvironmentVarDialog
extends Dialog {
    protected JobDefinitionType jobDefinitionType = JsdlFactory.eINSTANCE.createJobDefinitionType();
    protected EnvironmentType environmentType = PosixFactory.eINSTANCE.createEnvironmentType();
    protected FileSystemType fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
    protected Label lblName = null;
    protected Label lblValue = null;
    protected Label lblFileSystemName = null;
    protected Combo cmbFileSystemName = null;
    protected Text txtValue = null;
    protected Text txtName = null;
    protected boolean editMode = false;
    protected Composite panel = null;
    private String title = null;

    public EnvironmentVarDialog(Shell parentShell, String title, JobDefinitionType jsdlRoot) {
        super(parentShell);
        this.title = title;
        if (jsdlRoot != null) {
            this.jobDefinitionType = jsdlRoot;
        }
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x10000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control btnBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return btnBar;
    }

    private void enableOKButton(boolean value) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)gd);
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        this.panel.setLayout((Layout)layout);
        gd = new GridData(768);
        this.panel.setLayoutData((Object)gd);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.lblName = new Label(this.panel, 0);
        this.lblName.setText(Messages.getString("Dialog_Name"));
        this.txtName = new Text(this.panel, 2052);
        if (this.editMode) {
            this.txtName.setText(this.environmentType.getName());
        }
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentVarDialog.this.environmentType.setName(EnvironmentVarDialog.this.txtName.getText());
                EnvironmentVarDialog.this.validateFields();
            }
        });
        this.txtName.setLayoutData((Object)gd);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.lblFileSystemName = new Label(this.panel, 0);
        this.lblFileSystemName.setText(Messages.getString("Dialog_FileSystem"));
        this.cmbFileSystemName = new Combo(this.panel, 2060);
        EList fileSystemList = null;
        if (this.jobDefinitionType.getJobDescription().getResources() != null) {
            try {
                fileSystemList = this.jobDefinitionType.getJobDescription().getResources().getFileSystem();
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
        if (fileSystemList != null) {
            for (FileSystemType this.fileSystemType : fileSystemList) {
                this.cmbFileSystemName.add(this.fileSystemType.getName());
            }
        }
        if (this.editMode && this.environmentType.getFilesystemName() != null) {
            this.cmbFileSystemName.setText(this.environmentType.getFilesystemName());
        }
        this.cmbFileSystemName.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EnvironmentVarDialog.this.environmentType.setFilesystemName(EnvironmentVarDialog.this.cmbFileSystemName.getItem(EnvironmentVarDialog.this.cmbFileSystemName.getSelectionIndex()));
                EnvironmentVarDialog.this.validateFields();
            }
        });
        this.cmbFileSystemName.setLayoutData((Object)gd);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.lblValue = new Label(this.panel, 0);
        this.lblValue.setText(Messages.getString("Dialog_Value"));
        this.txtValue = new Text(this.panel, 2052);
        if (this.editMode) {
            this.txtValue.setText(this.environmentType.getValue());
        }
        this.txtValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvironmentVarDialog.this.environmentType.setValue(EnvironmentVarDialog.this.txtValue.getText());
                EnvironmentVarDialog.this.validateFields();
            }
        });
        this.txtValue.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)container);
        return parent;
    }

    protected void validateFields() {
        if (this.txtValue.getText() != "") {
            this.enableOKButton(true);
        }
    }

    public void setInput(Object dialogInput) {
        EnvironmentType tempEnvironmentType = PosixFactory.eINSTANCE.createEnvironmentType();
        tempEnvironmentType = (EnvironmentType)dialogInput;
        this.environmentType.setFilesystemName(tempEnvironmentType.getFilesystemName());
        this.environmentType.setName(tempEnvironmentType.getName());
        this.environmentType.setValue(tempEnvironmentType.getValue());
        tempEnvironmentType = null;
        this.editMode = true;
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.ENVIRONMENT_VAR_DIALOG";
    }

    public Object getValue() {
        return this.environmentType;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public int open() {
        EnvironmentVarDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }
}

