/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.jsdl.model.base.BoundaryType;
import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.base.FileSystemTypeEnumeration;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.RangeValueType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FileSystemsDialog
extends Dialog {
    private static final int WIDGET_HEIGHT = 100;
    protected FileSystemType fileSystemType = JsdlFactory.eINSTANCE.createFileSystemType();
    protected boolean editMode = false;
    protected Composite panel = null;
    protected Label lblFileSystemName = null;
    protected Label lblMountPoint = null;
    protected Label lblMountSource = null;
    protected Label lblDiskSpace = null;
    protected Label lblFileSystemType = null;
    protected Label lblFileSystemDescr = null;
    protected Text txtFileSystemName = null;
    protected Text txtFileSystemDescr = null;
    protected Text txtMountPoint = null;
    protected Text txtMountSource = null;
    protected Text txtDiskSpace = null;
    protected Combo cmbFileSystemType = null;
    protected Combo cmbDiskSpaceRange = null;
    private String title = null;
    private FileSystemType newFileSystem = null;

    public FileSystemsDialog(Shell parentShell, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x10000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control btnBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return btnBar;
    }

    private void enableOKButton(boolean value) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(value);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)gd);
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        this.panel.setLayout((Layout)layout);
        gd = new GridData(768);
        this.panel.setLayoutData((Object)gd);
        gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.lblFileSystemName = new Label(this.panel, 0);
        this.lblFileSystemName.setText(Messages.getString("ResourcesPage_FileSystemName"));
        this.txtFileSystemName = new Text(this.panel, 2052);
        if (this.editMode) {
            this.txtFileSystemName.setText(this.fileSystemType.getName());
        }
        this.txtFileSystemName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSystemsDialog.this.fileSystemType.setName(FileSystemsDialog.this.txtFileSystemName.getText());
                FileSystemsDialog.this.validateFields();
            }
        });
        this.txtFileSystemName.setLayoutData((Object)gd);
        if (this.editMode) {
            this.txtFileSystemName.setText(this.fileSystemType.getName());
        }
        gd = new GridData(256);
        gd.verticalAlignment = 1;
        this.lblFileSystemDescr = new Label(this.panel, 0);
        this.lblFileSystemDescr.setText(Messages.getString("ResourcesPage_Description"));
        this.lblFileSystemDescr.setLayoutData((Object)gd);
        this.txtFileSystemDescr = new Text(this.panel, 2882);
        gd = new GridData(768);
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.heightHint = 100;
        if (this.editMode && this.fileSystemType.getDescription() != null) {
            this.txtFileSystemDescr.setText(this.fileSystemType.getDescription());
        }
        this.txtFileSystemDescr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSystemsDialog.this.fileSystemType.setDescription(FileSystemsDialog.this.txtFileSystemDescr.getText());
            }
        });
        this.txtFileSystemDescr.setLayoutData((Object)gd);
        gd = new GridData();
        this.lblMountPoint = new Label(this.panel, 0);
        this.lblMountPoint.setText(Messages.getString("ResourcesPage_MountPoint"));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.txtMountPoint = new Text(this.panel, 2052);
        if (this.editMode && this.fileSystemType.getMountPoint() != null && this.fileSystemType.getMountPoint() != null) {
            this.txtMountPoint.setText(this.fileSystemType.getMountPoint());
        }
        this.txtMountPoint.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileSystemsDialog.this.fileSystemType.setMountPoint(FileSystemsDialog.this.txtMountPoint.getText());
            }
        });
        this.txtMountPoint.setLayoutData((Object)gd);
        gd = new GridData();
        this.lblMountSource = new Label(this.panel, 0);
        this.lblMountSource.setText(Messages.getString("ResourcesPage_MountSource"));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.txtMountSource = new Text(this.panel, 2052);
        this.txtMountSource.setLayoutData((Object)gd);
        gd = new GridData();
        this.lblDiskSpace = new Label(this.panel, 0);
        this.lblDiskSpace.setText(Messages.getString("ResourcesPage_DiskSpace"));
        this.txtDiskSpace = new Text(this.panel, 2052);
        this.txtDiskSpace.setLayoutData((Object)gd);
        gd = new GridData(1808);
        this.cmbDiskSpaceRange = new Combo(this.panel, 2060);
        this.cmbDiskSpaceRange.add(Messages.getString("ResourcesPage_LowBoundRange"));
        this.cmbDiskSpaceRange.add(Messages.getString("ResourcesPage_UpBoundRange"));
        this.cmbDiskSpaceRange.setLayoutData((Object)gd);
        this.txtDiskSpace.addModifyListener(new ModifyListener(){
            BoundaryType boundaryType = JsdlFactory.eINSTANCE.createBoundaryType();
            RangeValueType rangeValueType = JsdlFactory.eINSTANCE.createRangeValueType();

            public void modifyText(ModifyEvent e) {
                if (!FileSystemsDialog.this.txtDiskSpace.getText().equals("") && !FileSystemsDialog.this.editMode) {
                    this.boundaryType.setValue(Double.parseDouble(FileSystemsDialog.this.txtDiskSpace.getText()));
                    switch (FileSystemsDialog.this.cmbDiskSpaceRange.getSelectionIndex()) {
                        case 0: {
                            this.rangeValueType.setLowerBound(this.boundaryType);
                            break;
                        }
                        case 1: {
                            this.rangeValueType.setUpperBound(this.boundaryType);
                            break;
                        }
                    }
                    FileSystemsDialog.this.fileSystemType.setDiskSpace(this.rangeValueType);
                }
            }
        });
        this.cmbDiskSpaceRange.addSelectionListener(new SelectionListener(){
            BoundaryType boundaryType = JsdlFactory.eINSTANCE.createBoundaryType();
            RangeValueType rangeValueType = JsdlFactory.eINSTANCE.createRangeValueType();

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!FileSystemsDialog.this.txtDiskSpace.getText().equals("")) {
                    this.boundaryType.setValue(Double.parseDouble(FileSystemsDialog.this.txtDiskSpace.getText()));
                    switch (FileSystemsDialog.this.cmbDiskSpaceRange.getSelectionIndex()) {
                        case 0: {
                            this.rangeValueType.setLowerBound(this.boundaryType);
                            break;
                        }
                        case 1: {
                            this.rangeValueType.setUpperBound(this.boundaryType);
                            break;
                        }
                    }
                    FileSystemsDialog.this.fileSystemType.setDiskSpace(this.rangeValueType);
                }
            }
        });
        if (this.editMode) {
            RangeValueType rangeValueType = JsdlFactory.eINSTANCE.createRangeValueType();
            rangeValueType = this.fileSystemType.getDiskSpace();
            rangeValueType = (RangeValueType)this.checkProxy((EObject)rangeValueType);
            BoundaryType boundaryType = JsdlFactory.eINSTANCE.createBoundaryType();
            if (this.fileSystemType.getDiskSpace() != null) {
                if (this.fileSystemType.getDiskSpace().getLowerBound() != null) {
                    boundaryType = this.fileSystemType.getDiskSpace().getLowerBound();
                    boundaryType = (BoundaryType)this.checkProxy((EObject)boundaryType);
                    this.txtDiskSpace.setText(Double.toString(boundaryType.getValue()));
                    this.cmbDiskSpaceRange.select(0);
                } else {
                    boundaryType = this.fileSystemType.getDiskSpace().getUpperBound();
                    boundaryType = (BoundaryType)this.checkProxy((EObject)boundaryType);
                    this.txtDiskSpace.setText(Double.toString(boundaryType.getValue()));
                    this.cmbDiskSpaceRange.select(1);
                }
            }
        }
        this.lblFileSystemType = new Label(this.panel, 0);
        this.lblFileSystemType.setText(Messages.getString("ResourcesPage_FileSysType"));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.cmbFileSystemType = new Combo(this.panel, 2056);
        EEnum cFEnum = JsdlPackage.Literals.FILE_SYSTEM_TYPE_ENUMERATION;
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            this.cmbFileSystemType.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        this.cmbFileSystemType.setLayoutData((Object)gd);
        this.cmbFileSystemType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileSystemsDialog.this.fileSystemType.setFileSystemType(FileSystemTypeEnumeration.get((int)FileSystemsDialog.this.cmbFileSystemType.getSelectionIndex()));
            }
        });
        if (this.editMode) {
            this.cmbFileSystemType.setText(this.fileSystemType.getFileSystemType().toString());
        }
        if (this.editMode) {
            this.editMode = false;
        }
        Dialog.applyDialogFont((Control)container);
        return parent;
    }

    public void setInput(Object dialogInput) {
        FileSystemType tempFs = JsdlFactory.eINSTANCE.createFileSystemType();
        tempFs = (FileSystemType)dialogInput;
        this.fileSystemType.setName(tempFs.getName());
        this.fileSystemType.setDescription(tempFs.getDescription());
        this.fileSystemType.setFileSystemType(tempFs.getFileSystemType());
        this.fileSystemType.setMountPoint(tempFs.getMountPoint());
        this.fileSystemType.setDiskSpace(tempFs.getDiskSpace());
        tempFs = null;
        this.editMode = true;
    }

    public Object getValue() {
        return this.newFileSystem;
    }

    protected void okPressed() {
        try {
            this.newFileSystem = this.fileSystemType;
        }
        catch (Exception e) {
            Activator.logException(e);
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    public int open() {
        FileSystemsDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    protected void validateFields() {
        if (this.txtFileSystemName.getText() != "") {
            this.enableOKButton(true);
        }
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.FILE_SYSTEMS_DIALOG";
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.fileSystemType);
        }
        return eObject;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }
}

