/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.ui.widgets.StoredCombo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends Dialog {
    public static final String FIELD_NAME = "FIELD_NAME";
    private Composite panel;
    private List<FieldSummary> fieldList = new ArrayList<FieldSummary>();
    private String title;
    private List<Text> textList = new ArrayList<Text>();
    private Map<Object, String> valueMap = new HashMap<Object, String>();
    private List<StoredCombo> storedList = new ArrayList<StoredCombo>();
    private List<Combo> comboList = new ArrayList<Combo>();

    public InputDialog(Shell parentShell) {
        super(parentShell);
    }

    public void addTextField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(FieldType.TEXT, labelText, initialValue, allowsEmpty));
    }

    public void addStoredComboField(String labelText, String initialValue, boolean allowsEmpty, String prefID) {
        this.fieldList.add(new FieldSummary(FieldType.STORED_COMBO, labelText, initialValue, allowsEmpty, prefID));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComp = (Composite)super.createDialogArea(parent);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        mainComp.setLayoutData((Object)new GridData(1808));
        this.panel = new Composite(mainComp, 0);
        GridLayout layout = new GridLayout(2, false);
        this.panel.setLayout((Layout)layout);
        this.panel.setLayoutData((Object)new GridData(768));
        for (FieldSummary fieldSumm : this.fieldList) {
            switch (fieldSumm.type) {
                case TEXT: {
                    this.createTextField(this.panel, fieldSumm.name, fieldSumm.initialValue, fieldSumm.allowsEmpty);
                    break;
                }
                case BROWSE: {
                    this.createBrowseField(this.panel, fieldSumm.name, fieldSumm.initialValue, fieldSumm.allowsEmpty, fieldSumm.allowLocal);
                    break;
                }
                case STORED_COMBO: {
                    break;
                }
            }
        }
        return mainComp;
    }

    private void createBrowseField(Composite parent, String name, String initialValue, boolean allowsEmpty, boolean allowLocal) {
        GridData gData = new GridData();
        Label label = new Label(parent, 16384);
        label.setText(name);
        label.setLayoutData((Object)gData);
        Text text = new Text(parent, 16384);
        text.setText(initialValue);
        gData = new GridData(768);
        text.setLayoutData((Object)gData);
        this.textList.add(text);
    }

    private void createTextField(Composite parent, String name, String initialValue, boolean allowsEmpty) {
        GridData gData = new GridData();
        Label label = new Label(parent, 16384);
        label.setText(name);
        label.setLayoutData((Object)gData);
        Text text = new Text(parent, 18432);
        text.setText(initialValue);
        gData = new GridData(768);
        text.setLayoutData((Object)gData);
        this.textList.add(text);
        new Button(parent, 8);
    }

    protected Button createButton(Composite parent, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.setButtonLayoutData(button);
        return button;
    }

    protected void okPressed() {
        for (Text textControl : this.textList) {
            this.valueMap.put(textControl.getData(FIELD_NAME), textControl.getText());
        }
        for (StoredCombo storedControl : this.storedList) {
            this.valueMap.put(storedControl.getData(FIELD_NAME), storedControl.getText());
        }
        for (Combo comboControl : this.comboList) {
            this.valueMap.put(comboControl.getData(FIELD_NAME), comboControl.getText());
        }
        super.okPressed();
    }

    protected class FieldSummary {
        FieldType type;
        String name;
        String initialValue;
        boolean allowsEmpty;
        boolean allowLocal;
        final String prefID;

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty) {
            this(type, name, initialValue, allowsEmpty, true);
        }

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty, boolean allowLocal) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
            this.allowLocal = allowLocal;
            this.prefID = "";
        }

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty, String prefID) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
            this.prefID = prefID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FieldType {
        TEXT,
        BROWSE,
        COMBO,
        STORED_COMBO;

    }

    protected class Validator {
        protected Validator() {
        }

        boolean validate() {
            return true;
        }
    }
}

