/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.ApplicationType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.posix.DocumentRoot;
import eu.geclipse.jsdl.model.posix.FileNameType;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import eu.geclipse.jsdl.model.posix.PosixFactory;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class GeneralInfoSection
extends JsdlFormPageSection {
    private static final int WIDGET_MAX_WIDTH = 100;
    protected Label lblApplicationName = null;
    protected Label lblExecutable = null;
    protected Label lblInput = null;
    protected Label lblOutput = null;
    protected Label lblError = null;
    protected FormText sectionContent = null;
    protected Text txtApplicationName = null;
    protected Text txtExecutable = null;
    protected Text txtInput = null;
    protected Text txtOutput = null;
    protected Text txtError = null;
    protected JobDefinitionType jobDefinitionType = null;
    protected JobDescriptionType jobDescriptionType = null;
    protected ApplicationType applicationType = null;
    protected POSIXApplicationType posixApplicationType = null;
    protected DocumentRoot documentRoot = PosixFactory.eINSTANCE.createDocumentRoot();

    public GeneralInfoSection(Composite parent, FormToolkit toolkit) {
        this.createSection(parent, toolkit);
    }

    private Composite createSection(Composite parentComposite, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("OverviewPage_GeneralInfoTitle");
        String sectionDescription = Messages.getString("OverviewPage_GeneralInfoDescription");
        Composite client = FormSectionFactory.createStaticSection(toolkit, parentComposite, sectionTitle, sectionDescription, 2);
        this.lblApplicationName = toolkit.createLabel(client, Messages.getString("OverviewPage_ApplName"));
        TableWrapData td = new TableWrapData(256);
        td.maxWidth = 100;
        this.txtApplicationName = toolkit.createText(client, "", 0);
        this.txtApplicationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GeneralInfoSection.this.txtApplicationName.getText().equals("")) {
                    GeneralInfoSection.this.applicationType.setApplicationName(GeneralInfoSection.this.txtApplicationName.getText());
                } else {
                    GeneralInfoSection.this.applicationType.setApplicationName(null);
                }
                GeneralInfoSection.this.contentChanged();
            }
        });
        this.txtApplicationName.setLayoutData((Object)td);
        this.lblExecutable = toolkit.createLabel(client, Messages.getString("OverviewPage_Executable"));
        td = new TableWrapData(256);
        td.maxWidth = 100;
        this.txtExecutable = toolkit.createText(client, "", 0);
        this.txtExecutable.addModifyListener(new ModifyListener(){
            FileNameType fileName = null;

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.checkPosixApplicationElement();
                if (!GeneralInfoSection.this.txtExecutable.getText().equals("")) {
                    if (this.fileName == null) {
                        this.fileName = PosixFactory.eINSTANCE.createFileNameType();
                    }
                    this.fileName.setValue(GeneralInfoSection.this.txtExecutable.getText());
                    this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                    GeneralInfoSection.this.posixApplicationType.setExecutable(this.fileName);
                } else {
                    if (this.fileName != null) {
                        this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                        this.fileName = null;
                    }
                    GeneralInfoSection.this.posixApplicationType.setExecutable(null);
                }
                GeneralInfoSection.this.contentChanged();
            }
        });
        this.txtExecutable.setLayoutData((Object)td);
        this.lblInput = toolkit.createLabel(client, Messages.getString("OverviewPage_Input"));
        td = new TableWrapData(256);
        td.maxWidth = 100;
        this.txtInput = toolkit.createText(client, "", 0);
        this.txtInput.addModifyListener(new ModifyListener(){
            FileNameType fileName = null;

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.checkPosixApplicationElement();
                if (!GeneralInfoSection.this.txtInput.getText().equals("")) {
                    if (this.fileName == null) {
                        this.fileName = PosixFactory.eINSTANCE.createFileNameType();
                    }
                    this.fileName.setValue(GeneralInfoSection.this.txtInput.getText());
                    this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                    GeneralInfoSection.this.posixApplicationType.setInput(this.fileName);
                } else {
                    if (this.fileName != null) {
                        this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                        this.fileName = null;
                    }
                    GeneralInfoSection.this.posixApplicationType.setInput(null);
                }
                GeneralInfoSection.this.contentChanged();
            }
        });
        this.txtInput.setLayoutData((Object)td);
        this.lblOutput = toolkit.createLabel(client, Messages.getString("OverviewPage_Output"));
        td = new TableWrapData(256);
        td.maxWidth = 100;
        this.txtOutput = toolkit.createText(client, "", 0);
        this.txtOutput.addModifyListener(new ModifyListener(){
            FileNameType fileName = null;

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.checkPosixApplicationElement();
                if (!GeneralInfoSection.this.txtOutput.getText().equals("")) {
                    if (this.fileName == null) {
                        this.fileName = PosixFactory.eINSTANCE.createFileNameType();
                    }
                    this.fileName.setValue(GeneralInfoSection.this.txtOutput.getText());
                    this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                    GeneralInfoSection.this.posixApplicationType.setOutput(this.fileName);
                } else {
                    if (this.fileName != null) {
                        this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                        this.fileName = null;
                    }
                    GeneralInfoSection.this.posixApplicationType.setOutput(null);
                }
                GeneralInfoSection.this.contentChanged();
            }
        });
        this.txtOutput.setLayoutData((Object)td);
        this.lblError = toolkit.createLabel(client, Messages.getString("OverviewPage_Error"));
        td = new TableWrapData(256);
        td.maxWidth = 100;
        this.txtError = toolkit.createText(client, "", 0);
        this.txtError.addModifyListener(new ModifyListener(){
            FileNameType fileName = null;

            public void modifyText(ModifyEvent e) {
                GeneralInfoSection.this.checkPosixApplicationElement();
                if (!GeneralInfoSection.this.txtError.getText().equals("")) {
                    if (this.fileName == null) {
                        this.fileName = PosixFactory.eINSTANCE.createFileNameType();
                    }
                    this.fileName.setValue(GeneralInfoSection.this.txtError.getText());
                    this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                    GeneralInfoSection.this.posixApplicationType.setError(this.fileName);
                } else {
                    if (this.fileName != null) {
                        this.fileName = (FileNameType)GeneralInfoSection.this.checkProxy((EObject)this.fileName);
                        this.fileName = null;
                    }
                    GeneralInfoSection.this.posixApplicationType.setError(null);
                }
                GeneralInfoSection.this.contentChanged();
            }
        });
        this.txtError.setLayoutData((Object)td);
        toolkit.paintBordersFor(client);
        return client;
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.applicationType != null) {
            if (this.applicationType.getApplicationName() != null) {
                this.txtApplicationName.setText(this.applicationType.getApplicationName());
            } else {
                this.txtApplicationName.setText("");
            }
        }
        if (this.posixApplicationType != null) {
            if (this.posixApplicationType.getExecutable() != null) {
                this.txtExecutable.setText(this.posixApplicationType.getExecutable().getValue());
            } else {
                this.txtExecutable.setText("");
            }
            if (this.posixApplicationType.getInput() != null) {
                this.txtInput.setText(this.posixApplicationType.getInput().getValue());
            } else {
                this.txtInput.setText("");
            }
            if (this.posixApplicationType.getOutput() != null) {
                this.txtOutput.setText(this.posixApplicationType.getOutput().getValue());
            } else {
                this.txtOutput.setText("");
            }
            if (this.posixApplicationType.getError() != null) {
                this.txtError.setText(this.posixApplicationType.getError().getValue());
            } else {
                this.txtError.setText("");
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }

    public void notifyChanged(Notification msg) {
        if (this.isNotifyAllowed && this.posixApplicationType != null && this.posixApplicationType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.posixApplicationType);
            this.posixApplicationType = null;
        }
    }

    protected EObject checkProxy(EObject refEObject) {
        EObject eObject = refEObject;
        if (eObject != null && eObject.eIsProxy()) {
            eObject = EcoreUtil.resolve((EObject)eObject, (EObject)this.posixApplicationType);
        }
        return eObject;
    }

    protected void checkApplicationElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(1);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            if (this.applicationType == null) {
                this.applicationType = JsdlFactory.eINSTANCE.createApplicationType();
            }
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.applicationType);
        }
    }

    protected void checkPosixApplicationElement() {
        EStructuralFeature eStructuralFeature = this.documentRoot.eClass().getEStructuralFeature(18);
        this.checkApplicationElement();
        if (!this.applicationType.eIsSet(eStructuralFeature) && this.posixApplicationType == null) {
            this.posixApplicationType = PosixFactory.eINSTANCE.createPOSIXApplicationType();
            ArrayList<POSIXApplicationType> collection = new ArrayList<POSIXApplicationType>();
            collection.add(this.posixApplicationType);
            this.applicationType.eSet(eStructuralFeature, collection);
        }
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            TreeIterator iterator = this.jobDefinitionType.eAllContents();
            while (iterator.hasNext()) {
                EObject testType = (EObject)iterator.next();
                if (testType instanceof JobDescriptionType) {
                    this.jobDescriptionType = (JobDescriptionType)testType;
                    continue;
                }
                if (testType instanceof ApplicationType) {
                    this.applicationType = (ApplicationType)testType;
                    continue;
                }
                if (!(testType instanceof POSIXApplicationType)) continue;
                this.posixApplicationType = (POSIXApplicationType)testType;
                this.posixApplicationType.eAdapters().add((Object)this);
            }
            this.fillFields();
        }
    }
}

