/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.OperatingSystemType;
import eu.geclipse.jsdl.model.base.OperatingSystemTypeEnumeration;
import eu.geclipse.jsdl.model.base.OperatingSystemTypeType;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import java.util.Arrays;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OperatingSystemSection
extends JsdlFormPageSection {
    private static final int WIDGET_HEIGHT = 100;
    protected JobDescriptionType jobDescriptionType = JsdlFactory.eINSTANCE.createJobDescriptionType();
    protected ResourcesType resourcesType = JsdlFactory.eINSTANCE.createResourcesType();
    protected OperatingSystemType operatingSystemType = JsdlFactory.eINSTANCE.createOperatingSystemType();
    protected OperatingSystemTypeType operatingSystemTypeType = JsdlFactory.eINSTANCE.createOperatingSystemTypeType();
    protected Label lblOperSystType = null;
    protected Label lblOperSystVer = null;
    protected Label lblOSDescr = null;
    protected Combo cmbOperSystType = null;
    protected Text txtOSDescr = null;
    protected Text txtOperSystVer = null;

    public OperatingSystemSection(Composite parent, FormToolkit toolkit) {
        this.createSection(parent, toolkit);
    }

    public void setInput(JobDefinitionType jobDefinitionType) {
        this.adapterRefreshed = true;
        this.jobDescriptionType = jobDefinitionType.getJobDescription();
        if (this.jobDescriptionType.getResources() != null) {
            this.resourcesType = this.jobDescriptionType.getResources();
        }
        this.fillFields();
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("ResourcesPage_OperSyst");
        String sectionDescription = Messages.getString("ResourcesPage_OperSystDescr");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 2);
        GridData gd = new GridData();
        gd.widthHint = 280;
        this.lblOperSystType = toolkit.createLabel(client, Messages.getString("ResourcesPage_OperSystType"));
        this.cmbOperSystType = new Combo(client, 76);
        this.cmbOperSystType.setData((Object)"FormWidgetFactory.drawBorder");
        EEnum cFEnum = JsdlPackage.Literals.OPERATING_SYSTEM_TYPE_ENUMERATION;
        this.cmbOperSystType.add("");
        int i = 0;
        while (i < cFEnum.getELiterals().size()) {
            this.cmbOperSystType.add(cFEnum.getEEnumLiteral(i).toString());
            ++i;
        }
        Object[] sortedTypes = this.cmbOperSystType.getItems();
        Arrays.sort(sortedTypes);
        this.cmbOperSystType.setItems((String[])sortedTypes);
        this.cmbOperSystType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedOSName = OperatingSystemSection.this.cmbOperSystType.getItem(OperatingSystemSection.this.cmbOperSystType.getSelectionIndex());
                if (selectedOSName.equals("")) {
                    OperatingSystemSection.this.deleteElement((EObject)OperatingSystemSection.this.operatingSystemType);
                    OperatingSystemSection.this.txtOperSystVer.setText("");
                    OperatingSystemSection.this.txtOSDescr.setText("");
                    OperatingSystemSection.this.operatingSystemType = null;
                } else {
                    OperatingSystemSection.this.checkOSElement();
                    OperatingSystemSection.this.operatingSystemTypeType.setOperatingSystemName(OperatingSystemTypeEnumeration.get((String)selectedOSName));
                    OperatingSystemSection.this.operatingSystemType.setOperatingSystemType(OperatingSystemSection.this.operatingSystemTypeType);
                }
                OperatingSystemSection.this.contentChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbOperSystType.setLayoutData((Object)gd);
        this.lblOperSystVer = toolkit.createLabel(client, Messages.getString("ResourcesPage_OperSystVersion"));
        this.txtOperSystVer = toolkit.createText(client, "", 0);
        this.txtOperSystVer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!OperatingSystemSection.this.txtOperSystVer.getText().equals("")) {
                    OperatingSystemSection.this.checkOSElement();
                    OperatingSystemSection.this.operatingSystemType.setOperatingSystemVersion(OperatingSystemSection.this.txtOperSystVer.getText());
                } else if (OperatingSystemSection.this.operatingSystemType != null) {
                    OperatingSystemSection.this.operatingSystemType.setOperatingSystemVersion(null);
                }
                OperatingSystemSection.this.contentChanged();
            }
        });
        this.txtOperSystVer.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.lblOSDescr = toolkit.createLabel(client, Messages.getString("ResourcesPage_DEscr"));
        this.lblOSDescr.setLayoutData((Object)gd);
        gd = new GridData();
        this.txtOSDescr = toolkit.createText(client, "", 832);
        this.txtOSDescr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!OperatingSystemSection.this.txtOSDescr.getText().equals("")) {
                    OperatingSystemSection.this.checkOSElement();
                    OperatingSystemSection.this.operatingSystemType.setDescription(OperatingSystemSection.this.txtOSDescr.getText());
                } else if (OperatingSystemSection.this.operatingSystemType != null) {
                    OperatingSystemSection.this.operatingSystemType.setDescription(null);
                }
                OperatingSystemSection.this.contentChanged();
            }
        });
        gd.widthHint = 265;
        gd.heightHint = 100;
        this.txtOSDescr.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
    }

    protected void checkResourcesElement() {
        EStructuralFeature eStructuralFeature = this.jobDescriptionType.eClass().getEStructuralFeature(2);
        if (!this.jobDescriptionType.eIsSet(eStructuralFeature)) {
            this.jobDescriptionType.eSet(eStructuralFeature, (Object)this.resourcesType);
        } else if (!this.resourcesType.isExclusiveExecution() && this.resourcesType.eContents().size() == 0) {
            EcoreUtil.remove((EObject)this.resourcesType);
        }
    }

    protected void checkOSElement() {
        this.checkResourcesElement();
        EStructuralFeature eStructuralFeature = this.resourcesType.eClass().getEStructuralFeature(3);
        if (!this.resourcesType.eIsSet(eStructuralFeature)) {
            if (this.operatingSystemType == null) {
                this.operatingSystemType = JsdlFactory.eINSTANCE.createOperatingSystemType();
            }
            this.resourcesType.eSet(eStructuralFeature, (Object)this.operatingSystemType);
        }
    }

    protected void deleteElement(EObject eStructuralFeature) {
        if (eStructuralFeature != null) {
            try {
                EcoreUtil.remove((EObject)eStructuralFeature);
                this.checkResourcesElement();
            }
            catch (Exception e) {
                Activator.logException(e);
            }
        }
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.resourcesType.getOperatingSystem() != null) {
            this.operatingSystemType = this.resourcesType.getOperatingSystem();
            if (this.operatingSystemType.getOperatingSystemType() != null) {
                this.cmbOperSystType.setText(this.operatingSystemType.getOperatingSystemType().getOperatingSystemName().getLiteral());
            }
            if (this.operatingSystemType.getOperatingSystemVersion() != null) {
                this.txtOperSystVer.setText(this.operatingSystemType.getOperatingSystemVersion());
            } else {
                this.txtOperSystVer.setText("");
            }
            if (this.operatingSystemType.getDescription() != null) {
                this.txtOSDescr.setText(this.operatingSystemType.getDescription());
            } else {
                this.txtOSDescr.setText("");
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

