/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.sweep.AssignmentType;
import eu.geclipse.jsdl.model.sweep.SweepType;
import eu.geclipse.jsdl.parametric.IParametricJsdlGenerator;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricGenerationCanceled;
import eu.geclipse.jsdl.parametric.ParametricJsdlGeneratorFactory;
import eu.geclipse.jsdl.ui.adapters.jsdl.ParametricJobAdapter;
import eu.geclipse.jsdl.ui.internal.EditorParametricJsdlHandler;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.NewParametricPage;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.parameters.IterationsLProvider;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SweepIterationsSection
extends JsdlFormPageSection {
    private Shell shell;
    private Table table;
    private JobDefinitionType jobDefinitionType;
    private TableViewer viewer;
    private IterationsLProvider labelProvider;
    private JSDLJobDescription jsdlJobDescription;
    private Composite client;
    private ArrayList<SweepType> sweepType;

    public SweepIterationsSection(Composite parent, FormToolkit toolkit, ParametricJobAdapter adapter) {
        this.createSection(parent, toolkit);
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        this.shell = parent.getShell();
        String sectionDescription = "Values of each parameter for every iteration of parameters sweep.";
        this.client = FormSectionFactory.createExpandableSection(toolkit, parent, "Iterations preview", sectionDescription, 1, false);
        Hyperlink link = toolkit.createHyperlink(this.client, "Calculate iterations (refresh)", 16384);
        link.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (SweepIterationsSection.this.parentPage != null && SweepIterationsSection.this.parentPage.isDirty()) {
                    MessageDialog.openWarning((Shell)SweepIterationsSection.this.shell, (String)"Unsaved JSDL", (String)"JSDL file was modified, but changes were not saved. If you would like to see iterations preview taking into account changes made to JSDL model, please save the file and generate iterations one more time.");
                }
                SweepIterationsSection.this.updateTable();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.renewTableViewer(new EditorParametricJsdlHandler(this));
    }

    protected void updateTable() {
        final EditorParametricJsdlHandler handler = new EditorParametricJsdlHandler(this);
        this.renewTableViewer(handler);
        this.viewer.setInput((Object)handler);
        this.viewer.setContentProvider((IContentProvider)handler);
        final JSDLJobDescription jsdl = this.jsdlJobDescription;
        Job job = new Job("Generating sweep for iterations"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IParametricJsdlGenerator generator = ParametricJsdlGeneratorFactory.getGenerator((String)jsdl.getAsString());
                    handler.setMonitor(monitor);
                    generator.generate((IParametricJsdlHandler)handler);
                }
                catch (ParametricGenerationCanceled parametricGenerationCanceled) {
                    throw new OperationCanceledException();
                }
                catch (Exception exception) {
                    final Exception pexc = exception;
                    final Shell fShell = SweepIterationsSection.this.shell;
                    fShell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ProblemDialog.openProblem((Shell)fShell, (String)"JSDLs preview", (String)"Generation JSDLs for preview failed", (Throwable)pexc);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void renewTableViewer(EditorParametricJsdlHandler handler) {
        List widths = Collections.emptyList();
        if (this.viewer != null) {
            TableColumn[] columns = this.viewer.getTable().getColumns();
            if (columns.length > 1) {
                widths = new ArrayList(columns.length);
                TableColumn[] tableColumnArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    widths.add(column.getWidth());
                    ++n2;
                }
            }
            this.viewer.getTable().dispose();
        }
        this.viewer = null;
        this.viewer = new TableViewer(this.client, 67584);
        TableWrapData tableData = new TableWrapData(256);
        tableData.heightHint = 300;
        this.table = this.viewer.getTable();
        this.table.setLayoutData((Object)tableData);
        this.labelProvider = new IterationsLProvider();
        this.labelProvider.setColumnNames(this.getColumnNamesForTable());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)handler);
        this.table.setHeaderVisible(true);
        List<String> columnNames = this.getColumnNamesForTable();
        int colIndex = 0;
        for (String name : columnNames) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(name);
            column.setWidth(colIndex < widths.size() ? (Integer)widths.get(colIndex) : 90);
            ++colIndex;
        }
        this.client.layout();
    }

    public void setInput(JobDefinitionType jobDefinition, JSDLJobDescription jsdlJobDescr) {
        this.adapterRefreshed = true;
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
        }
        this.jsdlJobDescription = jsdlJobDescr;
    }

    public void iterationGenerated(List<String> newRow) {
        final TableViewer viewerF = this.viewer;
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                viewerF.refresh(false);
            }
        });
    }

    private List<String> getColumnNamesForTable() {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("Iteration");
        for (String paramName : this.getInerSweepNames(this.getInnerList())) {
            columnNames.add(paramName);
        }
        return columnNames;
    }

    @Override
    protected void contentChanged() {
        this.labelProvider.setColumnNames(this.getColumnNamesForTable());
        super.contentChanged();
    }

    private List<SweepType> getInnerList() {
        ArrayList<SweepType> inerSweepList = new ArrayList<SweepType>();
        this.sweepType = new ArrayList();
        if (this.jobDefinitionType != null) {
            TreeIterator iterator = this.jobDefinitionType.eAllContents();
            while (iterator.hasNext()) {
                EObject testType = (EObject)iterator.next();
                if (!(testType instanceof SweepType) || testType.eContainer() instanceof SweepType) continue;
                SweepType type = (SweepType)testType;
                type.eAdapters().add((Object)this);
                this.sweepType.add(type);
            }
            if (!this.sweepType.isEmpty()) {
                for (SweepType type : this.sweepType) {
                    TreeIterator it = type.eAllContents();
                    while (it.hasNext()) {
                        EObject testObject = (EObject)it.next();
                        if (!(testObject instanceof SweepType)) continue;
                        inerSweepList.add((SweepType)testObject);
                    }
                }
                inerSweepList.addAll(this.sweepType);
            }
        }
        return inerSweepList;
    }

    private List<String> getInerSweepNames(List<SweepType> inerSweepList) {
        ArrayList<String> result = new ArrayList<String>();
        for (SweepType sweep : inerSweepList) {
            EList list = sweep.getAssignment();
            int i = 0;
            while (i < list.size()) {
                Object el = list.get(i);
                if (el instanceof AssignmentType) {
                    AssignmentType assignment = (AssignmentType)el;
                    EList paramList = assignment.getParameter();
                    int j = 0;
                    while (j < paramList.size()) {
                        result.add((String)paramList.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public IterationsLProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setParentPage(NewParametricPage newParametricPage) {
        this.parentPage = newParametricPage;
    }
}

