/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.sweep.AssignmentType;
import eu.geclipse.jsdl.model.sweep.SweepType;
import eu.geclipse.jsdl.ui.adapters.jsdl.ParametricJobAdapter;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SweepValuesSection
extends JsdlFormPageSection {
    private ParametricJobAdapter adapter;
    private List<SweepType> sweepType;
    private JobDefinitionType jobDefinitionType;
    private JobDescriptionType jobDescriptionType;
    private List<SweepType> inerSweepList;
    private Combo sweepListCombo;
    private Shell shell;

    public SweepValuesSection(Composite parent, FormToolkit toolkit, ParametricJobAdapter adapter) {
        this.adapter = adapter;
        this.createSection(parent, toolkit);
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        this.shell = parent.getShell();
        String sectionTitle = "Sweep values";
        String sectionDescription = "Specify the values of parameters";
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 1);
        this.sweepListCombo = new Combo(client, 0);
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        this.sweepType = new ArrayList<SweepType>();
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            TreeIterator iterator = this.jobDefinitionType.eAllContents();
            while (iterator.hasNext()) {
                EObject testType = (EObject)iterator.next();
                if (testType instanceof JobDescriptionType) {
                    this.jobDescriptionType = (JobDescriptionType)testType;
                    continue;
                }
                if (!(testType instanceof SweepType) || testType.eContainer() instanceof SweepType) continue;
                SweepType type = (SweepType)testType;
                type.eAdapters().add((Object)this);
                this.sweepType.add(type);
            }
            this.inerSweepList = new ArrayList<SweepType>();
            if (!this.sweepType.isEmpty()) {
                for (SweepType type : this.sweepType) {
                    TreeIterator it = type.eAllContents();
                    while (it.hasNext()) {
                        EObject testObject = (EObject)it.next();
                        if (!(testObject instanceof SweepType)) continue;
                        this.inerSweepList.add((SweepType)testObject);
                    }
                }
                this.inerSweepList.addAll(this.sweepType);
            }
            this.fillFields();
        }
    }

    private void fillFields() {
        if (this.sweepListCombo != null) {
            this.sweepListCombo.removeAll();
            for (String name : this.getInerSweepNames()) {
                this.sweepListCombo.add(name);
            }
        }
    }

    private List<String> getInerSweepNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (SweepType sweep : this.inerSweepList) {
            EList list = sweep.getAssignment();
            int i = 0;
            while (i < list.size()) {
                Object el = list.get(i);
                if (el instanceof AssignmentType) {
                    AssignmentType assignment = (AssignmentType)el;
                    EList paramList = assignment.getParameter();
                    int j = 0;
                    while (j < paramList.size()) {
                        result.add((String)paramList.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

