/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.wizards;

import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.internal.wizards.Messages;
import eu.geclipse.jsdl.ui.internal.wizards.Range;
import eu.geclipse.ui.widgets.TabComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLRangesTab
extends TabComponent {
    public JSDLRangesTab(IStructuredContentProvider contentProvider, ITableLabelProvider labelProvider, List<String> columnsProperties, int hight, int width) {
        super(contentProvider, labelProvider, columnsProperties, hight, width);
    }

    protected void handleAddButtonSelected() {
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), Messages.getString("JSDLRangesTab.new_value"));
        dialog.addTextField(Messages.getString("JSDLRangesTab.range_start"), null, false);
        dialog.addTextField(Messages.getString("JSDLRangesTab.range_end"), null, false);
        if (dialog.open() != 0) {
            return;
        }
        String start = dialog.getStringValue(Messages.getString("JSDLRangesTab.range_start"));
        String end = dialog.getStringValue(Messages.getString("JSDLRangesTab.range_end"));
        try {
            Range range = new Range(Double.valueOf(start), Double.valueOf(end));
            this.addVariable(range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.bad_range_format"), (String)Messages.getString("JSDLRangesTab.bad_range_format"));
        }
    }

    protected void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.table.getSelection();
        Range var = (Range)sel.getFirstElement();
        if (var != null) {
            String oldStart = Double.valueOf(var.getStart()).toString();
            String oldEnd = Double.valueOf(var.getEnd()).toString();
            MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), Messages.getString("OutputFilesTab.edit_output_file_settings_dialog_title"));
            ArrayList<String> comboData = new ArrayList<String>();
            FileType[] fileTypeArray = FileType.values();
            int n = fileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FileType fileType = fileTypeArray[n2];
                comboData.add(fileType.toString());
                ++n2;
            }
            dialog.addTextField("Range start", oldStart, false);
            dialog.addTextField(Messages.getString("JSDLRangesTab.range_end"), oldEnd, false);
            if (dialog.open() == 0) {
                try {
                    String newStart = dialog.getStringValue(Messages.getString("JSDLRangesTab.range_start"));
                    String newEnd = dialog.getStringValue(Messages.getString("JSDLRangesTab.range_end"));
                    if (!oldStart.equals(newStart) || !oldEnd.equals(newEnd)) {
                        Range newRange = new Range(Double.valueOf(newStart), Double.valueOf(newEnd));
                        if (this.addVariable(newRange)) {
                            this.table.remove((Object)var);
                        }
                    } else {
                        var.setStart(Double.valueOf(newStart));
                        var.setEnd(Double.valueOf(newEnd));
                        this.table.update((Object)var, null);
                        this.updateLaunchConfigurationDialog();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.bad_range_format"), (String)Messages.getString("JSDLRangesTab.bad_range_format"));
                }
            }
        }
    }

    protected void handleRemoveButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.table.getSelection();
        this.table.getControl().setRedraw(false);
        for (Range var : sel) {
            this.table.remove((Object)var);
        }
        this.table.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void setLabels() {
        this.addButton.setText(Messages.getString("JSDLRangesTab.add_button"));
        this.editButton.setText(Messages.getString("JSDLRangesTab.edit_button"));
        this.removeButton.setText(Messages.getString("JSDLRangesTab.remove_button"));
    }

    protected boolean addVariable(Range variable) {
        boolean result = true;
        TableItem[] items = this.table.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            Range existingVariable = (Range)items[i].getData();
            if (existingVariable.equals(variable)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.rnage_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message")) + existingVariable.getStart() + ", " + existingVariable.getEnd() + ")"));
                result = false;
                break;
            }
            if (existingVariable.getStart() >= variable.getStart() && existingVariable.getStart() < variable.getEnd()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.range_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message_1")) + existingVariable.getStart() + ", " + existingVariable.getEnd() + ")"));
                result = false;
                break;
            }
            if (variable.getStart() >= existingVariable.getStart() && variable.getStart() < existingVariable.getEnd()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.range_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message_1")) + existingVariable.getStart() + ", " + existingVariable.getEnd() + ")"));
                result = false;
                break;
            }
            ++i;
        }
        if (result) {
            this.table.add((Object)variable);
        }
        return result;
    }
}

