/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.preference;

import eu.geclipse.core.model.impl.GridApplicationParameters;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.preference.ApplicationParametersException;
import eu.geclipse.jsdl.ui.preference.ApplicationParametersRegistry;
import eu.geclipse.jsdl.ui.preference.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationParametersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IContentChangeListener {
    TableViewer appsViewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Table appsTable;
    private Button refreshButton;

    public ApplicationParametersPreferencePage() {
        this.setDescription(Messages.getString("ApplicationSpecificPreferencePage.description"));
        ApplicationParametersRegistry.getInstance().addContentChangeListener(this);
    }

    public void dispose() {
        ApplicationParametersRegistry.getInstance().removeContentChangeListener(this);
        super.dispose();
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        Composite mainComp = new Composite(parent, 0);
        GridLayout gLayout = new GridLayout(1, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        mainComp.setLayout((Layout)gLayout);
        this.initializeDialogUnits((Control)mainComp);
        this.appsTable = new Table(mainComp, 268503042);
        this.appsTable.setHeaderVisible(true);
        this.appsTable.setLinesVisible(true);
        gData = new GridData(4, 4, true, true);
        this.appsTable.setLayoutData((Object)gData);
        TableLayout tableLayout = new TableLayout();
        this.appsTable.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(this.appsTable, 0x1000000);
        ColumnWeightData data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)data);
        nameColumn.setText("Name");
        TableColumn typeColumn = new TableColumn(this.appsTable, 16384);
        typeColumn.setText("Path");
        TableColumn xmlColumn = new TableColumn(this.appsTable, 16384);
        xmlColumn.setText("XML file");
        TableColumn jsdlColumn = new TableColumn(this.appsTable, 16384);
        jsdlColumn.setText("JSDL file");
        this.appsViewer = new TableViewer(this.appsTable);
        ApplicationSpecificPageContentProvider contentProvider = new ApplicationSpecificPageContentProvider();
        this.appsViewer.setContentProvider((IContentProvider)contentProvider);
        this.appsViewer.setLabelProvider((IBaseLabelProvider)new ApplicationSpecificLabelProvider());
        this.appsViewer.setInput((Object)contentProvider.getElements(null));
        this.appsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApplicationParametersPreferencePage.this.updateButtons();
            }
        });
        Composite buttonsComp = new Composite(mainComp, 0);
        gLayout = new GridLayout(4, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        buttonsComp.setLayout((Layout)gLayout);
        gData = new GridData(130);
        gData.horizontalSpan = 1;
        buttonsComp.setLayoutData((Object)gData);
        this.refreshButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.refreshButton.setLayoutData((Object)gData);
        this.refreshButton.setText(Messages.getString("ApplicationParametersPreferencePage.refresh_list"));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApplicationParametersPreferencePage.this.fetchApplications();
            }
        });
        this.addButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.addButton.setLayoutData((Object)gData);
        this.addButton.setText(Messages.getString("ApplicationSpecificPreferencePage.add_button"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ApplicationParametersPreferencePage.this.editAppliactionSpecificData(null);
            }
        });
        this.editButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.editButton.setLayoutData((Object)gData);
        this.editButton.setText(Messages.getString("ApplicationSpecificPreferencePage.edit_button"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ApplicationParametersPreferencePage.this.editAppliactionSpecificData(ApplicationParametersPreferencePage.this.getSelectedAppSpecificObject());
            }
        });
        this.removeButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.removeButton.setLayoutData((Object)gData);
        this.removeButton.setText(Messages.getString("ApplicationSpecificPreferencePage.delete_button"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (GridApplicationParameters obj : ApplicationParametersPreferencePage.this.getSelectedAppSpecificObjects()) {
                    try {
                        ApplicationParametersRegistry.getInstance().removeApplicationParameters(obj);
                    }
                    catch (ApplicationParametersException e) {
                        ProblemDialog.openProblem((Shell)ApplicationParametersPreferencePage.this.getShell(), (String)Messages.getString("ApplicationSpecificPreferencePage.removing_error_title"), (String)Messages.getString("ApplicationSpecificPreferencePage.removing_error_message"), (Throwable)((Object)e));
                    }
                }
            }
        });
        this.updateButtons();
        return mainComp;
    }

    void fetchApplications() {
        Job job = new Job(Messages.getString("ApplicationParametersPreferencePage.get_apps_params")){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                monitor.beginTask(Messages.getString("ApplicationParametersPreferencePage.updating)_registry"), -1);
                try {
                    try {
                        if (!monitor.isCanceled()) {
                            ApplicationParametersRegistry.getInstance().updateApplicationsParameters(null, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                            monitor.worked(1);
                        }
                    }
                    catch (ProblemException problemE) {
                        result = new Status(4, "eu.geclipse.jsdl.ui", Messages.getString("ApplicationParametersPreferencePage.error_fetching_apps"), (Throwable)problemE);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return result;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    void editAppliactionSpecificData(GridApplicationParameters aSO) {
        if (aSO == null) {
            EditDialog dialog = new EditDialog(this.getShell());
            if (dialog.open() == 0) {
                ApplicationParametersRegistry.getInstance().addApplicationSpecificData(dialog.getAppName(), dialog.getAppPath(), new Path(dialog.getXMLPath()), new Path(dialog.getJSDLPath()), null);
            }
        } else {
            EditDialog dialog;
            String jsdlPath = null;
            if (aSO.getJsdlPath() != null) {
                jsdlPath = aSO.getJsdlPath().toOSString();
            }
            if ((dialog = new EditDialog(this.getShell(), aSO.getApplicationName(), aSO.getApplicationPath(), aSO.getXmlPath().toOSString(), jsdlPath)).open() == 0) {
                try {
                    ApplicationParametersRegistry.getInstance().editApplicationSpecificData(aSO, dialog.getAppName(), dialog.getAppPath(), dialog.getXMLPath(), dialog.getJSDLPath());
                }
                catch (ApplicationParametersException e) {
                    ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("ApplicationSpecificPreferencePage.editing_error_title"), (String)Messages.getString("ApplicationSpecificPreferencePage.editing_error_message"), (Throwable)((Object)e));
                }
            }
        }
    }

    public GridApplicationParameters getSelectedAppSpecificObject() {
        GridApplicationParameters selectedASO = null;
        IStructuredSelection selection = (IStructuredSelection)this.appsViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof GridApplicationParameters) {
            selectedASO = (GridApplicationParameters)obj;
        }
        return selectedASO;
    }

    public List<GridApplicationParameters> getSelectedAppSpecificObjects() {
        ArrayList<GridApplicationParameters> selectedASO = new ArrayList<GridApplicationParameters>();
        IStructuredSelection selection = (IStructuredSelection)this.appsViewer.getSelection();
        for (Object selObject : selection.toList()) {
            if (!(selObject instanceof GridApplicationParameters)) continue;
            selectedASO.add((GridApplicationParameters)selObject);
        }
        return selectedASO;
    }

    protected void updateButtons() {
        ISelection selection = this.appsViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(selectionAvailable);
        this.editButton.setEnabled(selectionAvailable);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void contentChanged(IContentChangeNotifier source) {
        if (source instanceof ApplicationParametersRegistry) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ApplicationParametersPreferencePage.this.appsViewer.refresh();
                }
            });
        }
    }

    class ApplicationSpecificLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ApplicationSpecificLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            GridApplicationParameters asO = (GridApplicationParameters)element;
            switch (columnIndex) {
                case 0: {
                    result = asO.getApplicationName();
                    break;
                }
                case 1: {
                    result = asO.getApplicationPath();
                    break;
                }
                case 2: {
                    result = asO.getXmlPath().toOSString();
                    break;
                }
                case 3: {
                    if (asO.getJsdlPath() == null) break;
                    result = asO.getJsdlPath().toOSString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }

    class ApplicationSpecificPageContentProvider
    implements IStructuredContentProvider {
        ApplicationSpecificPageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = new GridApplicationParameters[]{};
            result = ApplicationParametersRegistry.getInstance().getApplicationParameters(null).toArray(result);
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EditDialog
    extends Dialog {
        Text xmlPath;
        Text jsdlPath;
        private Text appName;
        private Text appPath;
        private String appNameInit;
        private String appPathInit;
        private String xmlPathInit;
        private String jsdlPathInit;
        private String returnAppName;
        private String returnXMLPath;
        private String returnAppPath;
        private String returnJSDLPath;

        protected EditDialog(Shell parentShell) {
            super(parentShell);
        }

        protected EditDialog(Shell parentShell, String appName, String appPath, String xmlPath, String jsdlPath) {
            super(parentShell);
            this.appNameInit = appName;
            this.appPathInit = appPath;
            this.xmlPathInit = xmlPath;
            this.jsdlPathInit = jsdlPath;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.updateButtons();
        }

        void updateButtons() {
            if (!this.appName.getText().equals("") && !this.xmlPath.getText().equals("")) {
                super.getButton(0).setEnabled(true);
            } else {
                super.getButton(0).setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.getString("ApplicationSpecificPreferencePage.editDialogTitle"));
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(1808));
            Composite panel = new Composite(composite, 0);
            this.initializeDialogUnits((Control)composite);
            GridLayout gLayout = new GridLayout(3, false);
            panel.setLayout((Layout)gLayout);
            GridData gd = new GridData(768);
            panel.setLayoutData((Object)gd);
            Label appNameLabel = new Label(panel, 16384);
            appNameLabel.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_application_name_label"));
            gd = new GridData();
            appNameLabel.setLayoutData((Object)gd);
            this.appName = new Text(panel, 2048);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.appName.setLayoutData((Object)gd);
            if (this.appNameInit != null) {
                this.appName.setText(this.appNameInit);
            }
            Label pathNameLabel = new Label(panel, 16384);
            pathNameLabel.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_application_path_label"));
            gd = new GridData();
            pathNameLabel.setLayoutData((Object)new GridData());
            this.appPath = new Text(panel, 2048);
            gd = new GridData(1808);
            gd.widthHint = 250;
            gd.horizontalSpan = 2;
            this.appPath.setLayoutData((Object)gd);
            if (this.appPathInit != null) {
                this.appPath.setText(this.appPathInit);
            }
            Label xmlPathLabel = new Label(panel, 16384);
            xmlPathLabel.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_xml_label"));
            gd = new GridData();
            xmlPathLabel.setLayoutData((Object)new GridData());
            this.xmlPath = new Text(panel, 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.xmlPath.setLayoutData((Object)gd);
            this.xmlPath.setLayoutData((Object)gd);
            if (this.xmlPathInit != null) {
                this.xmlPath.setText(this.xmlPathInit);
            }
            Button browseButton = new Button(panel, 8);
            gd = new GridData();
            browseButton.setLayoutData((Object)gd);
            URL openFileIcon = Activator.getDefault().getBundle().getEntry("icons/obj16/open_file.gif");
            Image openFileImage = ImageDescriptor.createFromURL((URL)openFileIcon).createImage();
            browseButton.setImage(openFileImage);
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog file = new FileDialog(EditDialog.this.getShell());
                    file.setText(Messages.getString("ApplicationSpecificPreferencePage.selectXmlFile"));
                    String connection = file.open();
                    if (connection != null) {
                        EditDialog.this.xmlPath.setText(connection);
                    }
                    EditDialog.this.updateButtons();
                }
            });
            Label jsdlPathLabel = new Label(panel, 16384);
            jsdlPathLabel.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_jsdl_label"));
            gd = new GridData();
            jsdlPathLabel.setLayoutData((Object)new GridData());
            this.jsdlPath = new Text(panel, 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            this.jsdlPath.setLayoutData((Object)gd);
            this.jsdlPath.setLayoutData((Object)gd);
            if (this.jsdlPathInit != null) {
                this.jsdlPath.setText(this.jsdlPathInit);
            }
            Button browseButton1 = new Button(panel, 8);
            gd = new GridData();
            browseButton1.setLayoutData((Object)gd);
            browseButton1.setImage(openFileImage);
            browseButton1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog file = new FileDialog(EditDialog.this.getShell());
                    file.setText(Messages.getString("ApplicationSpecificPreferencePage.selectJsdlFile"));
                    String connection = file.open();
                    if (connection != null) {
                        EditDialog.this.jsdlPath.setText(connection);
                    }
                    EditDialog.this.updateButtons();
                }
            });
            updateAdapter selectionAdapter = new updateAdapter();
            this.appName.addModifyListener((ModifyListener)selectionAdapter);
            this.appPath.addModifyListener((ModifyListener)selectionAdapter);
            this.xmlPath.addModifyListener((ModifyListener)selectionAdapter);
            return composite;
        }

        protected void okPressed() {
            this.returnAppName = this.appName.getText();
            this.returnAppPath = this.appPath.getText();
            this.returnXMLPath = this.xmlPath.getText();
            this.returnJSDLPath = this.jsdlPath.getText();
            super.okPressed();
        }

        public String getAppName() {
            return this.returnAppName;
        }

        public String getAppPath() {
            return this.returnAppPath;
        }

        public String getXMLPath() {
            return this.returnXMLPath;
        }

        public String getJSDLPath() {
            return this.returnJSDLPath;
        }

        class updateAdapter
        implements ModifyListener {
            updateAdapter() {
            }

            public void modifyText(ModifyEvent event) {
                EditDialog.this.updateButtons();
            }
        }
    }
}

