/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.properties;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.ui.properties.Messages;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsdlJobDescSource
extends AbstractPropertySource<JSDLJobDescription> {
    private static List<IProperty<JSDLJobDescription>> staticProperties;

    public JsdlJobDescSource(JSDLJobDescription sourceObject) {
        super((Object)sourceObject);
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return JsdlJobDescSource.class;
    }

    protected List<IProperty<JSDLJobDescription>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = JsdlJobDescSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<JSDLJobDescription>> createProperties() {
        ArrayList<IProperty<JSDLJobDescription>> propertiesList = new ArrayList<IProperty<JSDLJobDescription>>(10);
        propertiesList.add(JsdlJobDescSource.createCpuArchitecture());
        propertiesList.add(JsdlJobDescSource.createOSType());
        propertiesList.add(JsdlJobDescSource.createOSVersion());
        propertiesList.add(JsdlJobDescSource.createCandidateHost());
        propertiesList.add(JsdlJobDescSource.createApplicationName());
        propertiesList.add(JsdlJobDescSource.createInputStagers());
        propertiesList.add(JsdlJobDescSource.createOutputStagers());
        return propertiesList;
    }

    private static IProperty<JSDLJobDescription> createCandidateHost() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_CandidateHosts, Messages.JsdlJobDescSource_Requirements, false){

            public Object getValue(JSDLJobDescription source) {
                String result = "";
                for (String host : source.getCandidateHostsNames()) {
                    result = String.valueOf(result) + ", " + host;
                }
                result = !result.equals("") ? result.substring(2) : null;
                return result;
            }
        };
    }

    private static IProperty<JSDLJobDescription> createCpuArchitecture() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_CpuArchitecture, Messages.JsdlJobDescSource_Requirements, false){

            public Object getValue(JSDLJobDescription source) {
                return source.getCpuArchitectureName();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createOSType() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_OS, Messages.JsdlJobDescSource_RequirementsOS, false){

            public Object getValue(JSDLJobDescription source) {
                return source.getOSTypeName();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createOSVersion() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_OSVersion, Messages.JsdlJobDescSource_RequirementsOS, false){

            public Object getValue(JSDLJobDescription source) {
                return source.getOSVersion();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createApplicationName() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_propAppName, null, false){

            public Object getValue(JSDLJobDescription source) {
                return source.getApplicationName();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createInputStagers() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_propInputDataStagers, null, false){

            public Object getValue(JSDLJobDescription source) {
                return JsdlJobDescSource.formatStagers(source.getDataStagingInStrings());
            }
        };
    }

    private static IProperty<JSDLJobDescription> createOutputStagers() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_propOutputDataStagers, null, false){

            public Object getValue(JSDLJobDescription source) {
                return JsdlJobDescSource.formatStagers(source.getDataStagingOutStrings());
            }
        };
    }

    protected static Object formatStagers(Map<String, String> dataStagings) {
        String value = null;
        if (dataStagings != null) {
            for (String stagerName : dataStagings.keySet()) {
                value = value == null ? stagerName : String.valueOf(value) + ", " + stagerName;
            }
        }
        return value;
    }
}

