/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.widgets;

import eu.geclipse.jsdl.JSDLModelFacade;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.ui.internal.dialogs.DataStagingInDialog;
import eu.geclipse.jsdl.ui.widgets.Messages;
import eu.geclipse.ui.dialogs.GridFileDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStageInTable {
    public static final int BUTTONS_RIGHT = 0;
    public static final int BUTTONS_BOTTOM = 1;
    TableViewer tableViewer;
    List<DataStagingType> input = new ArrayList<DataStagingType>();
    Composite mainComp;
    private Table table;
    private Button addButton;
    private Button editButton;
    private Button removeButton;

    public DataStageInTable(Composite parent, int buttonsPosition) {
        this(parent, new ArrayList<DataStagingType>(), buttonsPosition);
    }

    public DataStageInTable(Composite parent, List<DataStagingType> input, int buttonsPosition) {
        this.input = input;
        this.mainComp = new Composite(parent, 0);
        GridLayout gLayout = buttonsPosition == 0 ? new GridLayout(2, false) : new GridLayout(1, false);
        this.mainComp.setLayout((Layout)gLayout);
        GridData gData = new GridData(1808);
        this.mainComp.setLayoutData((Object)gData);
        this.table = new Table(this.mainComp, 268503042);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        gData = new GridData(1808);
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 400;
        gData.heightHint = 100;
        this.table.setLayoutData((Object)gData);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(this.table, 0x1000000);
        ColumnWeightData data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)data);
        data = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)data);
        nameColumn.setText(Messages.getString("DataStageInTable.source_location_field_label"));
        TableColumn typeColumn = new TableColumn(this.table, 16384);
        typeColumn.setText(Messages.getString("DataStageInTable.name_field_label"));
        this.tableViewer = new TableViewer(this.table);
        DataStageInContentProvider contentProvider = new DataStageInContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        this.tableViewer.setColumnProperties(new String[]{Messages.getString("DataStageInTable.source_location_field_label"), Messages.getString("DataStageInTable.name_field_label")});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DataStageInContentLabelProvider());
        if (this.input == null) {
            this.input = new ArrayList<DataStagingType>();
        }
        this.tableViewer.setInput(this.input);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataStageInTable.this.updateButtons();
            }
        });
        Composite buttonsComp = new Composite(this.mainComp, 0);
        gLayout = buttonsPosition == 1 ? new GridLayout(3, true) : new GridLayout(1, false);
        buttonsComp.setLayout((Layout)gLayout);
        this.addButton = new Button(buttonsComp, 8);
        gData = new GridData(130);
        buttonsComp.setLayoutData((Object)gData);
        gData = new GridData(1808);
        this.addButton.setLayoutData((Object)gData);
        this.addButton.setText(Messages.getString("DataStageInTable.add_button_label"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInTable.this.editDataStagingEntry(null);
            }
        });
        this.editButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.editButton.setLayoutData((Object)gData);
        this.editButton.setText(Messages.getString("DataStageInTable.edit_button_label"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInTable.this.editDataStagingEntry(DataStageInTable.this.getSelectedObject());
            }
        });
        this.removeButton = new Button(buttonsComp, 8);
        gData = new GridData(1808);
        this.removeButton.setLayoutData((Object)gData);
        this.removeButton.setText(Messages.getString("DataStageInTable.remove_button_label"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataStageInTable.this.input.remove(DataStageInTable.this.getSelectedObject());
                DataStageInTable.this.tableViewer.refresh();
            }
        });
        DialogCellEditor editor = new DialogCellEditor(){

            protected Object openDialogBox(Control cellEditorWindow) {
                URI[] uris;
                String filename = (String)this.doGetValue();
                GridFileDialog dialog = new GridFileDialog(DataStageInTable.this.mainComp.getShell(), 40);
                if (dialog.open() == 0 && (uris = dialog.getSelectedURIs()) != null && uris.length > 0) {
                    filename = uris[0].toString();
                }
                return filename;
            }
        };
        CellEditor[] table1 = new CellEditor[]{editor};
        editor.create((Composite)this.table);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                int columnIndex = -1;
                if (property.equals(Messages.getString("DataStageInTable.source_location_field_label"))) {
                    columnIndex = 0;
                }
                if (property.equals(Messages.getString("DataStageInTable.name_field_label"))) {
                    columnIndex = 1;
                }
                String result = null;
                DataStagingType data1 = (DataStagingType)element;
                switch (columnIndex) {
                    case 0: {
                        result = data1.getSource().getURI();
                        break;
                    }
                    case 1: {
                        result = data1.getFileName();
                        break;
                    }
                    default: {
                        result = "";
                    }
                }
                return result;
            }

            public void modify(Object element, String property, Object value) {
                int columnIndex = -1;
                if (property.equals(Messages.getString("DataStageInTable.source_location_field_label"))) {
                    columnIndex = 0;
                }
                if (property.equals(Messages.getString("DataStageInTable.name_field_label"))) {
                    columnIndex = 1;
                }
                TableItem item = (TableItem)element;
                DataStagingType dataOld = (DataStagingType)item.getData();
                DataStagingType dataNew = null;
                switch (columnIndex) {
                    case 0: {
                        dataNew = DataStageInTable.this.getNewDataStagingType(dataOld.getFileName(), (String)value);
                        if (dataNew.getFileName().equals(dataOld.getFileName()) && dataNew.getSource().getURI().equals(dataOld.getSource().getURI())) break;
                        if (!DataStageInTable.this.isDataInInput(dataNew)) {
                            DataStageInTable.this.updateDataStaging(dataOld, dataNew.getFileName(), dataNew.getSource());
                            DataStageInTable.this.tableViewer.refresh();
                            break;
                        }
                        MessageDialog.openError((Shell)DataStageInTable.this.mainComp.getShell(), (String)Messages.getString("DataStageInTable.edit_dialog_title"), (String)Messages.getString("DataStageInTable.value_exists_dialog_message"));
                        break;
                    }
                    case 1: {
                        dataNew = DataStageInTable.this.getNewDataStagingType((String)value, dataOld.getSource().getURI());
                        if (dataNew.getFileName().equals(dataOld.getFileName()) && dataNew.getSource().getURI().equals(dataOld.getSource().getURI())) break;
                        if (!DataStageInTable.this.isDataInInput(dataNew)) {
                            DataStageInTable.this.updateDataStaging(dataOld, dataNew.getFileName(), dataNew.getSource());
                            DataStageInTable.this.tableViewer.refresh();
                            break;
                        }
                        MessageDialog.openError((Shell)DataStageInTable.this.mainComp.getShell(), (String)Messages.getString("DataStageInTable.edit_dialog_title"), (String)Messages.getString("DataStageInTable.value_exists_dialog_message"));
                    }
                }
            }
        });
        CellEditor[] edTable = new CellEditor[]{editor, new TextCellEditor((Composite)this.tableViewer.getTable())};
        this.tableViewer.setCellEditors(edTable);
        TableViewerEditor.create((TableViewer)this.tableViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer), (int)26);
        this.updateButtons();
    }

    DataStagingType getSelectedObject() {
        DataStagingType result = null;
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof DataStagingType) {
            result = (DataStagingType)obj;
        }
        return result;
    }

    public List<DataStagingType> getDataStagingType() {
        return this.input;
    }

    public void setInput(List<DataStagingType> input) {
        this.input = input;
        if (this.input == null) {
            this.input = new ArrayList<DataStagingType>();
        }
        this.tableViewer.setInput(this.input);
    }

    void editDataStagingEntry(DataStagingType selectedObject) {
        block6: {
            block5: {
                if (selectedObject != null) break block5;
                DataStagingInDialog dialog = new DataStagingInDialog(this.mainComp.getShell(), 0);
                if (dialog.open() != 0) break block6;
                for (DataStagingType newData : this.getNewDataStagingType(dialog.getDataStageInList())) {
                    if (!this.isDataInInput(newData)) {
                        this.input.add(newData);
                        this.tableViewer.refresh();
                        continue;
                    }
                    MessageDialog.openError((Shell)this.mainComp.getShell(), (String)Messages.getString("DataStageInTable.value_exists_dialog_title"), (String)Messages.getString("DataStagingPage_New_DuplicateEntryDialog_Message"));
                }
                break block6;
            }
            DataStagingInDialog dialog = new DataStagingInDialog(this.mainComp.getShell(), 0, selectedObject);
            if (dialog.open() == 0) {
                for (DataStagingType newData : this.getNewDataStagingType(dialog.getDataStageInList())) {
                    if (newData.getFileName().equals(selectedObject.getFileName()) && newData.getSource().getURI().equals(selectedObject.getSource().getURI())) continue;
                    if (!this.isDataInInput(newData)) {
                        this.updateDataStaging(selectedObject, newData.getFileName(), newData.getSource());
                        this.tableViewer.refresh();
                        continue;
                    }
                    MessageDialog.openError((Shell)this.mainComp.getShell(), (String)Messages.getString("DataStageInTable.edit_dialog_title"), (String)Messages.getString("DataStageInTable.value_exists_dialog_message"));
                }
            }
        }
    }

    void updateDataStaging(DataStagingType selectedObject, String name, SourceTargetType source) {
        selectedObject.setFileName(name);
        selectedObject.getSource().setURI(source.getURI());
    }

    boolean isDataInInput(DataStagingType newData) {
        boolean result = false;
        for (DataStagingType data : this.input) {
            if (!data.getFileName().equals(newData.getFileName()) || !data.getSource().getURI().equals(newData.getSource().getURI())) continue;
            result = true;
        }
        return result;
    }

    List<DataStagingType> getNewDataStagingType(ArrayList<DataStagingType> dataStageList) {
        ArrayList<DataStagingType> result = new ArrayList<DataStagingType>();
        SourceTargetType source = null;
        DataStagingType dsType = null;
        int i = 0;
        while (i < dataStageList.size()) {
            dsType = JSDLModelFacade.getDataStagingType();
            source = JSDLModelFacade.getSourceTargetType();
            DataStagingType temp = dataStageList.get(i);
            dsType.setFileName(temp.getFileName());
            source.setURI(temp.getSource().getURI());
            dsType.setSource(source);
            dsType.setCreationFlag(JSDLModelFacade.getDefaultCreationFlag());
            dsType.setDeleteOnTermination(true);
            result.add(dsType);
            ++i;
        }
        return result;
    }

    DataStagingType getNewDataStagingType(String name, String path) {
        DataStagingType result = JSDLModelFacade.getDataStagingType();
        result.setFileName(name);
        SourceTargetType source = JSDLModelFacade.getSourceTargetType();
        source.setURI(path);
        result.setSource(source);
        return result;
    }

    protected void updateButtons() {
        ISelection selection = this.tableViewer.getSelection();
        boolean selectionAvailable = !selection.isEmpty();
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(selectionAvailable);
        this.editButton.setEnabled(selectionAvailable);
    }

    public void updateInput(List<DataStagingType> newInput) {
        this.input = newInput;
        this.tableViewer.setInput(this.input);
    }

    class DataStageInContentLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DataStageInContentLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            if (element != null) {
                DataStagingType var = (DataStagingType)element;
                switch (columnIndex) {
                    case 0: {
                        result = var.getSource().getURI();
                        break;
                    }
                    case 1: {
                        result = var.getFileName();
                    }
                }
            }
            return result;
        }
    }

    class DataStageInContentProvider
    implements IStructuredContentProvider {
        DataStageInContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new DataStagingType[]{};
            elements = ((List)inputElement).toArray(new DataStagingType[0]);
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

