/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.widgets;

import eu.geclipse.jsdl.ui.widgets.Messages;
import eu.geclipse.ui.widgets.NumberVerifier;
import java.math.BigInteger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SweepLoopDialog
extends Dialog
implements ModifyListener {
    private static final String SEPARATOR_PROPERTY = "line.separator";
    private Text startValueText;
    private Text endValueText;
    private Text stepValueText;
    private Text exceptionsText;
    private String startReturn;
    private String endReturn;
    private String stepReturn;
    private String[] exceptionsReturn = new String[0];

    public SweepLoopDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = new Composite(parent, 0);
        dialogComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData();
        Label startLabel = new Label(dialogComp, 16384);
        startLabel.setText(Messages.getString("SweepLoopDialog.start_label"));
        startLabel.setLayoutData((Object)new GridData());
        this.startValueText = new Text(dialogComp, 18432);
        this.startValueText.setLayoutData((Object)new GridData(1808));
        this.startValueText.addListener(25, (Listener)new NegativeVerifier());
        this.startValueText.addModifyListener((ModifyListener)this);
        Label endLabel = new Label(dialogComp, 16384);
        endLabel.setText(Messages.getString("SweepLoopDialog.end_label"));
        endLabel.setLayoutData((Object)new GridData());
        this.endValueText = new Text(dialogComp, 18432);
        this.endValueText.setLayoutData((Object)new GridData(1808));
        this.endValueText.addModifyListener((ModifyListener)this);
        this.endValueText.addListener(25, (Listener)new NegativeVerifier());
        Label stepLabel = new Label(dialogComp, 16384);
        stepLabel.setText(Messages.getString("SweepLoopDialog.step_label"));
        stepLabel.setLayoutData((Object)new GridData());
        this.stepValueText = new Text(dialogComp, 18432);
        this.stepValueText.setLayoutData((Object)new GridData(1808));
        this.stepValueText.setText("1");
        this.stepValueText.addModifyListener((ModifyListener)this);
        this.stepValueText.addListener(25, (Listener)new NumberVerifier());
        Label exceptLabel = new Label(dialogComp, 16384);
        exceptLabel.setText(Messages.getString("SweepLoopDialog.excluded_values_label"));
        exceptLabel.setLayoutData((Object)new GridData());
        this.exceptionsText = new Text(dialogComp, 2626);
        gData = new GridData(1808);
        gData.heightHint = 50;
        gData.widthHint = 80;
        this.exceptionsText.setLayoutData((Object)gData);
        this.exceptionsText.addListener(25, (Listener)new NegativeVerifier());
        return dialogComp;
    }

    protected void okPressed() {
        BigInteger end;
        BigInteger start = new BigInteger(this.startValueText.getText());
        if (start.compareTo(end = new BigInteger(this.endValueText.getText())) > -1) {
            MessageBox box = new MessageBox(this.getShell(), 33);
            box.setMessage(Messages.getString("SweepLoopDialog.end_smaller_than_start_error_message"));
            box.setText(Messages.getString("SweepLoopDialog.error_title"));
            box.open();
        } else {
            this.startReturn = this.startValueText.getText();
            this.endReturn = this.endValueText.getText();
            this.stepReturn = this.stepValueText.getText();
            if (!this.exceptionsText.getText().equals("")) {
                this.exceptionsReturn = this.exceptionsText.getText().split(System.getProperty(SEPARATOR_PROPERTY));
            }
            super.okPressed();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (!(this.startValueText.getText().equals("") || this.endValueText.getText().equals("") || this.stepValueText.getText().equals(""))) {
            super.getButton(0).setEnabled(true);
        } else {
            super.getButton(0).setEnabled(false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.updateButtons();
        return result;
    }

    public String getStartReturn() {
        return this.startReturn;
    }

    public String getEndReturn() {
        return this.endReturn;
    }

    public String getStepReturn() {
        return this.stepReturn;
    }

    public String[] getExceptionsReturn() {
        return this.exceptionsReturn;
    }

    class NegativeVerifier
    implements Listener {
        NegativeVerifier() {
        }

        public void handleEvent(Event event) {
            Text text = (Text)event.widget;
            String value = String.valueOf(text.getText().substring(0, event.start)) + event.text + text.getText().substring(event.end);
            String[] stringArray = value.split(System.getProperty(SweepLoopDialog.SEPARATOR_PROPERTY));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block3: {
                    String val = stringArray[n2];
                    try {
                        new BigInteger(val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (val.equals("-") || val.equals("")) break block3;
                        event.doit = false;
                        break;
                    }
                }
                ++n2;
            }
        }
    }
}

