/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.wizards;

import eu.geclipse.jsdl.JSDLModelFacade;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.widgets.DataStageInTable;
import eu.geclipse.jsdl.ui.widgets.DataStageOutTable;
import eu.geclipse.jsdl.ui.wizards.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStagingNewJobWizardPage
extends WizardPage {
    DataStageInTable copyFromTab;
    DataStageOutTable copyToTab;
    private boolean isCreated = false;
    private List<DataStagingType> initialStagingOut = new ArrayList<DataStagingType>();
    private List<DataStagingType> initialStagingIn = new ArrayList<DataStagingType>();

    protected DataStagingNewJobWizardPage(String pageName) {
        super(pageName);
        this.setDescription(Messages.getString("FilesOutputNewJobWizardPage.page_description"));
        this.setTitle(Messages.getString("FilesOutputNewJobWizardPage.page_title"));
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        Group inFilesGroup = new Group(mainComp, 0);
        inFilesGroup.setText("Stage in");
        inFilesGroup.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        inFilesGroup.setLayoutData((Object)gridData);
        FormToolkit toolkit = new FormToolkit(inFilesGroup.getDisplay());
        toolkit.setBackground(inFilesGroup.getBackground());
        Form inForm = toolkit.createForm((Composite)inFilesGroup);
        inForm.getBody().setLayout((Layout)new GridLayout(2, false));
        Label inDescription = new Label(inForm.getBody(), 0);
        inDescription.setLayoutData((Object)gridData);
        inDescription.setText(Messages.getString("DataStagingNewJobWizardPage.data_staging_in_description"));
        ImageHyperlink link = toolkit.createImageHyperlink(inForm.getBody(), 64);
        link.setImage(Activator.getDefault().getImageRegistry().get("helplink"));
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DataStagingNewJobWizardPage.this.performHelp();
            }
        });
        this.copyFromTab = new DataStageInTable((Composite)inFilesGroup, this.initialStagingIn, 1);
        Group outFilesGroup = new Group(mainComp, 0);
        outFilesGroup.setText(Messages.getString("DataStagingNewJobWizardPage.stage_out_title"));
        outFilesGroup.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        outFilesGroup.setLayoutData((Object)gridData);
        Form outForm = toolkit.createForm((Composite)outFilesGroup);
        outForm.getBody().setLayout((Layout)new GridLayout(2, false));
        Label outDescription = new Label(outForm.getBody(), 0);
        outDescription.setLayoutData((Object)gridData);
        outDescription.setText(Messages.getString("DataStagingNewJobWizardPage.data_staging_out_description"));
        ImageHyperlink link1 = toolkit.createImageHyperlink(outForm.getBody(), 64);
        link1.setImage(Activator.getDefault().getImageRegistry().get("helplink"));
        this.copyToTab = new DataStageOutTable((Composite)outFilesGroup, this.initialStagingOut, 1);
        this.isCreated = true;
        this.setControl((Control)mainComp);
    }

    public List<DataStagingType> getFiles(FileType type) {
        List<DataStagingType> result = new ArrayList<DataStagingType>();
        switch (type) {
            case INPUT: {
                if (this.copyFromTab == null) break;
                result = this.copyFromTab.getDataStagingType();
                break;
            }
            case OUTPUT: {
                if (this.copyToTab == null) break;
                result = this.copyToTab.getDataStagingType();
                break;
            }
        }
        return result;
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    public void setInitialStagingOut(Map<String, String> initialOut) {
        this.initialStagingOut = new ArrayList<DataStagingType>();
        if (initialOut != null) {
            for (String name : initialOut.keySet()) {
                try {
                    DataStagingType newData = JSDLModelFacade.getDataStagingType();
                    newData.setFileName(name);
                    SourceTargetType sourceDataOut = JSDLModelFacade.getSourceTargetType();
                    sourceDataOut.setURI(initialOut.get(name));
                    newData.setTarget(sourceDataOut);
                    this.initialStagingOut.add(newData);
                }
                catch (Exception exception) {}
            }
        }
        if (this.copyToTab != null) {
            this.copyToTab.updateInput(this.initialStagingOut);
        }
    }

    public void setInitialStagingIn(Map<String, String> initialIn) {
        this.initialStagingIn = new ArrayList<DataStagingType>();
        if (initialIn != null) {
            for (String name : initialIn.keySet()) {
                try {
                    DataStagingType newData = JSDLModelFacade.getDataStagingType();
                    newData.setFileName(name);
                    SourceTargetType sourceDataOut = JSDLModelFacade.getSourceTargetType();
                    sourceDataOut.setURI(initialIn.get(name));
                    newData.setSource(sourceDataOut);
                    this.initialStagingIn.add(newData);
                }
                catch (Exception exception) {}
            }
        }
        if (this.copyFromTab != null) {
            this.copyFromTab.updateInput(this.initialStagingIn);
        }
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public void setInitialStagingInModel(List<DataStagingType> files) {
        this.initialStagingIn = files;
        if (this.copyFromTab != null) {
            this.copyFromTab.updateInput(this.initialStagingIn);
        }
    }

    public void setInitialStagingOutModel(List<DataStagingType> files) {
        this.initialStagingOut = files;
        if (this.copyToTab != null) {
            this.copyToTab.updateInput(this.initialStagingOut);
        }
    }
}

