/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.Messages;
import eu.geclipse.jsdl.internal.Activator;
import eu.geclipse.jsdl.model.base.ApplicationType;
import eu.geclipse.jsdl.model.base.CandidateHostsType;
import eu.geclipse.jsdl.model.base.CreationFlagEnumeration;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.DocumentRoot;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobDescriptionType;
import eu.geclipse.jsdl.model.base.JobIdentificationType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.ResourcesType;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.model.base.util.JsdlResourceFactoryImpl;
import eu.geclipse.jsdl.model.functions.ExceptionType;
import eu.geclipse.jsdl.model.functions.FunctionsFactory;
import eu.geclipse.jsdl.model.functions.FunctionsPackage;
import eu.geclipse.jsdl.model.functions.LoopType;
import eu.geclipse.jsdl.model.functions.ValuesType;
import eu.geclipse.jsdl.model.functions.impl.FunctionsPackageImpl;
import eu.geclipse.jsdl.model.posix.ArgumentType;
import eu.geclipse.jsdl.model.posix.FileNameType;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import eu.geclipse.jsdl.model.posix.PosixFactory;
import eu.geclipse.jsdl.model.posix.PosixPackage;
import eu.geclipse.jsdl.model.posix.impl.POSIXApplicationTypeImpl;
import eu.geclipse.jsdl.model.sweep.AssignmentType;
import eu.geclipse.jsdl.model.sweep.SweepFactory;
import eu.geclipse.jsdl.model.sweep.SweepPackage;
import eu.geclipse.jsdl.model.sweep.SweepType;
import eu.geclipse.jsdl.model.sweep.impl.SweepPackageImpl;
import eu.geclipse.jsdl.model.sweep.impl.SweepTypeImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLJobDescriptionModel
extends AbstractGridContainer
implements IGridJobDescription {
    private static final String UTF_8 = "UTF-8";
    protected JsdlPackage jsdlPackage = JsdlPackage.eINSTANCE;
    protected PosixPackage posixPackage = PosixPackage.eINSTANCE;
    protected PosixFactory posixFactory = this.posixPackage.getPosixFactory();
    protected JsdlFactory jsdlFactory = this.jsdlPackage.getJsdlFactory();
    private File fileResource;
    private Resource resource = null;
    private DocumentRoot documentRoot;
    private JobDefinitionType jobDefinition;
    private JobDescriptionType jobDescription;
    private JobIdentificationType jobIdentification;

    public JSDLJobDescriptionModel(File file) throws Resource.IOWrappedException {
        this.fileResource = file;
        this.updateModelFromFile();
    }

    public String getDescription() {
        String result = null;
        if (this.getJobDescription() != null && this.getJobDescription().getJobIdentification() != null) {
            result = this.getJobDescription().getJobIdentification().getDescription();
        }
        return result;
    }

    public String getExecutable() {
        String result = null;
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp != null && posixApp.getExecutable() != null) {
            result = posixApp.getExecutable().getValue();
        }
        return result;
    }

    public List<String> getExecutableArguments() {
        ArrayList<String> result = null;
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp != null && !posixApp.getArgument().isEmpty()) {
            result = new ArrayList<String>();
            for (Object arg : posixApp.getArgument()) {
                result.add(((ArgumentType)arg).getValue());
            }
        }
        return result;
    }

    public String getStdErrorFileName() {
        String errorFilename = null;
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp != null && posixApp.getError() != null) {
            errorFilename = posixApp.getError().getValue();
        }
        return errorFilename;
    }

    public java.net.URI getStdErrorUri() throws ProblemException {
        java.net.URI uri = null;
        String stdErrFileName = this.getStdErrorFileName();
        if (stdErrFileName != null) {
            uri = this.findStagingAbsoluteUri(stdErrFileName, true);
        }
        return uri;
    }

    public String getStdInputFileName() {
        String inputString = null;
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp != null && posixApp.getInput() != null) {
            inputString = posixApp.getInput().getValue();
        }
        return inputString;
    }

    public java.net.URI getStdInputUri() throws ProblemException {
        java.net.URI uri = null;
        String stdInputFileName = this.getStdInputFileName();
        if (stdInputFileName != null) {
            uri = this.findStagingAbsoluteUri(stdInputFileName, false);
        }
        return uri;
    }

    public String getStdOutputFileName() {
        String result = null;
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp != null && posixApp.getOutput() != null) {
            result = posixApp.getOutput().getValue();
        }
        return result;
    }

    public java.net.URI getStdOutputUri() throws ProblemException {
        java.net.URI uri = null;
        String stdOutputFileName = this.getStdOutputFileName();
        if (stdOutputFileName != null) {
            uri = this.findStagingAbsoluteUri(stdOutputFileName, true);
        }
        return uri;
    }

    public boolean isLazy() {
        return false;
    }

    public IFileStore getFileStore() {
        return null;
    }

    public String getName() {
        return this.fileResource.getName();
    }

    public IGridContainer getParent() {
        return null;
    }

    public IPath getPath() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public void updateModelFromFile() throws Resource.IOWrappedException {
        block3: {
            if (this.fileResource.length() != 0L) {
                String filePath = this.fileResource.getAbsolutePath();
                URI uri = URI.createFileURI((String)filePath);
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resourceA = resourceSet.createResource(uri);
                XMLMapImpl xmlmap = new XMLMapImpl();
                xmlmap.setNoNamespacePackage((EPackage)JsdlPackage.eINSTANCE);
                HashMap<String, Object> options = new HashMap<String, Object>();
                options.put("XML_MAP", xmlmap);
                options.put("ENCODING", "UTF8");
                try {
                    resourceA.load(options);
                    this.documentRoot = (DocumentRoot)resourceA.getContents().get(0);
                    this.jobDefinition = this.documentRoot.getJobDefinition();
                    this.jobDescription = this.jobDefinition.getJobDescription();
                    this.jobIdentification = this.documentRoot.getJobIdentification();
                }
                catch (IOException ioEx) {
                    if (!(ioEx instanceof Resource.IOWrappedException)) break block3;
                    Resource.IOWrappedException ioWEx = (Resource.IOWrappedException)((Object)ioEx);
                    throw ioWEx;
                }
            }
        }
    }

    public void setRoot(DocumentRoot root) {
        this.documentRoot = root;
        if (root.getJobDefinition() != null) {
            this.jobDefinition = root.getJobDefinition();
            if (this.jobDefinition.getJobDescription() != null) {
                this.jobDescription = this.jobDefinition.getJobDescription();
            }
        }
    }

    public String getJSDLString() throws IOException {
        FileInputStream inputStream = new FileInputStream(this.fileResource);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        char[] buffer = new char[1024];
        int bytesRead = 0;
        StringBuilder builder = new StringBuilder();
        do {
            if ((bytesRead = reader.read(buffer)) <= 0) continue;
            builder.append(buffer, 0, bytesRead);
        } while (bytesRead > 0);
        return builder.toString();
    }

    public void setUpBasicJSDLStructure() {
        this.documentRoot = this.jsdlFactory.createDocumentRoot();
        this.jobIdentification = this.jsdlFactory.createJobIdentificationType();
        this.jobDescription = this.jsdlFactory.createJobDescriptionType();
        this.jobDefinition = this.jsdlFactory.createJobDefinitionType();
        this.jobDefinition.setJobDescription(this.jobDescription);
        this.jobDescription.setJobIdentification(this.jobIdentification);
        this.documentRoot.setJobDefinition(this.jobDefinition);
    }

    public void setJobIdentification(String jobName, String description) {
        JobIdentificationType identyfication = this.jsdlFactory.createJobIdentificationType();
        if (!"".equals(description)) {
            identyfication.setDescription(description);
        } else {
            identyfication.setDescription("default description");
        }
        if (!"".equals(jobName)) {
            identyfication.setJobName(jobName);
        } else {
            identyfication.setJobName("default job name");
        }
        this.jobDescription.setJobIdentification(identyfication);
    }

    public void setPOSIXApplicationDetails(String applicationName, String executableFile, String stdin, String stdinName, String stdout, String outName, String err, String errName) {
        ApplicationType app;
        this.setApplicationName(applicationName);
        POSIXApplicationType posixApp = this.posixFactory.createPOSIXApplicationType();
        FileNameType execFile = this.posixFactory.createFileNameType();
        execFile.setValue(executableFile);
        posixApp.setExecutable(execFile);
        if (stdin != null) {
            FileNameType inputFile = this.posixFactory.createFileNameType();
            inputFile.setValue(stdinName);
            posixApp.setInput(inputFile);
        }
        if (stdout != null) {
            FileNameType outputFile = this.posixFactory.createFileNameType();
            outputFile.setValue(outName);
            posixApp.setOutput(outputFile);
        }
        if (err != null) {
            FileNameType errorFile = this.posixFactory.createFileNameType();
            errorFile.setValue(errName);
            posixApp.setError(errorFile);
        }
        if ((app = this.jobDescription.getApplication()) == null) {
            app = this.jsdlFactory.createApplicationType();
        }
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.posixPackage);
        FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("pOSIXApplication"), (Object)posixApp);
        app.getAny().add((Object)e);
        if (stdin != null) {
            DataStagingType dataIn = this.jsdlFactory.createDataStagingType();
            dataIn.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataIn.setDeleteOnTermination(false);
            dataIn.setFileName(stdinName);
            SourceTargetType sourceDataIn = this.jsdlFactory.createSourceTargetType();
            sourceDataIn.setURI(stdin);
            dataIn.setSource(sourceDataIn);
            this.jobDescription.getDataStaging().add((Object)dataIn);
        }
        if (stdout != null) {
            DataStagingType dataOut = this.jsdlFactory.createDataStagingType();
            dataOut.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataOut.setDeleteOnTermination(false);
            dataOut.setFileName(outName);
            SourceTargetType sourceDataOut = this.jsdlFactory.createSourceTargetType();
            sourceDataOut.setURI(stdout);
            dataOut.setTarget(sourceDataOut);
            this.jobDescription.getDataStaging().add((Object)dataOut);
        }
        if (err != null) {
            DataStagingType dataErr = this.jsdlFactory.createDataStagingType();
            dataErr.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataErr.setDeleteOnTermination(false);
            dataErr.setFileName(errName);
            SourceTargetType sourceDataErr = this.jsdlFactory.createSourceTargetType();
            sourceDataErr.setURI(err);
            dataErr.setTarget(sourceDataErr);
            this.jobDescription.getDataStaging().add((Object)dataErr);
        }
    }

    public void addDataStagingOut(String name, String path) {
        DataStagingType dataOut = this.jsdlFactory.createDataStagingType();
        dataOut.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
        dataOut.setDeleteOnTermination(true);
        dataOut.setFileName(name);
        SourceTargetType sourceDataIn = this.jsdlFactory.createSourceTargetType();
        sourceDataIn.setURI(path);
        dataOut.setTarget(sourceDataIn);
        this.jobDescription.getDataStaging().add((Object)dataOut);
    }

    public void addDataStagingIn(String name, String path) {
        DataStagingType dataIn = this.jsdlFactory.createDataStagingType();
        dataIn.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
        dataIn.setDeleteOnTermination(true);
        dataIn.setFileName(name);
        SourceTargetType sourceDataOut = this.jsdlFactory.createSourceTargetType();
        sourceDataOut.setURI(path);
        dataIn.setSource(sourceDataOut);
        this.jobDescription.getDataStaging().add((Object)dataIn);
    }

    public POSIXApplicationType getPosixApplication() {
        POSIXApplicationTypeImpl result = null;
        if (this.getJobDescription() != null && this.getJobDescription().getApplication() != null) {
            FeatureMap anyMap = this.getJobDescription().getApplication().getAny();
            int i = 0;
            while (i < anyMap.size()) {
                if (anyMap.getValue(i) instanceof POSIXApplicationTypeImpl) {
                    result = (POSIXApplicationTypeImpl)anyMap.getValue(i);
                }
                ++i;
            }
        }
        return result;
    }

    private JobDescriptionType getJobDescription() {
        JobDescriptionType result = null;
        DocumentRoot dRoot = this.getDocumentRoot();
        if (dRoot != null && dRoot.getJobDefinition() != null) {
            result = dRoot.getJobDefinition().getJobDescription();
        }
        return result;
    }

    public String getCpuArchitectureName() {
        String architectureNameString = null;
        if (this.getJobDescription() != null && this.getJobDescription().getResources() != null && this.getJobDescription().getResources().getCPUArchitecture() != null && this.getJobDescription().getResources().getCPUArchitecture().getCPUArchitectureName() != null) {
            architectureNameString = this.getJobDescription().getResources().getCPUArchitecture().getCPUArchitectureName().getName();
        }
        return architectureNameString;
    }

    public String getOSTypeName() {
        String nameString = null;
        DocumentRoot dRoot = this.getDocumentRoot();
        if (dRoot != null && dRoot.getJobDefinition() != null && dRoot.getJobDefinition().getJobDescription() != null && dRoot.getJobDefinition().getJobDescription().getResources() != null && dRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem() != null && this.getJobDescription().getResources().getOperatingSystem().getOperatingSystemType() != null && dRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemType().getOperatingSystemName() != null) {
            nameString = dRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemType().getOperatingSystemName().getName();
        }
        return nameString;
    }

    public String getOSVersion() {
        String versionString = null;
        DocumentRoot dRoot = this.getDocumentRoot();
        if (dRoot != null && dRoot.getJobDefinition() != null && dRoot.getJobDefinition().getJobDescription() != null && dRoot.getJobDefinition().getJobDescription().getResources() != null && dRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem() != null) {
            versionString = dRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemVersion();
        }
        return versionString;
    }

    public void addArgumentForPosixApplication(String argName, ArrayList<String> argValues) {
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (argValues != null && !argValues.isEmpty() && posixApp != null) {
            ArgumentType arg;
            EList argumentList = posixApp.getArgument();
            if (argName != null && !argName.equals("")) {
                arg = this.posixFactory.createArgumentType();
                arg.setValue(argName);
                argumentList.add((Object)arg);
            }
            for (String value : argValues) {
                if (value.equals("")) continue;
                arg = this.posixFactory.createArgumentType();
                arg.setValue(value);
                argumentList.add((Object)arg);
            }
        }
    }

    public void addCandidateHosts(List<String> hostsList) {
        DocumentRoot dRoot = this.getDocumentRoot();
        if (dRoot != null && dRoot.getJobDefinition() != null && dRoot.getJobDefinition().getJobDescription() != null) {
            CandidateHostsType candidateHosts;
            ResourcesType resources = dRoot.getJobDefinition().getJobDescription().getResources();
            if (resources == null) {
                resources = this.jsdlFactory.createResourcesType();
                dRoot.getJobDefinition().getJobDescription().setResources(resources);
            }
            if ((candidateHosts = resources.getCandidateHosts()) == null) {
                candidateHosts = this.jsdlFactory.createCandidateHostsType();
                resources.setCandidateHosts(candidateHosts);
            }
            for (String hostName : hostsList) {
                candidateHosts.getHostName().add((Object)hostName);
            }
        }
    }

    public List<DataStagingType> getDataStagingIn() {
        EList temp;
        ArrayList<DataStagingType> result = new ArrayList<DataStagingType>();
        if (this.getJobDescription() != null && (temp = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataType : temp) {
                if (dataType.getSource() == null) continue;
                result.add(dataType);
            }
        }
        return result;
    }

    public Map<String, String> getDataStagingInStrings() {
        EList temp;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getJobDescription() != null && (temp = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataType : temp) {
                if (dataType.getSource() == null) continue;
                result.put(dataType.getFileName(), dataType.getSource().getURI());
            }
        }
        return result;
    }

    public Map<String, String> getDataStagingOutStrings() {
        EList temp;
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getJobDescription() != null && (temp = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataType : temp) {
                if (dataType.getTarget() == null) continue;
                result.put(dataType.getFileName(), dataType.getTarget().getURI());
            }
        }
        return result;
    }

    public List<DataStagingType> getDataStagingOut() {
        EList temp;
        ArrayList<DataStagingType> result = new ArrayList<DataStagingType>();
        if (this.getJobDescription() != null && (temp = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataType : temp) {
                if (dataType.getTarget() == null) continue;
                result.add(dataType);
            }
        }
        return result;
    }

    public void removeDataStaging() {
        this.jobDescription.getDataStaging().removeAll((Collection)this.jobDescription.getDataStaging());
    }

    public void setApplicationName(String applicationName) {
        this.createJobDescriptionCond();
        if (this.jobDescription.getApplication() == null) {
            ApplicationType app = this.jsdlFactory.createApplicationType();
            this.jobDescription.setApplication(app);
        }
        this.jobDescription.getApplication().setApplicationName(applicationName);
    }

    public String getApplicationName() {
        String applicationName = null;
        JobDescriptionType description = this.getJobDescription();
        if (description != null) {
            ApplicationType application = description.getApplication();
            applicationName = application.getApplicationName();
        }
        return applicationName;
    }

    public List<String> getCandidateHostsNames() {
        ArrayList<String> result = new ArrayList<String>();
        DocumentRoot dRoot = this.getDocumentRoot();
        if (dRoot != null && dRoot.getJobDefinition() != null && dRoot.getJobDefinition().getJobDescription() != null && dRoot.getJobDefinition().getJobDescription().getResources() != null && dRoot.getJobDefinition().getJobDescription().getResources().getCandidateHosts() != null) {
            EList list = dRoot.getJobDefinition().getJobDescription().getResources().getCandidateHosts().getHostName();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                result.add((String)iterator.next());
            }
        }
        return result;
    }

    public boolean isParametric() {
        boolean parametric = false;
        if (this.jobDefinition != null) {
            FeatureMap featureMap = this.jobDefinition.getAny();
            for (FeatureMap.Entry entry : featureMap) {
                if (!(entry.getValue() instanceof SweepTypeImpl)) continue;
                parametric = true;
                break;
            }
        }
        return parametric;
    }

    public void removeTargetsFromOutStaging() {
        EList temp;
        if (this.getJobDescription() != null && (temp = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataType : temp) {
                if (dataType.getTarget() == null) continue;
                SourceTargetType target = this.jsdlFactory.createSourceTargetType();
                target.setURI("");
                dataType.setTarget(target);
            }
        }
    }

    public void addArgument(String argName) {
        POSIXApplicationType posixApp = this.getPosixApplication();
        if (posixApp == null) {
            try {
                posixApp = this.posixFactory.createPOSIXApplicationType();
                ApplicationType app = this.jobDescription.getApplication();
                if (app != null) {
                    EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.posixPackage);
                    FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("pOSIXApplication"), (Object)posixApp);
                    app.getAny().add((Object)e);
                    posixApp = this.getPosixApplication();
                }
            }
            catch (Exception exception) {}
        }
        if (posixApp != null) {
            EList argumentList = posixApp.getArgument();
            if (argName != null && !argName.equals("")) {
                ArgumentType arg = this.posixFactory.createArgumentType();
                arg.setValue(argName);
                argumentList.add((Object)arg);
            }
        }
    }

    public SweepType addSweepOnTheSameLevel(String refParamName, String sweepParamName) {
        SweepType refSweep;
        SweepType result = null;
        if (this.isParametric() && (refSweep = this.findSweepWithParam(refParamName)) != null) {
            result = refSweep;
            this.addAssignment(result, sweepParamName);
        }
        return result;
    }

    public SweepType addInnerSweep(String refParamName, String sweepParamName) {
        SweepType refSweep;
        SweepType result = null;
        if (this.isParametric() && (refSweep = this.findSweepWithParam(refParamName)) != null) {
            result = this.createSweepType();
            refSweep.getSweep().add((Object)result);
            this.addAssignment(result, sweepParamName);
        }
        return result;
    }

    public SweepType addIndependentSweep(String refParamName, String sweepParamName) {
        SweepType refSweep;
        SweepType result = null;
        boolean flag = false;
        if (this.isParametric() && refParamName != null && (refSweep = this.findSweepWithParam(refParamName)) != null) {
            flag = true;
            result = this.createSweepType();
            if (refSweep.eContainer() instanceof JobDefinitionType) {
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)SweepPackageImpl.eINSTANCE);
                FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("sweep"), (Object)result);
                ((JobDefinitionType)refSweep.eContainer()).getAny().add((Object)e);
            } else if (refSweep.eContainer() instanceof SweepType) {
                ((SweepType)refSweep.eContainer()).getSweep().add((Object)result);
            }
            this.addAssignment(result, sweepParamName);
        }
        if (!flag) {
            result = this.createSweepType();
            EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)SweepPackageImpl.eINSTANCE);
            FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("sweep"), (Object)result);
            this.createJobDefinitionCond();
            this.jobDefinition.getAny().add((Object)e);
            this.addAssignment(result, sweepParamName);
        }
        return result;
    }

    public void setEnumFunction(String paramName, List<String> values) {
        AssignmentType assignment = this.findAssignmentType(paramName);
        if (values != null && values.size() > 0) {
            FunctionsPackage pak = FunctionsPackageImpl.eINSTANCE;
            FunctionsFactory factory = pak.getFunctionsFactory();
            ValuesType valuesType = factory.createValuesType();
            for (String value : values) {
                valuesType.getValue().add((Object)value);
            }
            EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)pak);
            FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("values"), (Object)valuesType);
            assignment.getFunctionGroup().add((Object)e);
        } else {
            assignment.getFunctionGroup().clear();
        }
    }

    public void setLoopFunction(String paramName, BigInteger start, BigInteger end, BigInteger step, List<BigInteger> exceptions) {
        AssignmentType assignment = this.findAssignmentType(paramName);
        FunctionsPackage pak = FunctionsPackageImpl.eINSTANCE;
        FunctionsFactory factory = pak.getFunctionsFactory();
        LoopType loopType = factory.createLoopType();
        loopType.setStart(start);
        loopType.setEnd(end);
        loopType.setStep(step);
        if (exceptions != null) {
            for (BigInteger except : exceptions) {
                ExceptionType exc = factory.createExceptionType();
                exc.setValue(except);
                loopType.getException().add((Object)exc);
            }
        }
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)pak);
        FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("loop"), (Object)loopType);
        assignment.getFunctionGroup().add((Object)e);
    }

    protected void writeModelToFile(EObject jsdlRoot) {
        String filePath = this.fileResource.getAbsolutePath().toString();
        URI fileURI = URI.createFileURI((String)filePath);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry factoryRegistry = resourceSet.getResourceFactoryRegistry();
        Map map = factoryRegistry.getExtensionToFactoryMap();
        map.put("jsdl", new JsdlResourceFactoryImpl());
        this.resource = resourceSet.createResource(fileURI);
        if (jsdlRoot != null) {
            this.resource.getContents().add((Object)jsdlRoot);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", UTF_8);
        try {
            this.resource.save(options);
        }
        catch (IOException ioEx) {
            Activator.logException(ioEx);
        }
    }

    protected DocumentRoot getDocumentRoot() {
        if (this.documentRoot == null) {
            try {
                this.updateModelFromFile();
            }
            catch (Resource.IOWrappedException e) {
                Activator.logException((Exception)((Object)e));
            }
        }
        return this.documentRoot;
    }

    private void createDocumentRootCond() {
        if (this.documentRoot == null) {
            this.documentRoot = this.jsdlFactory.createDocumentRoot();
        }
    }

    private void createJobDefinitionCond() {
        this.createDocumentRootCond();
        if (this.documentRoot.getJobDefinition() == null) {
            this.jobDefinition = this.jsdlFactory.createJobDefinitionType();
            this.documentRoot.setJobDefinition(this.jobDefinition);
        }
    }

    private void createJobDescriptionCond() {
        this.createJobDefinitionCond();
        if (this.jobDefinition.getJobDescription() == null) {
            this.jobDescription = this.jsdlFactory.createJobDescriptionType();
            this.jobDefinition.setJobDescription(this.jobDescription);
        }
    }

    private void createJobIdentificationCond() {
        this.createJobDescriptionCond();
        if (this.jobDescription.getJobIdentification() == null) {
            this.jobIdentification = this.jsdlFactory.createJobIdentificationType();
            this.jobDescription.setJobIdentification(this.jobIdentification);
        }
    }

    private java.net.URI findStagingAbsoluteUri(String filename, boolean stageOut) throws ProblemException {
        java.net.URI uri = null;
        Map<String, String> stagingsMap = stageOut ? this.getDataStagingOutStrings() : this.getDataStagingInStrings();
        try {
            if (stagingsMap != null) {
                String currentFilename = filename;
                String currentUriString = stagingsMap.get(currentFilename);
                while (uri == null && currentUriString != null) {
                    Path path;
                    java.net.URI currentUri = new java.net.URI(currentUriString);
                    String pathString = currentUri.getPath();
                    if (pathString != null && (path = new Path(pathString)).isAbsolute()) {
                        uri = currentUri;
                    }
                    stagingsMap.remove(currentFilename);
                    currentFilename = currentUriString;
                    currentUriString = stagingsMap.get(currentFilename);
                }
            }
        }
        catch (URISyntaxException exception) {
            throw new ProblemException("eu.geclipse.core.problem.net.malformedURL", (Throwable)exception, String.format(Messages.getString("errWrongUri"), filename));
        }
        return uri;
    }

    private AssignmentType findAssignmentType(String paramName) {
        AssignmentType result = null;
        EList aList = this.findSweepWithParam(paramName).getAssignment();
        int i = 0;
        while (i < aList.size()) {
            EList pList = ((AssignmentType)aList.get(i)).getParameter();
            int j = 0;
            while (j < pList.size()) {
                if (((String)pList.get(j)).equalsIgnoreCase(paramName)) {
                    result = (AssignmentType)aList.get(i);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private SweepType createSweepType() {
        SweepType result = null;
        SweepPackage pak = SweepPackageImpl.eINSTANCE;
        SweepFactory factory = pak.getSweepFactory();
        result = factory.createSweepType();
        return result;
    }

    private SweepType findSweepWithParam(String paramName) {
        SweepType result = null;
        ArrayList<SweepType> resultSweep = new ArrayList<SweepType>();
        if (this.isParametric()) {
            FeatureMap featureMap = this.jobDefinition.getAny();
            for (FeatureMap.Entry entry : featureMap) {
                if (!(entry.getValue() instanceof SweepTypeImpl)) continue;
                resultSweep.addAll(this.getSweepChildren((SweepType)entry.getValue()));
            }
            for (SweepType sweep : resultSweep) {
                EList list = sweep.getAssignment();
                int i = 0;
                while (i < list.size()) {
                    EList aList = ((AssignmentType)list.get(i)).getParameter();
                    int j = 0;
                    while (j < aList.size()) {
                        if (((String)aList.get(j)).equalsIgnoreCase(paramName)) {
                            result = sweep;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private AssignmentType addAssignment(SweepType parentSweep, String param) {
        SweepPackage pak = SweepPackageImpl.eINSTANCE;
        SweepFactory factory = pak.getSweepFactory();
        AssignmentType assignment = factory.createAssignmentType();
        assignment.getParameter().add((Object)param);
        parentSweep.getAssignment().add((Object)assignment);
        return assignment;
    }

    private List<SweepType> getSweepChildren(SweepType rootSweep) {
        ArrayList<SweepType> result = new ArrayList<SweepType>();
        EList list = rootSweep.getSweep();
        int i = 0;
        while (i < list.size()) {
            result.addAll(this.getSweepChildren((SweepType)list.get(i)));
            ++i;
        }
        result.add(rootSweep);
        return result;
    }

    public void save() {
        this.writeModelToFile((EObject)this.documentRoot);
    }

    public InputStream getInputStream() {
        FileInputStream result = null;
        try {
            result = new FileInputStream(this.fileResource);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }
}

