/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.parametric.internal;

import eu.geclipse.jsdl.parametric.IParametricJsdlGenerator;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricGenerationCanceled;
import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.internal.Assignment;
import eu.geclipse.jsdl.parametric.internal.CounterGenerationContext;
import eu.geclipse.jsdl.parametric.internal.FunctionIntegerLoop;
import eu.geclipse.jsdl.parametric.internal.FunctionValues;
import eu.geclipse.jsdl.parametric.internal.GenerationContext;
import eu.geclipse.jsdl.parametric.internal.IFunction;
import eu.geclipse.jsdl.parametric.internal.IGenerationContext;
import eu.geclipse.jsdl.xpath.XPathDocument;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricJsdlGenerator
implements IParametricJsdlGenerator {
    private XPathDocument xpath;
    private String parametricJsdl;

    public ParametricJsdlGenerator(String parametricJsdl) {
        this.parametricJsdl = parametricJsdl;
    }

    private void processSweeps(NodeList sweeps, IGenerationContext generationContext, List<Integer> iterationsStack) throws ParametricJsdlException {
        try {
            iterationsStack.add(new Integer(0));
            int index = 0;
            while (index < sweeps.getLength()) {
                ArrayList<Assignment> assignmentList = new ArrayList<Assignment>();
                Node sweepItem = sweeps.item(index);
                if (sweepItem instanceof Element) {
                    Element currentSweep = (Element)sweepItem;
                    this.processAssignments(this.xpath.getNodes(currentSweep, "./sweep:Assignment"), assignmentList, generationContext);
                    NodeList childSweeps = this.xpath.getNodes(currentSweep, "./sweep:Sweep");
                    List<Iterator<String>> iterators = this.getIterators(assignmentList);
                    while (this.hasNext(iterators)) {
                        this.testCanceled(generationContext);
                        IGenerationContext newContext = generationContext.clone();
                        this.setParamsValue(assignmentList, iterators, newContext);
                        if (childSweeps.getLength() > 0) {
                            this.processSweeps(childSweeps, newContext, iterationsStack);
                        } else {
                            newContext.storeGeneratedJsdl(iterationsStack);
                        }
                        this.increaseCurrentIteration(iterationsStack);
                    }
                } else {
                    throw new ParametricJsdlException("<sweep:Sweep> should be instance of XML Element");
                }
                ++index;
            }
            iterationsStack.remove(iterationsStack.size() - 1);
        }
        catch (XPathExpressionException exception) {
            throw new ParametricJsdlException("Error occured during calling XPath query", exception);
        }
    }

    private boolean hasNext(List<Iterator<String>> iterators) {
        boolean hasNext = false;
        for (Iterator<String> iterator : iterators) {
            if (!iterator.hasNext()) continue;
            hasNext = true;
            break;
        }
        return hasNext;
    }

    private List<Iterator<String>> getIterators(List<Assignment> assignmentList) {
        ArrayList<Iterator<String>> iterators = new ArrayList<Iterator<String>>(assignmentList.size());
        for (Assignment assignment : assignmentList) {
            iterators.add(assignment.getFunction().iterator());
        }
        return iterators;
    }

    private void increaseCurrentIteration(List<Integer> iterationsStack) {
        int lastIndex = iterationsStack.size() - 1;
        Integer iteration = iterationsStack.get(lastIndex);
        iterationsStack.set(lastIndex, iteration + 1);
    }

    private void setParamsValue(List<Assignment> assignmentList, List<Iterator<String>> functionIterators, IGenerationContext generationContext) throws ParametricJsdlException {
        Iterator<Iterator<String>> fIterator = functionIterators.iterator();
        Iterator<Assignment> aIterator = assignmentList.iterator();
        while (fIterator.hasNext() && aIterator.hasNext()) {
            this.testCanceled(generationContext);
            Assignment assignment = aIterator.next();
            Iterator<String> functionIterator = fIterator.next();
            if (functionIterator.hasNext()) {
                assignment.setParamValue(functionIterator, generationContext);
                continue;
            }
            throw this.createWrongNrValueException(assignmentList);
        }
    }

    private ParametricJsdlException createWrongNrValueException(List<Assignment> assignmentList) {
        StringBuilder builder = new StringBuilder("Following parameters should contain the same number of values:");
        for (Assignment assignment : assignmentList) {
            for (String query : assignment.getXPathQueries()) {
                builder.append("\n");
                builder.append(query);
            }
        }
        return new ParametricJsdlException(builder.toString());
    }

    private void processAssignments(NodeList assignmentsList, List<Assignment> assignmentList, IGenerationContext context) throws ParametricJsdlException {
        try {
            int index = 0;
            while (index < assignmentsList.getLength()) {
                IFunction function;
                NodeList parameters;
                this.testCanceled(context);
                Node item = assignmentsList.item(index);
                if (item instanceof Element) {
                    Element assignment = (Element)item;
                    parameters = this.xpath.getNodes(assignment, "./sweep:Parameter");
                    NodeList values = this.xpath.getNodes(assignment, "./sweepfunc:Values/sweepfunc:Value");
                    NodeList loops = this.xpath.getNodes(assignment, "./sweepfunc:Loop");
                    if (values.getLength() > 0 && loops.getLength() > 0) {
                        throw new ParametricJsdlException("<sweepfunc:Values> and <sweepfunc:Loop> cannot be defined both at the same time in one <sweep:Assignment>");
                    }
                    function = null;
                    if (values.getLength() > 0) {
                        function = new FunctionValues(values);
                    } else if (loops.getLength() > 0) {
                        function = new FunctionIntegerLoop(loops, this.xpath);
                    }
                } else {
                    throw new ParametricJsdlException("<sweep:Assignment> should be instance of XML Element");
                }
                assignmentList.add(new Assignment(this.xpath, parameters, function));
                ++index;
            }
            if (assignmentList.isEmpty()) {
                throw new ParametricJsdlException("<sweep:Sweep> should contain at least one <sweep:Assignment> as a child.");
            }
        }
        catch (XPathExpressionException exception) {
            throw new ParametricJsdlException("Error occured during calling XPath query", exception);
        }
    }

    private Document removeSweepNodes(Document parametricJsdlDocument) {
        Document changedDocument = (Document)parametricJsdlDocument.cloneNode(true);
        NodeList nodes = changedDocument.getElementsByTagName("sweep:Sweep");
        int index = 0;
        while (index < nodes.getLength()) {
            Node node = nodes.item(index);
            changedDocument.getDocumentElement().removeChild(node);
            ++index;
        }
        return changedDocument;
    }

    @Override
    public void generate(IParametricJsdlHandler handler) throws ParametricJsdlException, ParametricGenerationCanceled {
        try {
            try {
                Document parametricXml = this.createDomDocument();
                this.xpath = new XPathDocument(parametricXml);
                Document baseJsdl = this.removeSweepNodes(parametricXml);
                GenerationContext generationContext = new GenerationContext(baseJsdl, handler, this.xpath);
                NodeList sweeps = this.xpath.getNodes(parametricXml.getDocumentElement(), "./sweep:Sweep");
                CounterGenerationContext counter = new CounterGenerationContext(handler);
                this.processSweeps(sweeps, counter, new ArrayList<Integer>());
                handler.generationStarted(counter.getIterations(), counter.getParameters());
                this.processSweeps(sweeps, generationContext, new ArrayList<Integer>());
            }
            catch (XPathExpressionException exception) {
                throw new ParametricJsdlException("Error occured during calling XPath query", exception);
            }
        }
        finally {
            handler.generationFinished();
        }
    }

    private Document createDomDocument() throws ParametricJsdlException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(new ByteArrayInputStream(this.parametricJsdl.getBytes()));
        }
        catch (Exception exception) {
            throw new ParametricJsdlException("Unable to parse parametric JSDL as xml file", exception);
        }
    }

    private void testCanceled(IGenerationContext context) throws ParametricGenerationCanceled {
        if (context.getHandler().isCanceled()) {
            throw new ParametricGenerationCanceled();
        }
    }
}

