/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui;

import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobResult;
import eu.geclipse.servicejob.ui.properties.Factory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.geclipse.servicejob.ui";
    private static Activator plugin;
    private static Map<IServiceJobResult, File> serviceJobResultsVsExternalFiles;

    static {
        serviceJobResultsVsExternalFiles = new HashMap<IServiceJobResult, File>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        File serviceJobsFiles = Activator.getDefault().getStateLocation().append("./serviceJobFiles").toFile();
        if (serviceJobsFiles.exists() && serviceJobsFiles.isDirectory()) {
            boolean isEmpty = true;
            String[] stringArray = serviceJobsFiles.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                Path path = new Path(serviceJobsFiles.getAbsolutePath());
                if (!(path = path.append(fileName)).toFile().delete()) {
                    isEmpty = false;
                    break;
                }
                ++n2;
            }
            if (isEmpty) {
                serviceJobsFiles.delete();
            }
        }
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)new Factory(), IServiceJob.class);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Throwable exc) {
        String message = exc.getLocalizedMessage();
        if (message == null) {
            message = exc.getClass().getName();
        }
        Status status = new Status(4, PLUGIN_ID, 0, message, exc);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    public static void addFileForServiceJobResult(IServiceJobResult result, File file) {
        serviceJobResultsVsExternalFiles.put(result, file);
    }

    public static File getFileForServiceJobResult(IServiceJobResult result) {
        return serviceJobResultsVsExternalFiles.get(result);
    }
}

