/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.preferences;

import eu.geclipse.servicejob.model.ServiceJobStates;
import eu.geclipse.servicejob.ui.Activator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MementoHandler {
    private static final String ROOT = "preferences";
    private static boolean changed = false;

    public static Map<ServiceJobStates, Color> loadState() {
        HashMap<ServiceJobStates, Color> values = new HashMap<ServiceJobStates, Color>();
        try {
            FileReader reader = new FileReader(MementoHandler.getMementoFile());
            XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = memento.getChildren("Value");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String id = child.getString("result");
                RGB rgb = new RGB(child.getInteger("red").intValue(), child.getInteger("green").intValue(), child.getInteger("blue").intValue());
                Color color = new Color((Device)Display.getCurrent(), rgb);
                values.put(ServiceJobStates.valueOfAlias((String)id), color);
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.logException(e);
        }
        changed = false;
        return values;
    }

    public static void saveState(Map<ServiceJobStates, Color> values) {
        try {
            changed = true;
            XMLMemento memento = XMLMemento.createWriteRoot((String)ROOT);
            for (ServiceJobStates value : values.keySet()) {
                IMemento child = memento.createChild("Value");
                child.putString("result", value.getAlias());
                Color color = values.get(value);
                child.putInteger("red", color.getRed());
                child.putInteger("green", color.getGreen());
                child.putInteger("blue", color.getBlue());
            }
            FileWriter writer = new FileWriter(MementoHandler.getMementoFile());
            memento.save((Writer)writer);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    private static File getMementoFile() throws IOException {
        File mementofile = Activator.getDefault().getStateLocation().append("color_preferences.xml").toFile();
        if (!mementofile.exists()) {
            mementofile.createNewFile();
            XMLMemento memento = XMLMemento.createWriteRoot((String)ROOT);
            FileWriter writer = new FileWriter(MementoHandler.getMementoFile());
            memento.save((Writer)writer);
        }
        return mementofile;
    }

    public static boolean isChanged() {
        return changed;
    }
}

