/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.providers;

import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.servicejob.ui.providers.Messages;
import java.text.DateFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ServiceJobLabelProvider
implements ITableLabelProvider {
    private static final String DEFAULT_ERROR = Messages.getString("ServiceJobsLabelProvider.default_error");
    private static final String DEFAULT_N_A = Messages.getString("ServiceJobsLabelProvider.default_n_a");

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = DEFAULT_ERROR;
        if (element instanceof IServiceJob) {
            IServiceJob serviceJob = (IServiceJob)element;
            switch (columnIndex) {
                case 0: {
                    result = serviceJob.getName();
                    break;
                }
                case 1: {
                    result = serviceJob.getProject().getName();
                    break;
                }
                case 2: {
                    result = serviceJob.getSummary().toString();
                    break;
                }
                case 3: {
                    if (serviceJob.getLastUpdate() != null) {
                        result = DateFormat.getDateTimeInstance().format(serviceJob.getLastUpdate());
                        break;
                    }
                    result = DEFAULT_N_A;
                    break;
                }
                case 4: {
                    result = serviceJob.getServiceJobDescription();
                }
            }
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

