/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.wizard;

import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.wizards.jobsubmission.JobServiceSelectionWizardPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobSubmissionServiceWizard
extends Wizard {
    private JobServiceSelectionWizardPage selectionPage;
    private IVirtualOrganization vo;
    private IGridJobService selectedService;

    public JobSubmissionServiceWizard(IVirtualOrganization vo) {
        this.vo = vo;
    }

    public void addPages() {
        this.selectionPage = new JobServiceSelectionWizardPage("Select job submission service", null);
        this.selectionPage.setTitle("Submitting Operator's Job");
        Job job = new Job("Retrieving list of job services"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display display = workbench.getDisplay();
                display.syncExec(new Runnable(){

                    public void run() {
                        JobSubmissionServiceWizard.this.selectionPage.setServices(JobSubmissionServiceWizard.this.getJobServices());
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean performFinish() {
        this.selectedService = this.selectionPage.getSubmissionService();
        return true;
    }

    private List<IGridJobService> getJobServices() {
        ArrayList<IGridJobService> result = new ArrayList<IGridJobService>();
        try {
            IGridJobService[] jobServices;
            IGridJobService[] iGridJobServiceArray = jobServices = this.vo.getJobSubmissionServices((IProgressMonitor)new NullProgressMonitor());
            int n = jobServices.length;
            int n2 = 0;
            while (n2 < n) {
                IGridJobService service = iGridJobServiceArray[n2];
                result.add(service);
                ++n2;
            }
        }
        catch (ProblemException e) {
            ProblemDialog.openProblem((Shell)this.getShell(), (String)"Failed to submit job", (String)"Fetching of the submission services failed", (Throwable)e);
        }
        return result;
    }

    public IGridJobService getSelectedService() {
        return this.selectedService;
    }

    public boolean canFinish() {
        return super.canFinish() && this.selectionPage.getSubmissionService() != null;
    }
}

