/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.wizard;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.servicejob.ui.Activator;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ProjectSelectionPage
extends WizardPage {
    static IGridProject selectedProject;
    String serviceJobName;
    Text nameText;
    private Tree tree;
    private IGridProject initialProject;

    public ProjectSelectionPage(String pageName) {
        super(pageName);
        this.setTitle("Project selection page");
        this.setDescription("Choose project that contains services you want to perform operator's job on.");
    }

    public ProjectSelectionPage(String pageName, IGridProject selectedProject) {
        this(pageName);
        this.initialProject = selectedProject;
        if (this.initialProject != null) {
            ProjectSelectionPage.selectedProject = this.initialProject;
        }
    }

    protected void updateButtons() {
        this.getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        boolean flag = false;
        this.setErrorMessage(null);
        if (selectedProject != null && this.serviceJobName != null && !this.serviceJobName.equals("")) {
            IFile serviceJobFile;
            flag = true;
            IPath projectPath = selectedProject.getPath();
            IPath serviceJobsFolderPath = projectPath.append("/.serviceJobs/");
            IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
            IFolder serviceJobsFolder = workspaceRoot.getFolder(serviceJobsFolderPath);
            if (serviceJobsFolder.exists() && (serviceJobFile = serviceJobsFolder.getFile(String.valueOf(this.serviceJobName) + ".gtdl")).exists()) {
                this.setErrorMessage("Operator's Job with this name already exists.");
                flag = false;
            }
        }
        return flag && this.getNextPage() != null;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        gd.widthHint = 250;
        TreeViewer treeViewer = new TreeViewer(mainComp, 2052);
        treeViewer.setContentProvider((IContentProvider)new CProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new LProvider());
        treeViewer.setInput((Object)GridModel.getRoot());
        this.setTree(treeViewer.getTree());
        this.getTree().setLayoutData((Object)gd);
        this.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedData = ((Tree)e.getSource()).getSelection()[0].getData();
                if (selectedData instanceof IGridProject) {
                    selectedProject = (IGridProject)selectedData;
                    ProjectSelectionPage.this.updateButtons();
                }
            }
        });
        this.tree.deselectAll();
        this.tree.update();
        treeViewer.refresh();
        treeViewer.refresh(true);
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof IGridProject && item.getData().equals(this.initialProject)) {
                this.tree.setSelection(item);
                break;
            }
            ++n2;
        }
        Composite textComp = new Composite(mainComp, 0);
        textComp.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        textComp.setLayoutData((Object)gd);
        Label nameLabel = new Label(textComp, 16384);
        nameLabel.setText("Operator's Job name");
        gd = new GridData();
        nameLabel.setLayoutData((Object)gd);
        this.nameText = new Text(textComp, 18432);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectSelectionPage.this.serviceJobName = ProjectSelectionPage.this.nameText.getText();
                ProjectSelectionPage.this.updateButtons();
            }
        });
        this.setControl((Control)mainComp);
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public IGridProject getProject() {
        return selectedProject;
    }

    private void setTree(Tree tree) {
        this.tree = tree;
    }

    private Tree getTree() {
        return this.tree;
    }

    public String getJobName() {
        return this.serviceJobName;
    }

    class CProvider
    implements ITreeContentProvider {
        CProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return new Object();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IGridProject> projects = new ArrayList<IGridProject>();
            IGridElement[] elements = null;
            try {
                elements = ((IGridRoot)inputElement).getChildren(null);
            }
            catch (ProblemException e) {
                ProblemDialog.openProblem((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error when fetching children", (String)("Error when fetching children of " + inputElement.toString()), (Throwable)e);
            }
            IGridElement[] iGridElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement elem = iGridElementArray[n2];
                if (elem instanceof IGridProject && !((IGridProject)elem).isHidden() && ((IGridProject)elem).hasGridNature() && ((IGridProject)elem).isOpen()) {
                    projects.add((IGridProject)elem);
                }
                ++n2;
            }
            return projects.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LProvider
    implements ILabelProvider {
        private Image projectImage;

        public LProvider() {
            URL argsURL = Activator.getDefault().getBundle().getEntry("icons/gridprojects.gif");
            ImageDescriptor argsDesc = ImageDescriptor.createFromURL((URL)argsURL);
            this.projectImage = argsDesc.createImage();
        }

        public Image getImage(Object element) {
            return this.projectImage;
        }

        public String getText(Object element) {
            return ((IGridProject)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.projectImage.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

