/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.ui.wizard;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.servicejob.ui.Activator;
import eu.geclipse.servicejob.ui.internal.CategoryContainer;
import eu.geclipse.servicejob.ui.internal.CategoryResourcesTreeCProvider;
import eu.geclipse.servicejob.ui.internal.CategoryResourcesTreeLProvider;
import eu.geclipse.ui.wizards.IProjectSelectionProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesSelectionPage
extends WizardPage {
    CheckboxTreeViewer viewer;
    private IProjectSelectionProvider projectProvider;
    private IVirtualOrganization oldVO;
    private List<IGridResourceCategory> visibleCategories = new ArrayList<IGridResourceCategory>();
    private Button selectAllButton;
    private Button revertSelectionButton;
    private Button deselectAllButton;

    public ResourcesSelectionPage(IProjectSelectionProvider selectionProvider, String pageName) {
        super(pageName);
        this.projectProvider = selectionProvider;
        this.setTitle("Resource selection");
        this.setDescription("Choose services to perform operator's job on.");
        this.oldVO = null;
        this.visibleCategories.add(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"));
        this.visibleCategories.add(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.storage"));
    }

    public void addVisibleCategory(IGridResourceCategory resourceCategory) {
        if (!this.visibleCategories.contains(resourceCategory)) {
            this.visibleCategories.add(resourceCategory);
        }
    }

    public void removeVisibleCategory(IGridResourceCategory resourceCategory) {
        this.visibleCategories.remove(resourceCategory);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setSelectedVO(this.projectProvider.getGridProject().getVO());
        } else {
            this.oldVO = this.projectProvider.getGridProject().getVO();
        }
        this.updateButtons();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.canFlipToNextPage();
    }

    public boolean canFlipToNextPage() {
        boolean flag = false;
        if (this.viewer.getCheckedElements().length != 0) {
            flag = true;
        }
        return flag && this.getNextPage() != null;
    }

    public List<IGridResource> getSelectedResources() {
        ArrayList<IGridResource> result = new ArrayList<IGridResource>();
        Object[] objectArray = this.viewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            if (checked instanceof IGridResource) {
                result.add((IGridResource)checked);
            }
            ++n2;
        }
        return result;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        gd.horizontalSpan = 1;
        gd.widthHint = 300;
        gd.heightHint = 100;
        Tree tree = new Tree(mainComp, 2848);
        tree.setLayoutData((Object)gd);
        this.viewer = new CheckboxTreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new CategoryResourcesTreeCProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new CategoryResourcesTreeLProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResourcesSelectionPage.this.updateParent(event);
                if (event.getChecked()) {
                    ResourcesSelectionPage.this.viewer.setSubtreeChecked(event.getElement(), true);
                } else {
                    ResourcesSelectionPage.this.viewer.setSubtreeChecked(event.getElement(), false);
                }
                ResourcesSelectionPage.this.updateButtons();
            }
        });
        this.createButtons(mainComp);
        this.setControl((Control)mainComp);
    }

    private void createButtons(Composite composite) {
        Composite buttonsComp = new Composite(composite, 0);
        buttonsComp.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData();
        buttonsComp.setLayoutData((Object)gd);
        this.selectAllButton = new Button(buttonsComp, 8);
        gd = new GridData(768);
        this.selectAllButton.setText("Select all");
        this.selectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton = new Button(buttonsComp, 8);
        gd = new GridData(768);
        this.deselectAllButton.setLayoutData((Object)gd);
        this.deselectAllButton.setText("Deselect all");
        this.revertSelectionButton = new Button(buttonsComp, 8);
        gd = new GridData(768);
        this.revertSelectionButton.setLayoutData((Object)gd);
        this.revertSelectionButton.setText("Revert selection");
        this.createListenersForButtons();
    }

    private void changeStateAllTreeItems(boolean checked) {
        CategoryContainer[] input;
        CategoryContainer[] categoryContainerArray = input = (CategoryContainer[])this.viewer.getInput();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryContainer category = categoryContainerArray[n2];
            this.viewer.setChecked((Object)category, checked);
            this.viewer.setSubtreeChecked((Object)category, checked);
            this.updateButtons();
            ++n2;
        }
    }

    private void revertSelection() {
        CategoryContainer[] input;
        CategoryContainer[] categoryContainerArray = input = (CategoryContainer[])this.viewer.getInput();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryContainer category = categoryContainerArray[n2];
            IGridResource childRef = null;
            boolean child = true;
            Iterator<IGridResource> iterator = category.getContainedResources().iterator();
            while (iterator.hasNext()) {
                IGridResource resource;
                child = this.viewer.getChecked((Object)(resource = iterator.next()));
                this.viewer.setChecked((Object)resource, !child);
                if (!child) continue;
                childRef = resource;
            }
            if (childRef == null) {
                childRef = category.getContainedResources().get(0);
            }
            this.updateParent(childRef);
            ++n2;
        }
    }

    private void createListenersForButtons() {
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourcesSelectionPage.this.changeStateAllTreeItems(true);
                ResourcesSelectionPage.this.updateButtons();
            }
        });
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourcesSelectionPage.this.changeStateAllTreeItems(false);
                ResourcesSelectionPage.this.updateButtons();
            }
        });
        this.revertSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourcesSelectionPage.this.revertSelection();
                ResourcesSelectionPage.this.updateButtons();
            }
        });
    }

    void updateParent(Object element) {
        if (element instanceof IGridResource) {
            IGridResource gridResource = (IGridResource)element;
            CategoryContainer[] input = (CategoryContainer[])this.viewer.getInput();
            CategoryContainer parent = null;
            CategoryContainer[] categoryContainerArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                CategoryContainer category = categoryContainerArray[n2];
                if (category.getContainedResources().contains(gridResource)) {
                    parent = category;
                    break;
                }
                ++n2;
            }
            if (parent != null) {
                if (this.viewer.getChecked(element)) {
                    boolean childrenChecked = true;
                    for (IGridResource child : parent.getContainedResources()) {
                        if (this.viewer.getChecked((Object)child)) continue;
                        childrenChecked = false;
                        break;
                    }
                    this.viewer.setChecked((Object)parent, childrenChecked);
                } else {
                    this.viewer.setChecked((Object)parent, false);
                }
            }
        }
    }

    protected void updateButtons() {
        this.getContainer().updateButtons();
    }

    public void setSelectedVO(IVirtualOrganization vo) {
        if (this.viewer != null) {
            try {
                ArrayList<CategoryContainer> categories = new ArrayList<CategoryContainer>();
                for (IGridResourceCategory category : this.visibleCategories) {
                    CategoryContainer catContainer = new CategoryContainer(category);
                    categories.add(catContainer);
                    IGridResource[] resources = vo.getAvailableResources(category, false, (IProgressMonitor)new NullProgressMonitor());
                    if (resources == null) continue;
                    IGridResource[] iGridResourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IGridResource res = iGridResourceArray[n2];
                        catContainer.addResource(res);
                        ++n2;
                    }
                }
                CategoryContainer[] input = new CategoryContainer[categories.size()];
                input = categories.toArray(input);
                this.viewer.setInput((Object)input);
                this.viewer.refresh();
                this.viewer.expandAll();
            }
            catch (ProblemException e) {
                Activator.logException(e);
            }
        }
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof IGridResource[]) {
                IGridResource[] candidateHostsType = (IGridResource[])inputElement;
                result = candidateHostsType;
            } else if (inputElement instanceof String[]) {
                result = (String[])inputElement;
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
        }
    }

    class LabelProvider1
    extends LabelProvider
    implements ITableLabelProvider {
        private Image argsImage;
        private Image computingImg;
        private Image storageImg;
        private Image serviceImg;

        public LabelProvider1() {
            this.loadImages();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image image = null;
            switch (columnIndex) {
                case 0: {
                    if (element instanceof IGridComputing) {
                        image = this.computingImg;
                        break;
                    }
                    if (element instanceof IGridStorage) {
                        image = this.storageImg;
                        break;
                    }
                    if (!(element instanceof IGridService)) break;
                    image = this.serviceImg;
                    break;
                }
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            Object[] array = null;
            if (element instanceof Object[]) {
                array = (Object[])element;
            } else if (element instanceof IGridResource) {
                switch (columnIndex) {
                    case 0: {
                        text = ((IGridResource)element).getName();
                        break;
                    }
                }
            } else if (element instanceof String) {
                text = element.toString();
            }
            if (array != null && columnIndex < array.length) {
                text = this.getText(array[columnIndex]);
            }
            return text;
        }

        void loadImages() {
            URL argsURL = Activator.getDefault().getBundle().getEntry("icons/etool16/args.gif");
            URL candHostsURL = Activator.getDefault().getBundle().getEntry("icons/etool16/computing_obj.gif");
            URL storageURL = Activator.getDefault().getBundle().getEntry("icons/etool16/storage.gif");
            URL serviceURL = Activator.getDefault().getBundle().getEntry("icons/etool16/service.gif");
            ImageDescriptor argsDesc = ImageDescriptor.createFromURL((URL)argsURL);
            ImageDescriptor candHostsDesc = ImageDescriptor.createFromURL((URL)candHostsURL);
            ImageDescriptor storageDesc = ImageDescriptor.createFromURL((URL)storageURL);
            ImageDescriptor serviceDesc = ImageDescriptor.createFromURL((URL)serviceURL);
            this.argsImage = argsDesc.createImage();
            this.computingImg = candHostsDesc.createImage();
            this.storageImg = storageDesc.createImage();
            this.serviceImg = serviceDesc.createImage();
        }
    }
}

