/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.model;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobResult;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.servicejob.Activator;
import eu.geclipse.servicejob.model.Messages;
import eu.geclipse.servicejob.model.ServiceJobStates;
import eu.geclipse.servicejob.model.impl.ServiceJobResult;
import eu.geclipse.servicejob.parsers.GTDLParser;
import eu.geclipse.servicejob.parsers.GTDLWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServiceJob
extends AbstractGridElement
implements IServiceJob {
    protected IGridJobService submissionService;
    protected String serviceJobInputData;
    protected String name;
    protected List<IServiceJobResult> results = new ArrayList<IServiceJobResult>();
    protected List<Date> submissionDates = new ArrayList<Date>();
    protected IServiceJobResult lastResult;
    protected List<String> serviceJobNames = new ArrayList<String>();
    protected List<String> serviceJobResources = new ArrayList<String>();
    private IFile resource = null;

    public String getName() {
        return this.name;
    }

    public List<IServiceJobResult> getResults() {
        return this.results;
    }

    public List<String> getServiceJobResourcesNames() {
        return this.serviceJobResources;
    }

    public IServiceJobResult getSingleServiceJobResult(String serviceJobName, String resourceName, Date date) {
        IServiceJobResult result1 = null;
        for (IServiceJobResult subServiceJob : this.results) {
            if (!subServiceJob.getResourceName().equals(resourceName) || !serviceJobName.equalsIgnoreCase(subServiceJob.getSubServiceJobName()) || !date.equals(subServiceJob.getRunDate())) continue;
            result1 = subServiceJob;
        }
        return result1;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public IResource getResource() {
        return this.resource;
    }

    public final void internalInit(IFile initInputData) {
        this.resource = initInputData;
        this.name = this.resource.getName().substring(0, this.resource.getName().lastIndexOf("."));
        try {
            this.serviceJobResources = GTDLParser.getServiceJobResources(this.resource.getRawLocation().toFile());
            this.serviceJobInputData = GTDLParser.getInputServiceJobData(this.resource.getRawLocation().toFile());
            this.results = new ArrayList<IServiceJobResult>();
            List<ServiceJobResult> resultsTemp = GTDLParser.getServiceJobResults(this.resource.getRawLocation().toFile());
            this.results.addAll(resultsTemp);
            this.lastResult = this.computeLastResult(this.results);
            this.init();
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (DOMException e) {
            Activator.logException(e);
        }
        catch (ParseException e) {
            Activator.logException(e);
        }
    }

    public Object getStatus() {
        return null;
    }

    public Date getLastUpdate() {
        return this.lastResult != null ? this.lastResult.getRunDate() : null;
    }

    public String getSummary() {
        String res = ServiceJobStates.NA.getAlias();
        if (this.lastResult != null && this.lastResult instanceof ServiceJobResult) {
            res = ((ServiceJobResult)this.lastResult).getResultEnum();
        }
        return res;
    }

    public List<List<IServiceJobResult>> getServiceJobResultsForResourceForDate(String resourceName) {
        ArrayList<List<IServiceJobResult>> resultL = new ArrayList<List<IServiceJobResult>>();
        HashMap tempDatesMap = new HashMap();
        for (IServiceJobResult singleResult : this.results) {
            if (!singleResult.getResourceName().equalsIgnoreCase(resourceName)) continue;
            if (!tempDatesMap.containsKey(singleResult.getRunDate())) {
                tempDatesMap.put(singleResult.getRunDate(), new ArrayList());
            }
            ((List)tempDatesMap.get(singleResult.getRunDate())).add(singleResult);
        }
        for (List resultList : tempDatesMap.values()) {
            resultL.add(resultList);
        }
        return resultL;
    }

    public IGridContainer getParent() {
        IGridContainer parent = null;
        IPath parentPath = this.getPath().removeLastSegments(1);
        IGridElement parentElement = GridModel.getRoot().findElement(parentPath);
        if (parentElement instanceof IGridContainer) {
            parent = (IGridContainer)parentElement;
        }
        return parent;
    }

    public IPath getPath() {
        return this.getResource() != null ? this.getResource().getFullPath() : null;
    }

    public IGridElementManager getManager() {
        return GridModel.getServiceJobManager();
    }

    public void addServiceJobResult(List<IServiceJobResult> newResults) {
        try {
            GTDLWriter.addServiceJobResults(this.resource.getRawLocation().toFile(), newResults);
            if (!this.resource.isSynchronized(0)) {
                try {
                    this.resource.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            this.results.addAll(newResults);
            this.lastResult = this.computeLastResult(newResults);
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            Activator.logException(e);
        }
        catch (TransformerException e) {
            Activator.logException(e);
        }
    }

    public Date getLastUpdate(String serviceJobResourceName) {
        Date res = null;
        if (this.results != null && !this.results.isEmpty()) {
            res = new Date(0L);
            for (IServiceJobResult sjResult : this.results) {
                if (!sjResult.getResourceName().equalsIgnoreCase(serviceJobResourceName) || !sjResult.getRunDate().after(res)) continue;
                res = sjResult.getRunDate();
            }
        }
        return res;
    }

    private IServiceJobResult computeLastResult(List<IServiceJobResult> resultsToComp) {
        IServiceJobResult res = null;
        Date tempDate = new Date(0L);
        for (IServiceJobResult result : resultsToComp) {
            if (tempDate != null && !tempDate.before(result.getRunDate())) continue;
            tempDate = result.getRunDate();
            res = result;
        }
        return res;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(Messages.getString("AbstractServiceJob.service_job_name_property"), this.name);
        res.put(Messages.getString("AbstractServiceJob.description_property"), this.getServiceJobDescription());
        return res;
    }

    public void setResource(IFile resource) {
        this.resource = resource;
    }

    public IFolder getServiceJobFolder() {
        IFolder folder = this.getResource().getParent().getFolder((IPath)new Path(String.valueOf(this.name) + "_files"));
        if (!folder.exists()) {
            try {
                folder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException exc) {
                Activator.logException(exc);
            }
        }
        return folder;
    }

    public int getColumnWidth(String singleServiceJobName) {
        return 200;
    }

    public IGridJobService getSubmissionService() {
        return this.submissionService;
    }

    public boolean needsSubmissionWizard() {
        return false;
    }

    public void setSubmissionService(IGridJobService submissionService) {
        this.submissionService = submissionService;
    }
}

