/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.model.submittable.job;

import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IServiceJobResult;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.servicejob.Activator;
import eu.geclipse.servicejob.model.AbstractServiceJob;
import eu.geclipse.servicejob.model.submittable.job.Messages;
import eu.geclipse.servicejob.model.submittable.job.ServiceJobUpdater;
import eu.geclipse.servicejob.model.submittable.job.SubmittableServiceJobResult;
import eu.geclipse.servicejob.parsers.GTDLJobParser;
import eu.geclipse.servicejob.parsers.GTDLJobWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public abstract class AbstractSubmittableServiceJob
extends AbstractServiceJob {
    public static final String SERVICE_JOB_INFO_FILENAME = ".servicejobinfo";
    public static final String XML_CHARSET = "ISO-8859-1";
    public static final String SERVICE_JOB_STATUS_FILENAME = ".servicejobstatus";
    protected Map<String, String> jobIDResourceNameMap = new HashMap<String, String>();
    protected ServiceJobUpdater updater;

    public boolean isLocal() {
        return true;
    }

    public void init() {
        this.name = this.getResource().getName().substring(0, this.getResource().getName().lastIndexOf("."));
        IFile file = (IFile)this.getResource();
        try {
            List<SubmittableServiceJobResult> tempRes = GTDLJobParser.getServiceJobResults(file.getRawLocation().toFile());
            this.results = new ArrayList();
            for (SubmittableServiceJobResult result : tempRes) {
                this.results.add(result);
                result.setJobID(this.createJobID(result));
            }
            ArrayList<IGridJobID> jobIDsToRun = new ArrayList<IGridJobID>();
            for (SubmittableServiceJobResult serviceJobResult : tempRes) {
                if (!serviceJobResult.getResultEnum().equals(Messages.getString("AbstractSubmittableJob.running_status")) && !serviceJobResult.getResultEnum().equals(Messages.getString("AbstractSubmittableJob.pending_status"))) continue;
                jobIDsToRun.add(serviceJobResult.getJobID());
            }
            if (jobIDsToRun.size() > 0) {
                ServiceJobUpdater serviceJobUpdater = this.getUpdater();
                serviceJobUpdater.addSubJobs(jobIDsToRun);
                serviceJobUpdater.schedule(30000L);
            }
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        catch (DOMException e) {
            Activator.logException(e);
        }
        catch (ParseException e) {
            Activator.logException(e);
        }
        this.initData();
    }

    public abstract IGridJobID createJobID(SubmittableServiceJobResult var1);

    public abstract void initData();

    public ServiceJobUpdater getUpdater() {
        if (this.updater == null) {
            this.updater = new ServiceJobUpdater(this.getName(), this);
        }
        return this.updater;
    }

    public void run() {
        Job runJob = new Job(String.valueOf(Messages.getString("AbstractSubmittableJob.submitting")) + " " + this.getName() + " " + Messages.getString("AbstractSubmittableJob.job")){

            protected IStatus run(IProgressMonitor uMonitor) {
                IStatus status = Status.OK_STATUS;
                IProgressMonitor monitor = uMonitor != null ? uMonitor : new NullProgressMonitor();
                ArrayList<IGridJobID> jobIDsToAdd = new ArrayList<IGridJobID>();
                for (String resourceName : AbstractSubmittableServiceJob.this.getServiceJobResourcesNames()) {
                    IGridJobDescription description = AbstractSubmittableServiceJob.this.getJSDLForSubmission(resourceName);
                    IGridJobService jobService = AbstractSubmittableServiceJob.this.getSubmissionService();
                    if (description == null || jobService == null) continue;
                    try {
                        IGridJobID jobID = jobService.submitJob(description, monitor);
                        AbstractSubmittableServiceJob.this.jobIDResourceNameMap.put(jobID.getJobID(), resourceName);
                        jobIDsToAdd.add(jobID);
                        AbstractSubmittableServiceJob.this.createNewResult(jobID, resourceName, Calendar.getInstance().getTime());
                    }
                    catch (ProblemException exc) {
                        status = new Status(4, "eu.geclipse.servicejob", Messages.getString("AbstractSubmittableJob.Error_submitting_job"), (Throwable)exc);
                    }
                }
                if (jobIDsToAdd.size() > 0) {
                    ServiceJobUpdater serviceJobUpdater = AbstractSubmittableServiceJob.this.getUpdater();
                    serviceJobUpdater.addSubJobs(jobIDsToAdd);
                    serviceJobUpdater.schedule(30000L);
                }
                return status;
            }
        };
        runJob.schedule();
    }

    public abstract IGridJobDescription getJSDLForSubmission(String var1);

    public void setJobResult(IGridJobID jobID, Date lastRefreshDate, String status, String besStatus) {
        SubmittableServiceJobResult serviceJobResult = null;
        for (IServiceJobResult tempResult1 : this.results) {
            SubmittableServiceJobResult tempResult = (SubmittableServiceJobResult)tempResult1;
            if (!tempResult.getJobIDString().equals(jobID.getJobID())) continue;
            serviceJobResult = tempResult;
        }
        if (serviceJobResult != null) {
            serviceJobResult.updateStatus(lastRefreshDate, status, besStatus);
            ArrayList<SubmittableServiceJobResult> ress = new ArrayList<SubmittableServiceJobResult>();
            ress.add(serviceJobResult);
            try {
                GTDLJobWriter.addServiceJobResults(this.getResource().getRawLocation().toFile(), ress);
                this.lastResult = serviceJobResult;
                if (!this.getResource().isSynchronized(0)) {
                    try {
                        this.getResource().refreshLocal(0, null);
                    }
                    catch (CoreException e) {
                        Activator.logException(e);
                    }
                }
            }
            catch (ParserConfigurationException e) {
                Activator.logException(e);
            }
            catch (SAXException e) {
                Activator.logException(e);
            }
            catch (IOException e) {
                Activator.logException(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                Activator.logException(e);
            }
            catch (TransformerException e) {
                Activator.logException(e);
            }
        }
    }

    public void createNewResult(IGridJobID jobID, String resourceName, Date submissionDate) {
        for (String singleServiceJobName : this.getSingleServiceJobNames()) {
            SubmittableServiceJobResult serviceJobResult = new SubmittableServiceJobResult(submissionDate, resourceName, singleServiceJobName, this.getRawDataInput(jobID, resourceName), Messages.getString("AbstractSubmittableJob.pending_status"), this.getResultType(singleServiceJobName), Messages.getString("AbstractSubmittableJob.pending_status"));
            serviceJobResult.setJobID(jobID);
            this.results.add(serviceJobResult);
            ArrayList<SubmittableServiceJobResult> ress = new ArrayList<SubmittableServiceJobResult>();
            ress.add(serviceJobResult);
            try {
                GTDLJobWriter.addServiceJobResults(this.getResource().getRawLocation().toFile(), ress);
                if (this.getResource().isSynchronized(0)) continue;
                try {
                    this.getResource().refreshLocal(0, null);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            catch (ParserConfigurationException e) {
                Activator.logException(e);
            }
            catch (SAXException e) {
                Activator.logException(e);
            }
            catch (IOException e) {
                Activator.logException(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                Activator.logException(e);
            }
            catch (TransformerException e) {
                Activator.logException(e);
            }
        }
    }

    public abstract String getResultType(String var1);

    public abstract String getRawDataInput(IGridJobID var1, String var2);

    public abstract void computeJobResult(IGridJobID var1, IGridJobStatus var2);

    public abstract void computeServiceJobResult();

    protected InputStream getContentsStream(String path, String bundle) {
        FileInputStream resultStream = null;
        Path resultPath = new Path(path);
        URL fileURL = FileLocator.find((Bundle)Platform.getBundle((String)bundle), (IPath)resultPath, null);
        try {
            fileURL = FileLocator.toFileURL((URL)fileURL);
        }
        catch (IOException ioException) {
            Activator.logException(ioException);
        }
        catch (NullPointerException nullExc) {
            Activator.logException(nullExc);
        }
        String temp = fileURL.toString();
        temp = temp.substring(temp.indexOf(fileURL.getProtocol()) + fileURL.getProtocol().length() + 1, temp.length());
        resultPath = new Path(temp);
        File file = resultPath.toFile();
        try {
            resultStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            Activator.logException(e);
        }
        return resultStream;
    }

    public IVirtualOrganization getSelectedJobsVO() {
        return this.getProject() != null ? this.getProject().getVO() : null;
    }

    protected IFileStore getFileViaDirectory(IFileSystem fileSystem, URI fileUri) throws ProblemException {
        try {
            Path filePath = new Path(fileUri.getPath());
            IPath folderPath = filePath.removeLastSegments(1).addTrailingSeparator();
            URI dirUri = new URI(fileUri.getScheme(), fileUri.getUserInfo(), fileUri.getHost(), fileUri.getPort(), folderPath.toString(), fileUri.getQuery(), fileUri.getFragment());
            IFileStore dirStore = fileSystem.getStore(dirUri);
            dirStore.childNames(0, null);
            return dirStore.getChild(filePath.lastSegment());
        }
        catch (URISyntaxException exception) {
            throw new ProblemException("eu.geclipse.core.problem.net.malformedURL", (Throwable)exception, "eu.geclipse.servicejob");
        }
        catch (CoreException exception) {
            throw new ProblemException("eu.geclipse.core.problem.io.unspecified", (Throwable)exception, "eu.geclipse.servicejob");
        }
    }

    public int getColumnWidth(String singleServiceJobName) {
        return 200;
    }

    public boolean needsSubmissionWizard() {
        return true;
    }
}

