/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.model.submittable.job;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.core.model.IServiceJob;
import eu.geclipse.core.model.IServiceJobStatusListener;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.servicejob.Activator;
import eu.geclipse.servicejob.model.ServiceJobStates;
import eu.geclipse.servicejob.model.submittable.job.AbstractSubmittableServiceJob;
import eu.geclipse.servicejob.model.submittable.job.Messages;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJobUpdater
extends Job {
    private Set<IGridJobID> jobIDs = new HashSet<IGridJobID>();
    private List<IServiceJobStatusListener> listeners = new ArrayList<IServiceJobStatusListener>();
    private AbstractSubmittableServiceJob serviceJob;

    public ServiceJobUpdater(String name, AbstractSubmittableServiceJob serviceJob) {
        super(name);
        this.serviceJob = serviceJob;
        this.listeners.add((IServiceJobStatusListener)GridModel.getServiceJobManager());
    }

    public void addSubJobs(List<IGridJobID> jobIDsToAdd) {
        for (IGridJobID jobID : jobIDsToAdd) {
            this.jobIDs.add(jobID);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        Date lastRefreshTime = null;
        ArrayList<IGridJobID> jobIDsToDelete = new ArrayList<IGridJobID>();
        for (IGridJobID jobID : this.jobIDs) {
            IGridElementCreator srvCreator;
            if (!this.jobIDs.contains(jobID) || (srvCreator = GridModel.getCreatorRegistry().getCreator((Object)jobID, IGridJobService.class)) == null) continue;
            try {
                IGridJobService jobService = (IGridJobService)srvCreator.create(null);
                IVirtualOrganization vo = null;
                if (this.serviceJob != null && this.serviceJob.getProject() != null) {
                    vo = this.serviceJob.getProject().getVO();
                }
                IGridJobStatus newStatus = jobService.getJobStatus(jobID, vo, false, monitor);
                lastRefreshTime = newStatus.getLastUpdateTime();
                if (newStatus.canChange()) {
                    this.serviceJob.setJobResult(jobID, lastRefreshTime, Messages.getString("SubmittableJobUpdater.running_status"), ServiceJobStates.RUNNING.getAlias());
                    continue;
                }
                jobIDsToDelete.add(jobID);
                this.serviceJob.setJobResult(jobID, lastRefreshTime, Messages.getString("SubmittableJobUpdater.finished_status"), newStatus.isSuccessful() ? ServiceJobStates.OK.getAlias() : ServiceJobStates.WARNING.getAlias());
                this.serviceJob.computeJobResult(jobID, newStatus);
            }
            catch (ProblemException exc) {
                Activator.logException(exc);
            }
        }
        for (IGridJobID jobIDToDelete : jobIDsToDelete) {
            this.jobIDs.remove(jobIDToDelete);
        }
        jobIDsToDelete.clear();
        if (this.jobIDs.size() > 0) {
            this.schedule(60000L);
        } else {
            this.serviceJob.computeServiceJobResult();
        }
        for (IServiceJobStatusListener listener : this.listeners) {
            listener.statusChanged((IServiceJob)this.serviceJob);
        }
        return status;
    }
}

