/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.parsers;

import eu.geclipse.servicejob.Activator;
import eu.geclipse.servicejob.model.submittable.job.SubmittableServiceJobResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTDLJobParser {
    public static final String SCHEMA_LOCATION = "xml/GTDL_schema.xsd";
    public static final String OUTPUT_RESULT_ELEMENT = "result";
    public static final String OUTPUT_RESULT_RESOURCE = "resource";
    public static final String OUTPUT_RESULT_DATE = "date";
    public static final String OUTPUT_RESULT_SERVICE_JOB = "simpleServiceJob";
    public static final String OUTPUT_RESULT_DATA = "resultData";
    public static final String OUTPUT_RESULT_SUMMARY = "resultSummary";
    public static final String OUTPUT_RESULT_ENUM = "BESStatusType";
    public static final String OUTPUT_RESULT_TYPE = "resultType";

    public static List<SubmittableServiceJobResult> getServiceJobResults(File file) throws ParserConfigurationException, SAXException, IOException, DOMException, ParseException {
        ArrayList<SubmittableServiceJobResult> result = new ArrayList<SubmittableServiceJobResult>();
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList resultsXML = document.getElementsByTagName(OUTPUT_RESULT_ELEMENT);
        int i = 0;
        while (i < resultsXML.getLength()) {
            Node node = resultsXML.item(i);
            Element singleResult = (Element)node;
            Date date = DateFormat.getDateTimeInstance().parse(((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_DATE).item(0)).getTextContent());
            SubmittableServiceJobResult serviceJobResult = new SubmittableServiceJobResult(date, ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_RESOURCE).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_SERVICE_JOB).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_DATA).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_SUMMARY).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_TYPE).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_ENUM).item(0)).getTextContent());
            result.add(serviceJobResult);
            ++i;
        }
        return result;
    }

    public static List<String> parseGeneralPartForResources(InputStream stream) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factoryDOM.newDocumentBuilder();
            Document document = builder.parse(stream);
            NodeList resultsXML = document.getElementsByTagName("resourceList");
            int i = 0;
            while (i < resultsXML.getLength()) {
                Element element = (Element)resultsXML.item(i);
                result.add(element.getChildNodes().item(0).getNodeValue().trim());
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            Activator.logException(e);
        }
        catch (SAXException e) {
            Activator.logException(e);
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        return result;
    }
}

