/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.parsers;

import eu.geclipse.servicejob.model.submittable.job.SubmittableServiceJobResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTDLJobWriter {
    public static final String SKELETON_LOCATION = "xml/GTDL_no_Output.xml";

    public static void addServiceJobResults(File file, List<SubmittableServiceJobResult> newResults) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        for (SubmittableServiceJobResult result : newResults) {
            Node nodeToDelete = null;
            NodeList resultsList = document.getElementsByTagName("result");
            int i = 0;
            while (i < resultsList.getLength()) {
                String rawDataString = ((Element)resultsList.item(i)).getElementsByTagName("resultData").item(0).getTextContent();
                DocumentBuilderFactory factoryDOM2 = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder2 = factoryDOM2.newDocumentBuilder();
                Document rawDataDocument = builder2.parse(new ByteArrayInputStream(rawDataString.getBytes()));
                Node jobIDNode = rawDataDocument.getElementsByTagName("Name").item(0);
                if (jobIDNode != null && jobIDNode.getTextContent().equals(result.getJobIDString())) {
                    nodeToDelete = resultsList.item(i);
                }
                ++i;
            }
            Element newElement = document.createElement("result");
            Element resourceElement = document.createElement("resource");
            resourceElement.setTextContent(result.getResourceName());
            Element updateElement = document.createElement("date");
            updateElement.setTextContent(DateFormat.getDateTimeInstance().format(result.getRunDate()));
            Element serviceJobNameElement = document.createElement("simpleServiceJob");
            serviceJobNameElement.setTextContent(result.getSubServiceJobName());
            Element outputResultDataElement = document.createElement("resultData");
            outputResultDataElement.setTextContent(result.getResultRawData());
            Element statusEnumElement = document.createElement("BESStatusType");
            statusEnumElement.setTextContent(result.getResultEnum());
            Element summaryElement = document.createElement("resultSummary");
            summaryElement.setTextContent(result.getResultSummary());
            Element typeElement = document.createElement("resultType");
            typeElement.setTextContent(result.getResultType());
            newElement.appendChild(resourceElement);
            newElement.appendChild(updateElement);
            newElement.appendChild(serviceJobNameElement);
            newElement.appendChild(outputResultDataElement);
            newElement.appendChild(statusEnumElement);
            newElement.appendChild(summaryElement);
            newElement.appendChild(typeElement);
            if (nodeToDelete != null) {
                document.getFirstChild().replaceChild(newElement, nodeToDelete);
            } else {
                document.getFirstChild().appendChild(newElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result1 = new StreamResult(file);
            transformer.transform(source, result1);
        }
    }
}

