/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.parsers;

import eu.geclipse.servicejob.model.impl.ServiceJobResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTDLParser {
    public static final String SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_LOCATION = "xml/GTDL_schema.xsd";
    public static final String INPUT_ELEMENT = "input";
    public static final String PLUGIN_ELEMENT = "pluginId";
    public static final String INPUT_DATA_ELEMENT = "inputData";
    public static final String OUTPUT_RESULT_ELEMENT = "result";
    public static final String OUTPUT_RESULT_RESOURCE = "resource";
    public static final String OUTPUT_RESULT_DATE = "date";
    public static final String OUTPUT_RESULT_SERVICE_JOB = "simpleServiceJob";
    public static final String OUTPUT_RESULT_DATA = "resultData";
    public static final String OUTPUT_RESULT_SUMMARY = "resultSummary";
    public static final String OUTPUT_RESULT_ENUM = "BESStatusType";
    public static final String OUTPUT_RESULT_TYPE = "resultType";
    public static final String INPUT_RESOURCES_LIST = "targetResources";
    public static final String INPUT_RESOURCE = "resource";

    public static void validateFile(File xmlFile) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance(SCHEMA_LANGUAGE);
        Path resultPath = new Path(SCHEMA_LOCATION);
        URL fileURL = FileLocator.find((Bundle)Platform.getBundle((String)"eu.geclipse.servicejob"), (IPath)resultPath, null);
        fileURL = FileLocator.toFileURL((URL)fileURL);
        String temp = fileURL.toString();
        temp = temp.substring(temp.indexOf(fileURL.getProtocol()) + fileURL.getProtocol().length() + 1, temp.length());
        resultPath = new Path(temp);
        File schemaLocation = resultPath.toFile();
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(xmlFile);
        validator.validate(source);
    }

    public static String getPluginId(File file) throws ParserConfigurationException, SAXException, IOException {
        String result = "";
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList resultsXML = document.getElementsByTagName(INPUT_ELEMENT);
        int i = 0;
        while (i < resultsXML.getLength()) {
            Element singleResult = (Element)resultsXML.item(i);
            result = ((Element)singleResult.getElementsByTagName(PLUGIN_ELEMENT).item(0)).getTextContent();
            ++i;
        }
        return result;
    }

    public static String getInputServiceJobData(File file) throws ParserConfigurationException, SAXException, IOException {
        String result = "";
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList resultsXML = document.getElementsByTagName(INPUT_ELEMENT);
        int i = 0;
        while (i < resultsXML.getLength()) {
            Element singleResult = (Element)resultsXML.item(i);
            result = ((Element)singleResult.getElementsByTagName(INPUT_DATA_ELEMENT).item(0)).getTextContent();
            ++i;
        }
        return result;
    }

    public static List<ServiceJobResult> getServiceJobResults(File file) throws ParserConfigurationException, SAXException, IOException, DOMException, ParseException {
        ArrayList<ServiceJobResult> result = new ArrayList<ServiceJobResult>();
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList resultsXML = document.getElementsByTagName(OUTPUT_RESULT_ELEMENT);
        int i = 0;
        while (i < resultsXML.getLength()) {
            Element singleResult = (Element)resultsXML.item(i);
            Date date = DateFormat.getDateTimeInstance().parse(((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_DATE).item(0)).getTextContent());
            result.add(new ServiceJobResult(date, ((Element)singleResult.getElementsByTagName("resource").item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_SERVICE_JOB).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_DATA).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_SUMMARY).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_TYPE).item(0)).getTextContent(), ((Element)singleResult.getElementsByTagName(OUTPUT_RESULT_ENUM).item(0)).getTextContent()));
            ++i;
        }
        return result;
    }

    public static List<String> getServiceJobResources(File file) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        NodeList resultsXML = document.getElementsByTagName(INPUT_RESOURCES_LIST);
        int i = 0;
        while (i < resultsXML.getLength()) {
            NodeList resources = ((Element)resultsXML.item(i)).getElementsByTagName("resource");
            int j = 0;
            while (j < resources.getLength()) {
                result.add(((Element)resources.item(j)).getTextContent());
                ++j;
            }
            ++i;
        }
        return result;
    }
}

