/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.servicejob.parsers;

import eu.geclipse.core.model.IServiceJobResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GTDLWriter {
    public static final String SKELETON_LOCATION = "xml/GTDL_no_Output.xml";

    public static InputStream getInitialInputStream(String plugInID, List<String> serviceJobResources, InputStream serviceJobInputData) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        ByteArrayInputStream result = null;
        Path resultPath = new Path(SKELETON_LOCATION);
        URL fileURL = FileLocator.find((Bundle)Platform.getBundle((String)"eu.geclipse.servicejob"), (IPath)resultPath, null);
        fileURL = FileLocator.toFileURL((URL)fileURL);
        String temp = fileURL.toString();
        temp = temp.substring(temp.indexOf(fileURL.getProtocol()) + fileURL.getProtocol().length() + 1, temp.length());
        resultPath = new Path(temp);
        File skeletonFile = resultPath.toFile();
        FileInputStream stream = new FileInputStream(skeletonFile);
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document doc = builder.parse(stream);
        NodeList pluginList = doc.getElementsByTagName("pluginId");
        NodeList dataList = doc.getElementsByTagName("inputData");
        NodeList resourcesList = doc.getElementsByTagName("targetResources");
        Node pluginElement = null;
        Element inputDataElement = null;
        Element resourcesElement = null;
        if (pluginList != null && pluginList.getLength() != 0 && dataList != null && dataList.getLength() != 0 && resourcesList != null && resourcesList.getLength() != 0) {
            pluginElement = (Element)pluginList.item(0);
            inputDataElement = (Element)dataList.item(0);
            resourcesElement = (Element)resourcesList.item(0);
        }
        if (pluginElement != null && inputDataElement != null && resourcesElement != null) {
            String line;
            pluginElement.setTextContent(plugInID);
            BufferedReader in = new BufferedReader(new InputStreamReader(serviceJobInputData));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            inputDataElement.setTextContent(buffer.toString());
            for (String resourceName : serviceJobResources) {
                Element resourceElement = doc.createElement("resource");
                resourceElement.setTextContent(resourceName);
                resourcesElement.appendChild(resourceElement);
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream arrStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(arrStream);
        transformer.transform(source, streamResult);
        arrStream = (ByteArrayOutputStream)streamResult.getOutputStream();
        result = new ByteArrayInputStream(arrStream.toByteArray());
        return result;
    }

    public static void addServiceJobResults(File file, List<IServiceJobResult> newResults) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        DocumentBuilderFactory factoryDOM = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factoryDOM.newDocumentBuilder();
        Document document = builder.parse(file);
        for (IServiceJobResult result : newResults) {
            Element newElement = document.createElement("result");
            Element resourceElement = document.createElement("resource");
            resourceElement.setTextContent(result.getResourceName());
            Element updateElement = document.createElement("date");
            updateElement.setTextContent(DateFormat.getDateTimeInstance().format(result.getRunDate()));
            Element serviceJobNameElement = document.createElement("simpleServiceJob");
            serviceJobNameElement.setTextContent(result.getSubServiceJobName());
            Element notAfterElement = document.createElement("resultData");
            notAfterElement.setTextContent(result.getResultRawData());
            Element statusEnumElement = document.createElement("BESStatusType");
            statusEnumElement.setTextContent(result.getResultEnum());
            Element summaryElement = document.createElement("resultSummary");
            summaryElement.setTextContent(result.getResultSummary());
            Element typeElement = document.createElement("resultType");
            typeElement.setTextContent(result.getResultType());
            newElement.appendChild(resourceElement);
            newElement.appendChild(updateElement);
            newElement.appendChild(serviceJobNameElement);
            newElement.appendChild(notAfterElement);
            newElement.appendChild(statusEnumElement);
            newElement.appendChild(summaryElement);
            newElement.appendChild(typeElement);
            document.getFirstChild().appendChild(newElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result1 = new StreamResult(file);
            transformer.transform(source, result1);
        }
    }
}

