/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.CharSet;
import eu.geclipse.terminal.internal.Cursor;
import eu.geclipse.terminal.internal.CursorKeyMode;
import eu.geclipse.terminal.internal.KeyPadMode;
import eu.geclipse.terminal.internal.LineHeightMode;
import eu.geclipse.terminal.internal.LineWidthMode;
import eu.geclipse.terminal.internal.Messages;
import eu.geclipse.terminal.internal.OriginMode;
import eu.geclipse.terminal.internal.ScrollMode;
import eu.geclipse.terminal.internal.TerminalPainter;
import eu.geclipse.terminal.internal.TerminalSelection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Terminal
extends Canvas
implements ISelectionProvider {
    private static final int BEL = 7;
    private static final int FF = 12;
    private static final int SO = 14;
    private static final int SI = 15;
    private static final int TAB_WIDTH = 8;
    OutputStream output;
    KeyPadMode keyPadMode;
    CursorKeyMode cursorKeyMode;
    ScrollMode scrollMode;
    boolean newLineMode;
    TerminalPainter terminalPainter;
    int topMargin;
    int bottomMargin;
    int historySize;
    private PushbackInputStream input;
    private Char[][] screenBuffer;
    private LineHeightMode[] lineHeightMode;
    private LineWidthMode[] lineWidthMode;
    private int fontHeight;
    private int fontWidth;
    private int numCols;
    private int numLines;
    private final boolean[] leds = new boolean[4];
    private Cursor cursor;
    private Cursor savedCursor;
    private Color[] systemColors;
    private Color defaultBgColor;
    private Color defaultFgColor;
    private OriginMode originMode;
    private final CharSet[] charSetG = new CharSet[4];
    private boolean reverseScreenMode;
    private String windowTitle;
    private final SortedSet<Integer> tabulatorPositons = new TreeSet<Integer>();
    private List<ITerminalListener> terminalListeners;
    private boolean wraparound;
    private boolean reverseWraparound;
    private boolean running;
    private Clipboard clipboard = new Clipboard(this.getDisplay());
    private List<ISelectionChangedListener> selectionListeners;
    private TerminalSelection terminalSelection;

    public Terminal(Composite parent, int style, Color initFgColor, Color initBgColor, int historySize) {
        super(parent, style | 0x40000 | 0x200);
        this.historySize = historySize;
        this.initMenu();
        this.initSystemColorTable();
        if (initBgColor != null) {
            this.defaultBgColor = initBgColor;
        }
        if (initFgColor != null) {
            this.defaultFgColor = initFgColor;
        }
        this.cursor = new Cursor(this.defaultFgColor, this.defaultBgColor);
        this.savedCursor = new Cursor(this.defaultFgColor, this.defaultBgColor);
        this.screenBuffer = new Char[0][];
        this.terminalListeners = new LinkedList<ITerminalListener>();
        this.selectionListeners = new LinkedList<ISelectionChangedListener>();
        this.changeScreenSize();
        this.terminalPainter = new TerminalPainter(this);
        this.terminalSelection = new TerminalSelection(this);
        this.addMouseListener(this.terminalSelection);
        this.addMouseMoveListener(this.terminalSelection);
        this.addPaintListener(this.terminalPainter);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Terminal.this.changeScreenSize();
            }
        });
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){
            int prevValue = -1;

            public void widgetSelected(SelectionEvent event) {
                if (this.prevValue != Terminal.this.getVerticalBar().getSelection()) {
                    this.prevValue = Terminal.this.getVerticalBar().getSelection();
                    Terminal.this.triggerRedraw();
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button == 2) {
                    Terminal.this.paste();
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                byte[][] arrowUp = new byte[][]{{27, 91, 65}, {27, 79, 65}};
                byte[][] arrowDown = new byte[][]{{27, 91, 66}, {27, 79, 66}};
                byte[][] arrowRight = new byte[][]{{27, 91, 67}, {27, 79, 67}};
                byte[][] arrowLeft = new byte[][]{{27, 91, 68}, {27, 79, 68}};
                byte[] backspace = new byte[]{127};
                byte[] home = new byte[]{27, 91, 72};
                byte[] end = new byte[]{27, 91, 70};
                byte[] insert = new byte[]{27, 91, 50, 126};
                byte[] delete = new byte[]{27, 91, 51, 126};
                byte[] pageUp = new byte[]{27, 91, 53, 126};
                byte[] pageDown = new byte[]{27, 91, 54, 126};
                byte[] F1 = new byte[]{27, 79, 80};
                byte[] F2 = new byte[]{27, 79, 81};
                byte[] F3 = new byte[]{27, 79, 82};
                byte[] F4 = new byte[]{27, 79, 83};
                byte[] F5 = new byte[]{27, 91, 49, 53, 126};
                byte[] F6 = new byte[]{27, 91, 49, 55, 126};
                byte[] F7 = new byte[]{27, 91, 49, 56, 126};
                byte[] F8 = new byte[]{27, 91, 49, 57, 126};
                byte[] F9 = new byte[]{27, 91, 50, 48, 126};
                byte[] F10 = new byte[]{27, 91, 50, 49, 126};
                byte[] F11 = new byte[]{27, 91, 50, 51, 126};
                byte[] F12 = new byte[]{27, 91, 50, 52, 126};
                byte[] F13 = new byte[]{27, 91, 50, 53, 126};
                byte[] F14 = new byte[]{27, 91, 50, 54, 126};
                byte[] F15 = new byte[]{27, 91, 50, 56, 126};
                int[] unhandledKeycodes = new int[]{65536, 131072, 262144, 16777298, 16777299, 16777300, 0x1000055};
                try {
                    OutputStream out = Terminal.this.output;
                    if (out != null) {
                        if (event.keyCode == 0x1000001) {
                            out.write(arrowUp[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000002) {
                            out.write(arrowDown[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000004) {
                            out.write(arrowRight[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000003) {
                            out.write(arrowLeft[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000007) {
                            out.write(home);
                        } else if (event.keyCode == 0x1000008) {
                            out.write(end);
                        } else if (event.keyCode == 0x1000009) {
                            out.write(insert);
                        } else if (event.character == '\u007f') {
                            out.write(delete);
                        } else if (event.character == '\b') {
                            out.write(backspace);
                        } else if (event.keyCode == 0x1000005) {
                            if ((event.stateMask & 0x20000) != 0) {
                                Terminal.this.scrollHistoryPageUp();
                            } else {
                                out.write(pageUp);
                            }
                        } else if (event.keyCode == 0x1000006) {
                            if ((event.stateMask & 0x20000) != 0) {
                                Terminal.this.scrollHistoryPageDown();
                            } else {
                                out.write(pageDown);
                            }
                        } else if (event.keyCode == 0x100000A) {
                            out.write(F1);
                        } else if (event.keyCode == 0x100000B) {
                            out.write(F2);
                        } else if (event.keyCode == 0x100000C) {
                            out.write(F3);
                        } else if (event.keyCode == 0x100000D) {
                            out.write(F4);
                        } else if (event.keyCode == 0x100000E) {
                            out.write(F5);
                        } else if (event.keyCode == 0x100000F) {
                            out.write(F6);
                        } else if (event.keyCode == 0x1000010) {
                            out.write(F7);
                        } else if (event.keyCode == 0x1000011) {
                            out.write(F8);
                        } else if (event.keyCode == 0x1000012) {
                            out.write(F9);
                        } else if (event.keyCode == 0x1000013) {
                            out.write(F10);
                        } else if (event.keyCode == 0x1000014) {
                            out.write(F11);
                        } else if (event.keyCode == 0x1000015) {
                            out.write(F12);
                        } else if (event.keyCode == 0x1000016) {
                            out.write(F13);
                        } else if (event.keyCode == 0x1000017) {
                            out.write(F14);
                        } else if (event.keyCode == 0x1000018) {
                            out.write(F15);
                        } else if (event.character == '\r') {
                            out.write(13);
                            if (Terminal.this.newLineMode) {
                                out.write(10);
                            }
                        } else if (event.character != '\u0000') {
                            out.write(event.character);
                        } else if (Arrays.binarySearch(unhandledKeycodes, event.keyCode) < 0) {
                            Activator.logMessage(2, Messages.formatMessage("Terminal.unhandledKeycode", event.keyCode, event.character));
                        }
                        out.flush();
                    }
                }
                catch (IOException ioException) {
                    Activator.logException(ioException);
                }
            }
        });
        this.reset();
    }

    void scrollHistoryPageUp() {
        int oldPos = this.getScrollbarPosLine();
        int newPos = oldPos - this.numLines;
        if (newPos < 0) {
            newPos = 0;
        }
        if (newPos != oldPos) {
            this.getVerticalBar().setSelection(newPos);
            this.triggerRedraw();
        }
    }

    void scrollHistoryPageDown() {
        int oldPos = this.getScrollbarPosLine();
        int newPos = oldPos + this.numLines;
        if (newPos > this.historySize) {
            newPos = this.historySize;
        }
        if (newPos != oldPos) {
            this.getVerticalBar().setSelection(newPos);
            this.triggerRedraw();
        }
    }

    private void initMenu() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Menu popUpMenu = new Menu((Decorations)this.getShell(), 8);
        final MenuItem copyItem = new MenuItem(popUpMenu, 8);
        copyItem.setText(Messages.getString("Terminal.copy"));
        ImageDescriptor copyImage = sharedImages.getImageDescriptor("IMG_TOOL_COPY");
        copyItem.setImage(copyImage.createImage());
        copyItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Terminal.this.copy();
            }
        });
        MenuItem pasteItem = new MenuItem(popUpMenu, 8);
        pasteItem.setText(Messages.getString("Terminal.paste"));
        ImageDescriptor pasteImage = sharedImages.getImageDescriptor("IMG_TOOL_PASTE");
        pasteItem.setImage(pasteImage.createImage());
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Terminal.this.paste();
            }
        });
        popUpMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                copyItem.setEnabled(!Terminal.this.getSelection().isEmpty());
            }
        });
        this.setMenu(popUpMenu);
    }

    void copy() {
        String text = ((ITextSelection)this.getSelection()).getText();
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        this.clipboard.setContents((Object[])new String[]{text}, new Transfer[]{plainTextTransfer});
    }

    private Object getClipboardContent(int clipboardType) {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents((Transfer)plainTextTransfer, clipboardType);
    }

    public void paste() {
        this.checkWidget();
        String text = (String)this.getClipboardContent(1);
        if (text != null && text.length() > 0) {
            int i = 0;
            while (i < text.length()) {
                Event event = new Event();
                event.character = text.charAt(i);
                this.notifyListeners(1, event);
                ++i;
            }
        }
    }

    public void addTerminalListener(ITerminalListener termListener) {
        this.terminalListeners.add(termListener);
    }

    public void removeTerminalListener(ITerminalListener termListener) {
        this.terminalListeners.remove(termListener);
    }

    private void bell() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Terminal.this.getDisplay().beep();
            }
        });
    }

    private void carriageReturn() {
        if (this.cursor.col != 0) {
            int oldCol = this.cursor.col;
            this.cursor.col = 0;
            this.triggerRedraw(oldCol, this.cursor.line, 1, 1);
            this.triggerRedraw(0, this.cursor.line, 1, 1);
        }
    }

    private void backspace() {
        if (this.cursor.col > 0) {
            --this.cursor.col;
            this.triggerRedraw(this.cursor.col + 1, this.cursor.line, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        }
    }

    private void startReaderThread() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Terminal.this.readerMainLoop();
            }
        }, "Terminal");
        thread.start();
    }

    void readerMainLoop() {
        try {
            this.running = true;
            while (this.running) {
                int ch = this.read();
                if (ch == 7) {
                    this.bell();
                    continue;
                }
                if (ch == 13) {
                    this.carriageReturn();
                    continue;
                }
                if (ch == 10) {
                    this.nextLine(false);
                    continue;
                }
                if (ch == 15) {
                    this.cursor.charSet = this.charSetG[0];
                    continue;
                }
                if (ch == 14) {
                    this.cursor.charSet = this.charSetG[1];
                    continue;
                }
                if (ch == 9) {
                    this.tabulator();
                    continue;
                }
                if (ch == 12) {
                    this.eraseScreen();
                    continue;
                }
                if (ch == 8) {
                    this.backspace();
                    continue;
                }
                if (ch == 27) {
                    this.parseEscSequence();
                    continue;
                }
                if (ch == -1) continue;
                if (ch < 32) {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unhandledCtrlChar", Character.valueOf((char)ch), ch));
                    continue;
                }
                this.input.unread(ch);
                this.readText();
            }
        }
        catch (IOException ioException) {
            Activator.logException(ioException);
        }
        for (ITerminalListener listener : this.terminalListeners) {
            listener.terminated();
        }
    }

    private void tabulator() {
        int oldCol = this.cursor.col;
        Integer cursorCol = this.cursor.col + 1;
        Object[] tabArray = this.tabulatorPositons.toArray(new Integer[this.tabulatorPositons.size()]);
        int pos = Arrays.binarySearch(tabArray, cursorCol);
        if (pos < 0) {
            pos = -pos - 1;
        }
        if (tabArray.length > pos) {
            int nextTabStop = (Integer)tabArray[pos];
            if (nextTabStop < this.numColsInLine(this.cursor.line)) {
                this.cursor.col = nextTabStop;
            } else {
                Activator.logMessage(2, Messages.getString("Terminal.tabStopOutsideDisplay"));
            }
        } else {
            this.cursor.col = (this.cursor.col + 8 + 1) / 8 * 8;
            if (this.cursor.col >= this.numColsInLine(this.cursor.line)) {
                this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
            }
        }
        this.triggerRedraw(oldCol, this.cursor.line, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void readText() throws IOException {
        int ch = this.read();
        int line = this.cursor.line;
        int startCol = this.cursor.col;
        int colsToUpdate = 0;
        while (ch >= 32) {
            if (this.cursor.col >= this.numColsInLine(this.cursor.line)) {
                if (this.wraparound) {
                    this.cursor.col = 0;
                    this.triggerRedraw(startCol, line, colsToUpdate, 1);
                    startCol = 0;
                    colsToUpdate = 0;
                    if (this.cursor.line < this.numLines - 1) {
                        line = ++this.cursor.line;
                    } else {
                        this.scrollUp();
                    }
                } else {
                    this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
                }
            }
            Char scrCh = this.screenBuffer[this.cursor.line + this.historySize][this.cursor.col];
            scrCh.ch = (char)ch;
            scrCh.setToCursorFormat(this.cursor);
            ++this.cursor.col;
            if (this.input.available() == 0 && ++colsToUpdate != 0) {
                this.triggerRedraw(startCol, line, colsToUpdate, 1);
                this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
                startCol += colsToUpdate;
                colsToUpdate = 0;
            }
            ch = this.read();
        }
        this.triggerRedraw(startCol, line, colsToUpdate, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        this.input.unread(ch);
    }

    private int numColsInLine(int line) {
        int numColsInLine = this.numCols;
        if (this.lineWidthMode[line] == LineWidthMode.DOUBLE) {
            numColsInLine /= 2;
        }
        return numColsInLine;
    }

    void triggerRedraw(final int col, final int line, final int cols, final int lines) {
        int fontWidthMult = 1;
        int i = line;
        while (i < line + lines && i + this.historySize < this.lineWidthMode.length) {
            if (this.lineWidthMode[i + this.historySize] == LineWidthMode.DOUBLE) {
                fontWidthMult = 2;
                break;
            }
            ++i;
        }
        final int finalFontWidthMult = fontWidthMult;
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                if (!Terminal.this.isDisposed()) {
                    Terminal.this.redraw(col * Terminal.this.getFontWidth() * finalFontWidthMult, (line + Terminal.this.historySize - Terminal.this.getScrollbarPosLine()) * Terminal.this.getFontHeigth(), cols * Terminal.this.getFontWidth() * finalFontWidthMult, lines * Terminal.this.getFontHeigth(), false);
                }
            }
        });
    }

    void triggerRedraw() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Terminal.this.redraw();
            }
        });
    }

    private void parseEscSequence() throws IOException {
        int ch = this.read();
        LinkedList<Integer> params = new LinkedList<Integer>();
        switch (ch) {
            case 91: {
                do {
                    params.add(this.readNumber());
                } while ((ch = this.read()) == 59);
                this.executeControlSequence(Terminal.listToArray(params), ch);
                break;
            }
            case 93: {
                this.executeOperatingSystemCommand();
                break;
            }
            case 35: {
                this.executeDecCommand();
                break;
            }
            case 40: {
                this.selectCharacterSet(0);
                break;
            }
            case 41: {
                this.selectCharacterSet(1);
                break;
            }
            case 42: {
                this.selectCharacterSet(2);
                break;
            }
            case 43: {
                this.selectCharacterSet(3);
                break;
            }
            case 90: {
                this.deviceAttributes(new int[0]);
                break;
            }
            case 61: {
                this.keyPadMode = KeyPadMode.APPLICATION;
                break;
            }
            case 62: {
                this.keyPadMode = KeyPadMode.NUMERIC;
                break;
            }
            case 55: {
                this.saveCursor();
                break;
            }
            case 56: {
                this.restoreCursor();
                break;
            }
            case 72: {
                this.horizontalTabulationSet();
                break;
            }
            case 68: {
                this.index();
                break;
            }
            case 69: {
                this.nextLine(true);
                break;
            }
            case 77: {
                this.reverseIndex();
                break;
            }
            case 99: {
                this.reset();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEscSeq", Character.valueOf((char)ch)));
            }
        }
    }

    private void horizontalTabulationSet() {
        Integer cursorCol = this.cursor.col;
        if (!this.tabulatorPositons.contains(cursorCol)) {
            this.tabulatorPositons.add(cursorCol);
        }
    }

    private void selectCharacterSet(int charSetNr) throws IOException {
        int ch = this.read();
        CharSet charSet = CharSet.USASCII;
        switch (ch) {
            case 65: {
                Activator.logMessage(2, Messages.getString("Terminal.ukCharSetNotSupported"));
                break;
            }
            case 66: {
                charSet = CharSet.USASCII;
                break;
            }
            case 48: {
                charSet = CharSet.SPECIAL;
                break;
            }
            case 49: {
                Activator.logMessage(2, Messages.getString("Terminal.alternateStdCharSetNotSupported"));
                break;
            }
            case 50: {
                Activator.logMessage(2, Messages.getString("Terminal.alternateSpecialCharSetNotSupported"));
                break;
            }
            default: {
                Activator.logMessage(2, Messages.getString("Terminal.unknownCharSet"));
            }
        }
        this.charSetG[charSetNr] = charSet;
    }

    private void nextLine(boolean returnToColZero) {
        int oldCol = this.cursor.col;
        if (returnToColZero) {
            this.cursor.col = 0;
        }
        this.triggerRedraw(oldCol, this.cursor.line, 1, 1);
        this.index();
    }

    private void index() {
        if (this.cursor.line < this.bottomMargin) {
            int oldLine = this.cursor.line++;
            this.triggerRedraw(this.cursor.col, oldLine, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        } else {
            this.scrollUp();
        }
    }

    private void reverseIndex() {
        if (this.cursor.line > this.topMargin) {
            int oldLine = this.cursor.line--;
            this.triggerRedraw(this.cursor.col, oldLine, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        } else {
            this.scrollDown();
        }
    }

    private void saveCursor() {
        this.savedCursor = new Cursor(this.cursor);
    }

    private void restoreCursor() {
        int oldCol = this.cursor.col;
        int oldLine = this.cursor.line;
        this.cursor = this.savedCursor;
        this.triggerRedraw(oldCol, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private static int[] listToArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    private void executeDecCommand() throws IOException {
        int ch = this.read();
        switch (ch) {
            case 51: {
                this.doubleHeightLine(LineHeightMode.DOUBLE_TOP);
                break;
            }
            case 52: {
                this.doubleHeightLine(LineHeightMode.DOUBLE_BOTTOM);
                break;
            }
            case 53: {
                this.doubleWidthLine(LineWidthMode.NORMAL);
                break;
            }
            case 54: {
                this.doubleWidthLine(LineWidthMode.DOUBLE);
                break;
            }
            case 56: {
                this.screenAlignmentDisplay();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownDecCommand", Character.valueOf((char)ch)));
            }
        }
    }

    private void doubleWidthLine(LineWidthMode mode) {
        this.lineHeightMode[this.cursor.line + this.historySize] = LineHeightMode.NORMAL;
        this.lineWidthMode[this.cursor.line + this.historySize] = mode;
        if (mode == LineWidthMode.DOUBLE && this.cursor.col > this.numCols / 2) {
            this.cursor.col = this.numCols / 2;
        }
        this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
    }

    private void doubleHeightLine(LineHeightMode mode) {
        if (mode == LineHeightMode.DOUBLE_TOP || mode == LineHeightMode.DOUBLE_BOTTOM) {
            this.lineWidthMode[this.cursor.line + this.historySize] = LineWidthMode.DOUBLE;
        }
        this.lineHeightMode[this.cursor.line + this.historySize] = mode;
        this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
    }

    private void screenAlignmentDisplay() {
        int i = this.historySize;
        while (i < this.numLines + this.historySize) {
            this.lineHeightMode[i] = LineHeightMode.NORMAL;
            this.lineWidthMode[i] = LineWidthMode.NORMAL;
            ++i;
        }
        i = this.historySize;
        while (i < this.numLines + this.historySize) {
            Char[] charArray = this.screenBuffer[i];
            int n = charArray.length;
            int n2 = 0;
            while (n2 < n) {
                Char character = charArray[n2];
                character.ch = (char)69;
                ++n2;
            }
            ++i;
        }
        this.triggerRedraw();
    }

    private void executeOperatingSystemCommand() throws IOException {
        int commandNr = this.readNumber();
        if (this.read() != 59) {
            Activator.logMessage(2, Messages.getString("Terminal.invalidOsCommand"));
        } else {
            switch (commandNr) {
                case 0: {
                    this.windowTitle = this.readString();
                    for (ITerminalListener listener : this.terminalListeners) {
                        listener.windowTitleChanged(this.windowTitle);
                    }
                    break;
                }
                case 4: {
                    Color color;
                    int colorNr = this.readNumber();
                    if (this.read() != 59) {
                        Activator.logMessage(2, Messages.getString("Terminal.invalidOsCommand"));
                        break;
                    }
                    this.systemColors[colorNr] = color = this.parseColorString(this.readString());
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownOsCommand", commandNr));
                }
            }
        }
    }

    private Color parseColorString(String colorString) {
        StringTokenizer tokenizer;
        Color color = null;
        if (colorString.startsWith("rgb:") && (tokenizer = new StringTokenizer(colorString.substring(4), "/")).countTokens() == 3) {
            int r = Integer.parseInt(tokenizer.nextToken(), 16);
            int g = Integer.parseInt(tokenizer.nextToken(), 16);
            int b = Integer.parseInt(tokenizer.nextToken(), 16);
            color = new Color((Device)this.getDisplay(), r, g, b);
        }
        if (color == null) {
            color = this.defaultFgColor;
            Activator.logMessage(2, Messages.getString("Terminal.unknownColorString"));
        }
        return color;
    }

    private String readString() throws IOException {
        char[] terminatingChars = new char[]{'\u0007', '\u001b'};
        StringBuilder buffer = new StringBuilder();
        char ch = (char)this.read();
        while (Arrays.binarySearch(terminatingChars, ch) < 0) {
            buffer.append(ch);
            ch = (char)this.read();
        }
        if (ch == '\u001b' && this.read() != 92) {
            Activator.logMessage(2, Messages.getString("Terminal.stringTerminatorExpected"));
        }
        return buffer.toString();
    }

    private void executeControlSequence(int[] params, int command) throws IOException {
        switch (command) {
            case 68: {
                this.cursorBackward(params);
                break;
            }
            case 66: {
                this.cursorDown(params);
                break;
            }
            case 67: {
                this.cursorForward(params);
                break;
            }
            case 72: 
            case 102: {
                this.cursorPosition(params);
                break;
            }
            case 65: {
                this.cursorUp(params);
                break;
            }
            case 99: {
                this.deviceAttributes(params);
                break;
            }
            case 113: {
                this.loadLeds(params);
                break;
            }
            case 120: {
                this.requestTerminalParameters(params);
                break;
            }
            case 114: {
                this.setTopAndBottomMargins(params, false);
                break;
            }
            case 121: {
                Activator.logMessage(2, Messages.getString("Terminal.invokeConfidenceTestNotImplemented"));
                break;
            }
            case 110: {
                this.deviceStatusReport(params);
                break;
            }
            case 74: {
                this.eraseInDisplay(params);
                break;
            }
            case 75: {
                this.eraseInLine(params);
                break;
            }
            case 108: {
                this.resetMode(params);
                break;
            }
            case 109: {
                this.selectGraphicRendition(params);
                break;
            }
            case 104: {
                this.setMode(params);
                break;
            }
            case 103: {
                this.tabulationClear(params);
                break;
            }
            case 100: {
                this.verticalLinePositionAbsolute(params);
                break;
            }
            case 88: {
                this.eraseCharacter(params);
                break;
            }
            case 80: {
                this.deleteCharacter(params);
                break;
            }
            case 71: {
                this.cursorHorizontalAbsolute(params);
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownCtrlSeq", Character.valueOf((char)command)));
            }
        }
    }

    private void deviceStatusReport(int[] params) throws IOException {
        byte[] response = new byte[]{27, 91, 48, 110};
        int val = 0;
        if (params.length != 0) {
            val = params[0];
        }
        switch (val) {
            case 5: {
                this.output.write(response);
                this.output.flush();
                break;
            }
            case 6: {
                this.reportCursorPosition();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.getString("Terminal.invalidDeviceStatusReportParam"));
            }
        }
    }

    private void reportCursorPosition() throws IOException {
        this.output.write(27);
        this.output.write(91);
        this.output.write(Integer.toString(this.cursor.line + 1).getBytes("ASCII"));
        this.output.write(59);
        this.output.write(Integer.toString(this.cursor.col + 1).getBytes("ASCII"));
        this.output.write(82);
        this.output.flush();
    }

    private void requestTerminalParameters(int[] params) throws IOException {
        byte[] response = new byte[]{27, 91, 50, 59, 49, 59, 49, 59, 49, 50, 56, 59, 49, 50, 56, 59, 49, 59, 48, 120};
        if (params.length > 0 && params[0] != 0 && params[0] != 1) {
            Activator.logMessage(2, Messages.getString("Terminal.unknownTermParamReq"));
        } else {
            if (params[0] == 1) {
                response[2] = 51;
            }
            this.output.write(response);
            this.output.flush();
        }
    }

    private void eraseCharacter(int[] params) {
        int val = 1;
        int colsInLine = this.numColsInLine(this.cursor.line);
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        int i = this.cursor.col;
        while (i < this.cursor.col + val && i < colsInLine) {
            this.screenBuffer[this.cursor.line + this.historySize][i].erase(this.defaultFgColor, this.defaultBgColor);
            this.screenBuffer[this.cursor.line + this.historySize][i].bgColor = this.cursor.bgColor;
            ++i;
        }
        this.triggerRedraw(this.cursor.col, this.cursor.line, val, 1);
    }

    private void deleteCharacter(int[] params) {
        int val = 1;
        int colsInLine = this.numColsInLine(this.cursor.line);
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        if (val > colsInLine - this.cursor.col) {
            val = colsInLine - this.cursor.col;
        }
        int colsToMove = colsInLine - this.cursor.col - val;
        int i = this.cursor.col;
        while (i < this.cursor.col + colsToMove) {
            this.screenBuffer[this.cursor.line + this.historySize][i] = this.screenBuffer[this.cursor.line + this.historySize][i + val];
            ++i;
        }
        i = this.cursor.col + colsToMove;
        while (i < colsInLine) {
            this.screenBuffer[this.cursor.line + this.historySize][i] = new Char(this.defaultFgColor, this.defaultBgColor);
            ++i;
        }
        this.triggerRedraw(this.cursor.col, this.cursor.line, colsInLine - this.cursor.col, 1);
    }

    private void setMode(int[] params) {
        int[] nArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            int param = nArray[n2];
            switch (param) {
                case 1: {
                    this.cursorKeyMode = CursorKeyMode.APPLICATION;
                    break;
                }
                case 3: {
                    this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
                    this.tabulatorPositons.clear();
                    this.eraseScreen();
                    this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            Terminal.this.setSize(132 * Terminal.this.getFontWidth() + Terminal.this.getVerticalBar().getSize().x, 24 * Terminal.this.getFontHeigth());
                        }
                    });
                    break;
                }
                case 4: {
                    this.scrollMode = ScrollMode.SMOOTH;
                    break;
                }
                case 5: {
                    this.reverseScreenMode = true;
                    this.triggerRedraw();
                    break;
                }
                case 6: {
                    this.setOriginMode(OriginMode.RELATIVE);
                    break;
                }
                case 7: {
                    this.wraparound = true;
                    break;
                }
                case 8: {
                    Activator.logMessage(2, Messages.getString("Terminal.autoRepeatOnNotSupported"));
                    break;
                }
                case 9: {
                    Activator.logMessage(2, Messages.getString("Terminal.interlaceOnNotSupported"));
                    break;
                }
                case 20: {
                    this.newLineMode = true;
                    break;
                }
                case 45: {
                    this.reverseWraparound = true;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownSetModeParam", param));
                }
            }
            ++n2;
        }
    }

    private void resetMode(int[] params) {
        int[] nArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            int param = nArray[n2];
            switch (param) {
                case 1: {
                    this.cursorKeyMode = CursorKeyMode.CURSOR;
                    break;
                }
                case 2: {
                    Activator.logMessage(2, Messages.getString("Terminal.vt52ModeNotSupported"));
                    break;
                }
                case 3: {
                    this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            Terminal.this.setSize(80 * Terminal.this.getFontWidth() + Terminal.this.getVerticalBar().getSize().x, 24 * Terminal.this.getFontHeigth());
                        }
                    });
                    this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
                    this.tabulatorPositons.clear();
                    this.eraseScreen();
                    break;
                }
                case 4: {
                    this.scrollMode = ScrollMode.JUMP;
                    break;
                }
                case 5: {
                    this.reverseScreenMode = false;
                    this.triggerRedraw();
                    break;
                }
                case 6: {
                    this.setOriginMode(OriginMode.ABSOLUTE);
                    break;
                }
                case 7: {
                    this.wraparound = false;
                    break;
                }
                case 8: {
                    Activator.logMessage(2, Messages.getString("Terminal.autoRepeatOffNotSupported"));
                    break;
                }
                case 9: {
                    Activator.logMessage(2, Messages.getString("Terminal.interlaceOffNotSupported"));
                    break;
                }
                case 20: {
                    this.newLineMode = false;
                    break;
                }
                case 45: {
                    this.reverseWraparound = false;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownResetModeParam", param));
                }
            }
            ++n2;
        }
    }

    private void tabulationClear(int[] params) {
        Integer cursorCol = this.cursor.col;
        int val = 0;
        if (params.length > 0) {
            val = params[0];
        }
        switch (val) {
            case 0: {
                this.tabulatorPositons.remove(cursorCol);
                break;
            }
            case 3: {
                this.tabulatorPositons.clear();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownTabClearParam", val));
            }
        }
    }

    private void reset() {
        this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
        this.tabulatorPositons.clear();
        this.wraparound = true;
        this.reverseWraparound = false;
        this.reverseScreenMode = false;
        this.newLineMode = false;
        this.keyPadMode = KeyPadMode.NUMERIC;
        int i = 0;
        while (i < this.charSetG.length) {
            this.charSetG[i] = CharSet.USASCII;
            ++i;
        }
        this.topMargin = 0;
        this.bottomMargin = this.numLines - 1;
        i = 0;
        while (i < this.leds.length) {
            this.leds[i] = false;
            ++i;
        }
        this.setOriginMode(OriginMode.ABSOLUTE);
        this.eraseScreen();
    }

    private void setOriginMode(OriginMode mode) {
        int oldLine = this.cursor.line;
        int oldCol = this.cursor.col;
        if (mode == OriginMode.ABSOLUTE) {
            this.cursor.col = 0;
            this.cursor.line = 0;
        } else {
            this.cursor.col = 0;
            this.cursor.line = this.topMargin;
        }
        this.originMode = mode;
        this.triggerRedraw(oldCol, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    void scrollUpCopy() {
        Char[] tmp = this.topMargin == 0 ? this.scrollHistory() : this.screenBuffer[this.topMargin + this.historySize];
        int i = this.topMargin;
        while (i < this.bottomMargin) {
            this.lineHeightMode[i + this.historySize] = this.lineHeightMode[i + this.historySize + 1];
            this.lineWidthMode[i + this.historySize] = this.lineWidthMode[i + this.historySize + 1];
            this.screenBuffer[i + this.historySize] = this.screenBuffer[i + this.historySize + 1];
            ++i;
        }
        this.screenBuffer[this.bottomMargin + this.historySize] = tmp;
        this.eraseLine(this.bottomMargin);
        this.lineWidthMode[this.bottomMargin + this.historySize] = LineWidthMode.NORMAL;
        this.lineHeightMode[this.bottomMargin + this.historySize] = LineHeightMode.NORMAL;
    }

    private void scrollUp() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Terminal.this.scrollUpCopy();
                Terminal.this.terminalPainter.scrollUp(Terminal.this.topMargin, Terminal.this.bottomMargin);
            }
        });
        this.triggerRedraw(0, this.bottomMargin, this.numCols, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line - 1, 1, 1);
    }

    private Char[] scrollHistory() {
        Char[] tmp = this.screenBuffer[0];
        int i = 0;
        while (i < this.historySize) {
            this.lineHeightMode[i] = this.lineHeightMode[i + 1];
            this.lineWidthMode[i] = this.lineWidthMode[i + 1];
            this.screenBuffer[i] = this.screenBuffer[i + 1];
            ++i;
        }
        return tmp;
    }

    void scrollDownCopy() {
        Char[] tmp = this.screenBuffer[this.bottomMargin + this.historySize];
        int i = this.bottomMargin;
        while (i > this.topMargin) {
            this.lineHeightMode[i + this.historySize] = this.lineHeightMode[i + this.historySize - 1];
            this.lineWidthMode[i + this.historySize] = this.lineWidthMode[i + this.historySize - 1];
            this.screenBuffer[i + this.historySize] = this.screenBuffer[i + this.historySize - 1];
            --i;
        }
        this.screenBuffer[this.topMargin + this.historySize] = tmp;
        this.eraseLine(this.topMargin);
        this.lineWidthMode[this.topMargin + this.historySize] = LineWidthMode.NORMAL;
        this.lineHeightMode[this.topMargin + this.historySize] = LineHeightMode.NORMAL;
    }

    private void scrollDown() {
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                Terminal.this.scrollDownCopy();
                Terminal.this.terminalPainter.scrollDown(Terminal.this.topMargin, Terminal.this.bottomMargin);
            }
        });
        this.triggerRedraw(0, this.topMargin, this.numCols, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line + 1, 1, 1);
    }

    private void setTopAndBottomMargins(int[] params, boolean skipCursorReset) {
        int top = 0;
        int bottom = this.numLines;
        if (params.length > 0) {
            top = params[0];
        }
        if (params.length > 1) {
            bottom = params[1];
        }
        if (top > 0) {
            --top;
        }
        if (bottom > 0) {
            --bottom;
        }
        if (top >= bottom) {
            Activator.logMessage(2, Messages.getString("Terminal.topLargerEqualBottom"));
        } else if (bottom >= this.numLines) {
            Activator.logMessage(2, Messages.formatMessage("Terminal.bottomOutOfScreen", bottom, this.numLines));
        } else {
            this.topMargin = top;
            this.bottomMargin = bottom;
            if (!skipCursorReset) {
                this.cursorPosition(new int[0]);
            }
        }
    }

    private void selectGraphicRendition(int[] params) {
        int val = 0;
        int idx = 0;
        do {
            if (params.length > idx) {
                val = params[idx];
            }
            if (val >= 30 && val <= 37) {
                if (this.cursor.bold) {
                    this.cursor.fgColor = this.systemColors[val - 30 + 8];
                    continue;
                }
                this.cursor.fgColor = this.systemColors[val - 30];
                continue;
            }
            if (val >= 40 && val <= 47) {
                this.cursor.bgColor = this.systemColors[val - 40];
                continue;
            }
            switch (val) {
                case 0: {
                    this.cursor.bold = false;
                    this.cursor.underscore = false;
                    this.cursor.blink = false;
                    this.cursor.negative = false;
                    this.cursor.italics = false;
                    this.cursor.strikethrough = false;
                    this.cursor.fgColor = this.defaultFgColor;
                    this.cursor.bgColor = this.defaultBgColor;
                    break;
                }
                case 1: {
                    this.cursor.bold = true;
                    break;
                }
                case 4: {
                    this.cursor.underscore = true;
                    break;
                }
                case 5: {
                    this.cursor.blink = true;
                    break;
                }
                case 7: {
                    this.cursor.negative = true;
                    break;
                }
                case 3: {
                    this.cursor.italics = true;
                    break;
                }
                case 9: {
                    this.cursor.strikethrough = true;
                    break;
                }
                case 22: {
                    this.cursor.bold = false;
                    break;
                }
                case 23: {
                    this.cursor.italics = false;
                    break;
                }
                case 24: {
                    this.cursor.underscore = false;
                    break;
                }
                case 27: {
                    this.cursor.negative = false;
                    break;
                }
                case 29: {
                    this.cursor.strikethrough = false;
                    break;
                }
                case 38: {
                    if (params.length >= idx + 3 && params[idx + 1] == 5 && params[idx + 2] < 256) {
                        this.cursor.fgColor = this.systemColors[params[idx + 2]];
                        idx += 2;
                        break;
                    }
                    Activator.logMessage(2, Messages.getString("Terminal.invalidColorParams"));
                    break;
                }
                case 39: {
                    this.cursor.fgColor = this.defaultFgColor;
                    break;
                }
                case 48: {
                    if (params.length >= idx + 3 && params[idx + 1] == 5 && params[idx + 2] < 256) {
                        this.cursor.bgColor = this.systemColors[params[idx + 2]];
                        idx += 2;
                        break;
                    }
                    Activator.logMessage(2, Messages.getString("Terminal.invalidColorParams"));
                    break;
                }
                case 49: {
                    this.cursor.bgColor = this.defaultBgColor;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownGraphRendParam", val));
                }
            }
        } while (++idx < params.length);
    }

    private void eraseScreen() {
        int[] eraseScreen = new int[]{2};
        this.eraseInDisplay(eraseScreen);
        this.resetLineModes();
    }

    private void resetLineModes() {
        int i = 0;
        while (i < this.lineHeightMode.length) {
            this.lineHeightMode[i] = LineHeightMode.NORMAL;
            this.lineWidthMode[i] = LineWidthMode.NORMAL;
            ++i;
        }
    }

    private void eraseInDisplay(int[] params) {
        int val = 0;
        if (params.length > 0) {
            val = params[0];
        }
        switch (val) {
            case 0: {
                this.eraseInLine(params);
                int i = this.cursor.line + 1;
                while (i < this.numLines) {
                    this.eraseLine(i);
                    ++i;
                }
                this.triggerRedraw(0, this.cursor.line + 1, this.numCols, this.numLines - this.cursor.line - 1);
                break;
            }
            case 1: {
                this.eraseInLine(params);
                int i = 0;
                while (i < this.cursor.line) {
                    this.eraseLine(i);
                    ++i;
                }
                this.triggerRedraw(0, 0, this.numCols, this.cursor.line);
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.numLines) {
                    this.eraseLine(i);
                    ++i;
                }
                this.triggerRedraw();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEraseInDispParam", val));
            }
        }
    }

    private void eraseInLine(int[] params) {
        int val = 0;
        if (params.length > 0) {
            val = params[0];
        }
        switch (val) {
            case 0: {
                int i = this.cursor.col;
                while (i < this.screenBuffer[this.cursor.line + this.historySize].length) {
                    this.screenBuffer[this.cursor.line + this.historySize][i].erase(this.defaultFgColor, this.defaultBgColor);
                    ++i;
                }
                this.triggerRedraw(this.cursor.col, this.cursor.line, this.numCols - this.cursor.col, 1);
                break;
            }
            case 1: {
                int i = 0;
                while (i <= this.cursor.col) {
                    this.screenBuffer[this.cursor.line + this.historySize][i].erase(this.defaultFgColor, this.defaultBgColor);
                    ++i;
                }
                this.triggerRedraw(0, this.cursor.line, this.cursor.col + 1, 1);
                break;
            }
            case 2: {
                this.eraseLine(this.cursor.line);
                this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEraseInLineParam", val));
            }
        }
    }

    private void eraseLine(int lineNr) {
        Char[] charArray = this.screenBuffer[lineNr + this.historySize];
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            Char character = charArray[n2];
            character.erase(this.defaultFgColor, this.defaultBgColor);
            ++n2;
        }
    }

    private void loadLeds(int[] params) {
        int val = 0;
        if (params.length > 0) {
            val = params[0];
        }
        if (val == 0) {
            int i = 0;
            while (i < this.leds.length) {
                this.leds[i] = false;
                ++i;
            }
        } else if (val < this.leds.length) {
            this.leds[val - 1] = true;
        } else {
            Activator.logMessage(2, Messages.formatMessage("Terminal.invalidLoadLedsParam", val));
        }
    }

    private void cursorBackward(int[] params) {
        int val = 1;
        int oldCol = this.cursor.col;
        int oldLine = this.cursor.line;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        if (this.reverseWraparound) {
            while (this.cursor.col - val < 0) {
                if (this.cursor.line != 0) {
                    val -= this.cursor.col + 1;
                    --this.cursor.line;
                    this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
                    continue;
                }
                this.cursor.col = 0;
                val = 0;
                break;
            }
            this.cursor.col -= val;
        } else {
            this.cursor.col = this.cursor.col - val < 0 ? 0 : (this.cursor.col -= val);
        }
        this.triggerRedraw(oldCol, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorDown(int[] params) {
        int val = 1;
        int oldLine = this.cursor.line;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        this.cursor.line = this.cursor.line + val >= this.bottomMargin ? this.bottomMargin - 1 : (this.cursor.line += val);
        this.triggerRedraw(this.cursor.col, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorForward(int[] params) {
        int val = 1;
        int oldCol = this.cursor.col;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        this.cursor.col = this.cursor.col + val >= this.numCols ? this.numCols - 1 : (this.cursor.col += val);
        this.triggerRedraw(oldCol, this.cursor.line, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorUp(int[] params) {
        int val = 1;
        int oldLine = this.cursor.line;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        this.cursor.line = this.cursor.line - val < this.topMargin ? this.topMargin : (this.cursor.line -= val);
        this.triggerRedraw(this.cursor.col, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void verticalLinePositionAbsolute(int[] params) {
        int val = 1;
        int oldLine = this.cursor.line;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        if (val >= this.numLines) {
            val = this.numLines - 1;
        }
        this.cursor.line = val;
        this.triggerRedraw(this.cursor.col, oldLine, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorHorizontalAbsolute(int[] params) {
        int val = 1;
        int oldCol = this.cursor.col;
        if (params.length != 0) {
            val = params[0];
        }
        if (val == 0) {
            val = 1;
        }
        if (val >= this.numCols) {
            val = this.numCols - 1;
        }
        this.cursor.col = val;
        this.triggerRedraw(oldCol, this.cursor.col, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorPosition(int[] params) {
        int col = 0;
        int line = 0;
        int lines = this.numLines;
        if (params.length > 0) {
            line = params[0];
        }
        if (params.length > 1) {
            col = params[1];
        }
        if (line > 0) {
            --line;
        }
        if (col > 0) {
            --col;
        }
        if (this.originMode == OriginMode.RELATIVE) {
            line += this.topMargin;
            lines = this.bottomMargin;
        }
        if (line >= lines) {
            line = lines - 1;
            Activator.logMessage(2, Messages.getString("Terminal.cursorPosOutOfRangeLine"));
        }
        if (col >= this.numCols) {
            col = this.numCols - 1;
            Activator.logMessage(2, Messages.getString("Terminal.cursorPosOutOfRangeCol"));
        }
        int oldLine = this.cursor.line;
        int oldCol = this.cursor.col;
        this.cursor.line = line;
        this.cursor.col = col;
        if (oldLine < this.numLines && oldCol < this.numCols) {
            this.triggerRedraw(oldCol, oldLine, 1, 1);
        }
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void deviceAttributes(int[] params) throws IOException {
        byte[] response = new byte[]{27, 91, 63, 49, 59, 50, 99};
        if (params.length > 0 && params[0] != 0) {
            Activator.logMessage(2, Messages.getString("Terminal.unknownDevAttribReq"));
        } else {
            this.output.write(response);
            this.output.flush();
        }
    }

    private int readNumber() throws IOException {
        int ch = this.read();
        int val = 0;
        while (ch >= 48 && ch <= 57 || ch == 63) {
            if (ch != 63) {
                val *= 10;
                val += ch - 48;
            }
            ch = this.read();
        }
        this.input.unread(ch);
        return val;
    }

    private int read() throws IOException {
        int val = this.input.read();
        if (val == -1) {
            this.running = false;
        }
        this.terminalSelection.clearSelection();
        return val;
    }

    private void initSystemColorTable() {
        Display dpy = this.getDisplay();
        this.defaultBgColor = dpy.getSystemColor(2);
        this.defaultFgColor = dpy.getSystemColor(15);
        this.systemColors = new Color[256];
        this.systemColors[0] = dpy.getSystemColor(2);
        this.systemColors[1] = dpy.getSystemColor(4);
        this.systemColors[2] = dpy.getSystemColor(6);
        this.systemColors[3] = dpy.getSystemColor(8);
        this.systemColors[4] = dpy.getSystemColor(10);
        this.systemColors[5] = dpy.getSystemColor(12);
        this.systemColors[6] = dpy.getSystemColor(14);
        this.systemColors[7] = dpy.getSystemColor(15);
        this.systemColors[8] = dpy.getSystemColor(16);
        this.systemColors[9] = dpy.getSystemColor(3);
        this.systemColors[10] = dpy.getSystemColor(5);
        this.systemColors[11] = dpy.getSystemColor(7);
        this.systemColors[12] = dpy.getSystemColor(9);
        this.systemColors[13] = dpy.getSystemColor(11);
        this.systemColors[14] = dpy.getSystemColor(13);
        this.systemColors[15] = dpy.getSystemColor(1);
        int i = 16;
        while (i < 256) {
            this.systemColors[i] = this.defaultBgColor;
            ++i;
        }
    }

    void changeScreenSize() {
        Font font = this.getFont();
        Point widgetSize = this.getSize();
        GC gc = new GC((Drawable)this);
        gc.setFont(font);
        this.fontWidth = gc.getFontMetrics().getAverageCharWidth();
        this.fontHeight = gc.getFontMetrics().getHeight();
        gc.dispose();
        this.numCols = (widgetSize.x - this.getVerticalBar().getSize().x) / this.fontWidth;
        this.numLines = widgetSize.y / this.fontHeight;
        if (this.numCols < 2) {
            this.numCols = 80;
        }
        if (this.numLines < 2) {
            this.numLines = 24;
        }
        Char[][] newScreenBuffer = new Char[this.numLines + this.historySize][];
        LineHeightMode[] newLineHeightMode = new LineHeightMode[this.numLines + this.historySize];
        LineWidthMode[] newLineWidthMode = new LineWidthMode[this.numLines + this.historySize];
        int linesDiff = newScreenBuffer.length - this.screenBuffer.length;
        if (linesDiff < 0 && this.cursor.line + this.historySize >= newScreenBuffer.length) {
            linesDiff = newScreenBuffer.length - (this.cursor.line + this.historySize) - 1;
        } else if (linesDiff < 0) {
            linesDiff = 0;
        }
        int i = 0;
        while (i < newScreenBuffer.length) {
            newScreenBuffer[i] = new Char[this.numCols];
            int oldIndex = i - linesDiff;
            if (oldIndex >= 0 && oldIndex < this.screenBuffer.length) {
                int len = newScreenBuffer[i].length;
                if (this.screenBuffer[oldIndex].length < len) {
                    len = this.screenBuffer[oldIndex].length;
                }
                int j = 0;
                while (j < len) {
                    newScreenBuffer[i][j] = this.screenBuffer[oldIndex][j];
                    ++j;
                }
                newLineHeightMode[i] = this.lineHeightMode[oldIndex];
                newLineWidthMode[i] = this.lineWidthMode[oldIndex];
            }
            int j = 0;
            while (j < newScreenBuffer[i].length) {
                if (newScreenBuffer[i][j] == null) {
                    newScreenBuffer[i][j] = new Char(this.defaultFgColor, this.defaultBgColor);
                }
                ++j;
            }
            if (newLineHeightMode[i] == null) {
                newLineHeightMode[i] = LineHeightMode.NORMAL;
            }
            if (newLineWidthMode[i] == null) {
                newLineWidthMode[i] = LineWidthMode.NORMAL;
            }
            ++i;
        }
        this.screenBuffer = newScreenBuffer;
        this.lineHeightMode = newLineHeightMode;
        this.lineWidthMode = newLineWidthMode;
        this.setTopAndBottomMargins(new int[0], true);
        this.cursor.line += linesDiff;
        if (this.cursor.col >= this.numCols) {
            this.cursor.col = this.numCols - 1;
        }
        if (this.numCols != 0 && this.numLines != 0) {
            for (ITerminalListener listener : this.terminalListeners) {
                listener.windowSizeChanged(this.numCols, this.numLines, this.numCols * this.fontWidth, this.numLines * this.fontHeight);
            }
        }
        this.getVerticalBar().setValues(this.historySize, 0, this.screenBuffer.length, this.numLines, 1, this.numLines);
    }

    public void setInputStream(InputStream in) {
        this.input = new PushbackInputStream(in);
        this.startReaderThread();
    }

    public void setOutputStream(OutputStream out) {
        this.output = out;
    }

    public void setFont(Font font) {
        this.terminalPainter.setFont(font);
        super.setFont(font);
    }

    public Color getForeground() {
        return this.defaultFgColor;
    }

    public Color getBackground() {
        return this.defaultBgColor;
    }

    boolean isInReverseScreenMode() {
        return this.reverseScreenMode;
    }

    int getFontHeigth() {
        return this.fontHeight;
    }

    int getFontWidth() {
        return this.fontWidth;
    }

    Char[][] getScreenBuffer() {
        return this.screenBuffer;
    }

    LineHeightMode[] getLineHeightMode() {
        return this.lineHeightMode;
    }

    LineWidthMode[] getLineWidthMode() {
        return this.lineWidthMode;
    }

    int getCursorLine() {
        return this.cursor.line;
    }

    int getCursorCol() {
        return this.cursor.col;
    }

    int getScrollbarPosLine() {
        return this.getVerticalBar().getSelection();
    }

    int getNumLines() {
        return this.numLines;
    }

    int getNumCols() {
        return this.numCols;
    }

    int getHistorySize() {
        return this.historySize;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.terminalSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.terminalSelection);
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }
}

