/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.CharSet;
import eu.geclipse.terminal.internal.LineHeightMode;
import eu.geclipse.terminal.internal.LineWidthMode;
import eu.geclipse.terminal.internal.Terminal;
import eu.geclipse.terminal.internal.TerminalSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

class TerminalPainter
implements PaintListener {
    private Terminal terminal;
    private TerminalSelection selection;
    private Char startChar = null;
    private int startCharLine = 0;
    private int startCharCol = 0;
    private boolean selected;
    private StringBuilder buffer = new StringBuilder();
    private int numChars = 0;
    private LineHeightMode lineHeight;
    private LineWidthMode lineWidth;
    private LineHeightMode[] lineHeightMode;
    private LineWidthMode[] lineWidthMode;
    private Font normalFont;
    private Font boldFont;
    private Font normalDoubleFont;
    private Font boldDoubleFont;
    private final char[] specialChars = new char[]{'\u2591', '\u2409', '\u240c', '\u240d', '\u240a', '\u00b0', '\u00b1', '?', '?', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '?', '?', '\u2500', '?', '?', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265'};

    TerminalPainter(Terminal term) {
        this.terminal = term;
    }

    private void addToStringBuffer(StringBuilder buf, Char ch) {
        if (ch.charSet == CharSet.SPECIAL && ch.ch >= 'a' && ch.ch <= 'z') {
            buf.append(this.specialChars[ch.ch - 97]);
        } else {
            buf.append(ch.ch);
        }
    }

    private void paintBufferedArea(GC gc) {
        int fontHeight = this.terminal.getFontHeigth();
        int fontWidth = this.terminal.getFontWidth();
        if (this.lineWidth == LineWidthMode.DOUBLE) {
            fontWidth *= 2;
        }
        if (this.startChar.negative ^ this.terminal.isInReverseScreenMode() ^ this.selected) {
            gc.setBackground(this.startChar.fgColor);
            gc.setForeground(this.startChar.bgColor);
        } else {
            gc.setBackground(this.startChar.bgColor);
            gc.setForeground(this.startChar.fgColor);
        }
        if (this.startChar.ch == '\u0000') {
            gc.fillRectangle(fontWidth * this.startCharCol, fontHeight * this.startCharLine, fontWidth * this.numChars, fontHeight);
        } else {
            gc.fillRectangle(fontWidth * this.startCharCol, fontHeight * this.startCharLine, fontWidth * this.numChars, fontHeight);
            if (this.lineHeight != LineHeightMode.NORMAL && this.lineWidth == LineWidthMode.DOUBLE) {
                Rectangle rect = gc.getClipping();
                gc.setClipping(0, fontHeight * this.startCharLine, rect.width, fontHeight);
                if (this.startChar.bold) {
                    gc.setFont(this.boldDoubleFont);
                } else {
                    gc.setFont(this.normalDoubleFont);
                }
            } else {
                gc.setClipping(null);
                if (this.startChar.bold) {
                    gc.setFont(this.boldFont);
                } else {
                    gc.setFont(this.normalFont);
                }
            }
            if (this.lineWidth == LineWidthMode.NORMAL) {
                gc.drawText(this.buffer.toString(), fontWidth * this.startCharCol, fontHeight * this.startCharLine);
            } else {
                int heightOffset = 0;
                if (this.lineHeight == LineHeightMode.DOUBLE_BOTTOM) {
                    heightOffset = -1;
                }
                String string = this.buffer.toString();
                int i = 0;
                while (i < string.length()) {
                    gc.drawText(string.substring(i, i + 1), fontWidth * (this.startCharCol + i), fontHeight * (this.startCharLine + heightOffset));
                    ++i;
                }
            }
            if (this.startChar.underscore) {
                int col = this.startCharCol;
                while (col < this.startCharCol + this.buffer.length()) {
                    gc.drawText("_", fontWidth * col, fontHeight * this.startCharLine, true);
                    ++col;
                }
            }
        }
    }

    private void resetStartChar(Char ch, int line, int col) {
        if (ch.ch != '\u0000') {
            this.buffer.delete(0, this.buffer.length());
            this.addToStringBuffer(this.buffer, ch);
        }
        this.startChar = ch;
        this.startCharLine = line;
        this.startCharCol = col;
        this.selected = this.selection.isSelected(line + this.terminal.getScrollbarPosLine(), col);
        this.numChars = 1;
        this.lineHeight = this.lineHeightMode[line + this.terminal.getScrollbarPosLine()];
        this.lineWidth = this.lineWidthMode[line + this.terminal.getScrollbarPosLine()];
    }

    public void paintControl(PaintEvent paintEvent) {
        boolean fillBottomGap;
        Char[][] screenBuffer = this.terminal.getScreenBuffer();
        this.lineHeightMode = this.terminal.getLineHeightMode();
        this.lineWidthMode = this.terminal.getLineWidthMode();
        this.selection = (TerminalSelection)this.terminal.getSelection();
        int numLines = this.terminal.getNumLines();
        int numCols = screenBuffer[0].length;
        int fontHeight = this.terminal.getFontHeigth();
        int fontWidth = this.terminal.getFontWidth();
        int startLine = paintEvent.y / fontHeight;
        int endLine = (paintEvent.y + paintEvent.height + fontHeight) / fontHeight;
        boolean bl = fillBottomGap = screenBuffer.length < endLine + this.terminal.getScrollbarPosLine();
        if (endLine > numLines && fillBottomGap) {
            endLine = numLines;
        }
        int line = startLine;
        while (line < endLine) {
            int startCol = paintEvent.x / fontWidth;
            int endCol = (paintEvent.x + paintEvent.width + fontWidth) / fontWidth;
            if (endCol > numCols) {
                endCol = numCols;
            }
            if (this.lineWidthMode[line + this.terminal.getScrollbarPosLine()] == LineWidthMode.DOUBLE) {
                startCol /= 2;
                endCol = (endCol + 1) / 2;
            }
            int col = startCol;
            while (col < endCol) {
                Char ch = screenBuffer[line + this.terminal.getScrollbarPosLine()][col];
                if (this.startChar == null) {
                    this.resetStartChar(ch, line, col);
                } else if (this.startChar.ch == '\u0000' && ch.ch == '\u0000' && ch.hasSameFormat(this.startChar) && this.selection.isSelected(line + this.terminal.getScrollbarPosLine(), col) == this.selected) {
                    ++this.numChars;
                } else if (this.startChar.ch != '\u0000' && ch.ch != '\u0000' && ch.hasSameFormat(this.startChar) && this.selection.isSelected(line + this.terminal.getScrollbarPosLine(), col) == this.selected) {
                    this.addToStringBuffer(this.buffer, ch);
                    ++this.numChars;
                } else {
                    this.paintBufferedArea(paintEvent.gc);
                    this.resetStartChar(ch, line, col);
                }
                ++col;
            }
            if (this.startChar != null) {
                this.paintBufferedArea(paintEvent.gc);
                this.startChar = null;
            }
            if (line + this.terminal.getScrollbarPosLine() == this.terminal.getCursorLine() + this.terminal.getHistorySize()) {
                int widthMult = 1;
                if (this.lineWidthMode[line + this.terminal.getScrollbarPosLine()] == LineWidthMode.DOUBLE) {
                    widthMult = 2;
                }
                paintEvent.gc.drawText("_", fontWidth * this.terminal.getCursorCol() * widthMult, fontHeight * line, true);
            }
            ++line;
        }
        paintEvent.gc.setBackground(this.terminal.getBackground());
        if (fillBottomGap && paintEvent.y + paintEvent.height >= fontHeight * numLines) {
            int height = paintEvent.y + paintEvent.height - fontHeight * numLines;
            paintEvent.gc.fillRectangle(paintEvent.x, fontHeight * numLines, paintEvent.width, height);
        }
        if (paintEvent.x + paintEvent.width >= fontWidth * numCols) {
            int width = paintEvent.x + paintEvent.width - fontWidth * numCols;
            paintEvent.gc.fillRectangle(fontWidth * numCols, paintEvent.y, width, paintEvent.height);
        }
    }

    void setFont(Font font) {
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(0);
        this.normalFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(1);
        this.boldFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(0);
        fontData.setHeight(fontData.getHeight() * 2);
        this.normalDoubleFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(1);
        this.boldDoubleFont = new Font(font.getDevice(), fontData);
    }

    void scrollUp(int topMargin, int bottomMargin) {
        Char[][] screenBuffer = this.terminal.getScreenBuffer();
        int numCols = screenBuffer[0].length;
        int fontHeight = this.terminal.getFontHeigth();
        int fontWidth = this.terminal.getFontWidth();
        GC gc = new GC((Drawable)this.terminal);
        gc.copyArea(0, fontHeight * (topMargin + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine() + 1), fontWidth * numCols, fontHeight * (bottomMargin - topMargin), 0, fontHeight * (topMargin + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine()), true);
        gc.dispose();
    }

    void scrollDown(int topMargin, int bottomMargin) {
        Char[][] screenBuffer = this.terminal.getScreenBuffer();
        int numCols = screenBuffer[0].length;
        int fontHeight = this.terminal.getFontHeigth();
        int fontWidth = this.terminal.getFontWidth();
        GC gc = new GC((Drawable)this.terminal);
        gc.copyArea(0, fontHeight * (topMargin + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine()), fontWidth * numCols, fontHeight * (bottomMargin - topMargin), 0, fontHeight * (topMargin + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine() + 1), true);
        gc.dispose();
    }
}

