/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.Terminal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Display;

class TerminalSelection
implements ITextSelection,
MouseMoveListener,
MouseListener {
    private int startRow;
    private int startCol;
    private int endRow;
    private int endCol;
    private int row1;
    private int col1;
    private int row2;
    private int col2;
    private Terminal terminal;

    TerminalSelection(Terminal terminal) {
        this.terminal = terminal;
    }

    void clearSelection() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalSelection.this.clearSelection(0, 0);
            }
        });
    }

    void clearSelection(int row, int col) {
        boolean redraw = !this.isEmpty();
        this.row1 = row;
        this.col1 = col;
        this.row2 = row;
        this.col2 = col;
        this.startRow = row;
        this.startCol = col;
        this.endRow = row;
        this.endCol = col;
        if (redraw) {
            this.terminal.redraw();
        }
    }

    private void updateSelection(int row, int col) {
        this.row2 = row;
        this.col2 = col;
        if (this.row1 < this.row2 || this.row1 == this.row2 && this.col1 < this.col2) {
            this.startRow = this.row1;
            this.startCol = this.col1;
            this.endRow = row;
            this.endCol = col;
        } else {
            this.startRow = row;
            this.startCol = col;
            this.endRow = this.row1;
            this.endCol = this.col1;
        }
    }

    private int getColForXPos(int xPos) {
        int col = xPos / this.terminal.getFontWidth();
        if (col > this.terminal.getNumCols()) {
            col = this.terminal.getNumCols();
        }
        return col;
    }

    private int getRowForYPos(int yPos) {
        int scrollbarLine = this.terminal.getScrollbarPosLine();
        int row = yPos / this.terminal.getFontHeigth() + scrollbarLine;
        if (row >= this.terminal.getNumLines() + this.terminal.getHistorySize()) {
            row = this.terminal.getNumLines() + this.terminal.getHistorySize() - 1;
        }
        return row;
    }

    public int getEndLine() {
        return this.endRow;
    }

    public int getLength() {
        return this.getText().length();
    }

    public int getOffset() {
        return 0;
    }

    public int getStartLine() {
        return this.startRow;
    }

    public String getText() {
        StringBuilder str = new StringBuilder();
        Char[][] screenbuffer = this.terminal.getScreenBuffer();
        int row = this.startRow;
        while (row <= this.endRow) {
            int col = row == this.startRow ? this.startCol : 0;
            while (col < (row == this.endRow ? this.endCol : this.terminal.getNumCols())) {
                char ch = screenbuffer[row][col].ch;
                if (ch != '\u0000') {
                    str.append(ch);
                }
                ++col;
            }
            if (row != this.endRow) {
                str.append('\n');
            }
            ++row;
        }
        return str.toString();
    }

    public boolean isEmpty() {
        return this.startCol == this.endCol && this.startRow == this.endRow;
    }

    public void mouseDoubleClick(MouseEvent event) {
        char ch;
        int col;
        int row = this.getRowForYPos(event.y);
        int selStartCol = col = this.getColForXPos(event.x);
        int selEndCol = col;
        do {
            ch = this.terminal.getScreenBuffer()[row][selStartCol].ch;
        } while (--selStartCol >= 0 && ch != ' ' && ch != '\u0000');
        ++selStartCol;
        if (ch == ' ' || ch == '\u0000') {
            ++selStartCol;
        }
        do {
            ch = this.terminal.getScreenBuffer()[row][selEndCol].ch;
        } while (++selEndCol < this.terminal.getNumCols() && ch != ' ' && ch != '\u0000');
        if (ch == ' ' || ch == '\u0000') {
            --selEndCol;
        }
        this.clearSelection(row, selStartCol);
        this.updateSelection(row, selEndCol);
        this.triggerRedraw(row, selStartCol, row, selEndCol);
        this.terminal.fireSelectionChanged();
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1) {
            this.clearSelection(this.getRowForYPos(event.y), this.getColForXPos(event.x));
        }
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
        if ((event.stateMask & 0x80000) != 0) {
            int oldStartRow = this.startRow;
            int oldStartCol = this.startCol;
            int oldEndRow = this.endRow;
            int oldEndCol = this.endCol;
            this.updateSelection(this.getRowForYPos(event.y), this.getColForXPos(event.x));
            this.triggerRedraw(oldStartRow, oldStartCol, this.startRow, this.startCol);
            this.triggerRedraw(oldEndRow, oldEndCol, this.endRow, this.endCol);
            this.terminal.fireSelectionChanged();
        }
    }

    private void triggerRedraw(int oldRow, int oldCol, int newRow, int newCol) {
        int topRow = Math.min(oldRow, newRow);
        int bottomRow = Math.max(oldRow, newRow);
        int leftCol = Math.min(oldCol, newCol);
        int rightCol = Math.max(oldCol, newCol);
        if (topRow != bottomRow) {
            this.terminal.triggerRedraw(0, topRow - this.terminal.getHistorySize(), this.terminal.getNumCols(), bottomRow - topRow + 1);
        } else if (leftCol != rightCol) {
            this.terminal.triggerRedraw(leftCol, topRow - this.terminal.getHistorySize(), rightCol - leftCol, 1);
        }
    }

    boolean isSelected(int row, int col) {
        return row > this.startRow && row < this.endRow || row == this.startRow && row != this.endRow && col >= this.startCol || row != this.startRow && row == this.endRow && col < this.endCol || row == this.startRow && row == this.endRow && col >= this.startCol && col < this.endCol;
    }
}

