/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.debug.Activator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBreakpoint
extends AbstractLineBreakpoint {
    public static final String PROCESS = "Process";
    static final String IGNORE_COUNTS = "IgnoreCounts";
    private boolean alive = true;
    private int position = 0;

    public EventBreakpoint() {
    }

    public EventBreakpoint(IResource resource, Map attributes, boolean register) throws CoreException {
        super(resource, EventBreakpoint.getMarkerType(), attributes, register);
    }

    public static String getMarkerType() {
        return "eu.geclipse.traceview.debug.BreakpointMarker";
    }

    public int getIgnoreCount() throws CoreException {
        if (this.alive) {
            this.setIgnoreCount(this.getIgnoreCounts().first());
            this.alive = false;
        }
        return super.getIgnoreCount();
    }

    public int getProcess() throws CoreException {
        return this.ensureMarker().getAttribute(PROCESS, -1);
    }

    public void revive() {
        if (!this.alive) {
            this.alive = true;
            try {
                this.setEnabled(true);
            }
            catch (CoreException coreException) {
                Activator.logException((Exception)((Object)coreException));
            }
        }
    }

    private SortedSet<Integer> getIgnoreCounts() throws CoreException {
        String countString = this.ensureMarker().getAttribute(IGNORE_COUNTS, "");
        StringTokenizer tokenizer = new StringTokenizer(countString);
        TreeSet<Integer> counts = new TreeSet<Integer>();
        while (tokenizer.hasMoreTokens()) {
            counts.add(Integer.parseInt(tokenizer.nextToken()));
        }
        return counts;
    }

    private void setIgnoreCounts(SortedSet<Integer> ignoreCounts) throws DebugException, CoreException {
        if (!ignoreCounts.isEmpty()) {
            this.setIgnoreCount(ignoreCounts.first());
        }
        Iterator it = ignoreCounts.iterator();
        StringBuffer buffer = new StringBuffer();
        while (it.hasNext()) {
            buffer.append(String.valueOf(((Integer)it.next()).toString()) + " ");
        }
        this.ensureMarker().setAttribute(IGNORE_COUNTS, (Object)buffer.toString());
    }

    public boolean containtsEvent(IEvent event) throws CoreException {
        SortedSet<Integer> ignoreCounts = this.getIgnoreCounts();
        boolean result = false;
        Iterator it = ignoreCounts.iterator();
        if (event.getProcessId() == this.getProcess()) {
            while (!result && it.hasNext()) {
                ISourceLocation sourceLocation = (ISourceLocation)event;
                if (((Integer)it.next()).intValue() != sourceLocation.getOccurrenceCount() || this.getLineNumber() != sourceLocation.getSourceLineNumber()) continue;
                result = true;
            }
        }
        return result;
    }

    public void addEvent(IEvent event) throws CoreException {
        if (event instanceof ISourceLocation) {
            ISourceLocation sourceLocation = (ISourceLocation)event;
            SortedSet<Integer> ignoreCounts = this.getIgnoreCounts();
            if (ignoreCounts.add(sourceLocation.getOccurrenceCount())) {
                this.setIgnoreCounts(ignoreCounts);
            }
        }
    }

    public void removeEvent(IEvent event) throws CoreException {
        if (event instanceof ISourceLocation) {
            ISourceLocation sourceLocation = (ISourceLocation)event;
            SortedSet<Integer> ignoreCounts = this.getIgnoreCounts();
            if (ignoreCounts.remove(sourceLocation.getOccurrenceCount())) {
                this.setIgnoreCounts(ignoreCounts);
                if (ignoreCounts.isEmpty()) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this, true);
                }
            }
        }
    }

    public void next() throws CoreException {
        Integer[] ignoreCounts = this.getIgnoreCounts().toArray(new Integer[0]);
        if (ignoreCounts.length > this.position + 1) {
            this.setIgnoreCount(ignoreCounts[this.position + 1] - ignoreCounts[this.position++] - 1);
        } else {
            this.setEnabled(false);
        }
    }

    protected String getMarkerMessage() throws CoreException {
        String result = "breakpoint: process " + this.getProcess();
        return result;
    }
}

