/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.debug.Activator;
import eu.geclipse.traceview.debug.EventBreakpoint;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class EventBreakpointMarker
extends AbstractEventMarker {
    public Color getBackgroundColor(int type) {
        return Display.getDefault().getSystemColor(15);
    }

    public Color getForegroundColor(int type) {
        return Display.getDefault().getSystemColor(3);
    }

    public int getLineWidth(int type) {
        return 2;
    }

    public int mark(IEvent event) {
        int result = 0;
        if (event instanceof ISourceLocation) {
            IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int n = iBreakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof EventBreakpoint) {
                    EventBreakpoint eventBreakpoint = (EventBreakpoint)breakpoint;
                    try {
                        if (eventBreakpoint.containtsEvent(event)) {
                            result = 32;
                        }
                    }
                    catch (CoreException coreException) {
                        Activator.logException((Exception)((Object)coreException));
                    }
                } else if (breakpoint instanceof ICLineBreakpoint) {
                    ICLineBreakpoint cLineBreakpoint = (ICLineBreakpoint)breakpoint;
                    if (event instanceof ISourceLocation) {
                        ISourceLocation sourceLocation = (ISourceLocation)event;
                        try {
                            if (sourceLocation.getSourceFilename().equals(cLineBreakpoint.getFileName()) && sourceLocation.getSourceLineNumber() == cLineBreakpoint.getLineNumber()) {
                                if (cLineBreakpoint.getIgnoreCount() == 0) {
                                    result = 16;
                                } else if (cLineBreakpoint.getIgnoreCount() <= sourceLocation.getOccurrenceCount()) {
                                    result = 16;
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ++n2;
            }
        }
        return result;
    }
}

