/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.nope.tracereader;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.ILamportTrace;
import eu.geclipse.traceview.IPhysicalTrace;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceReader;
import eu.geclipse.traceview.nope.Activator;
import eu.geclipse.traceview.nope.tracereader.Event;
import eu.geclipse.traceview.nope.tracereader.Process;
import eu.geclipse.traceview.nope.tracereader.VecEvent;
import eu.geclipse.traceview.utils.AbstractTraceFileCache;
import eu.geclipse.traceview.utils.ClockCalculator;
import eu.geclipse.traceview.utils.LamportEventComparator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Trace
extends AbstractTraceFileCache
implements ILamportTrace,
IPhysicalTrace,
ITraceReader {
    private IPath tracePath;
    private String tracedir;
    private Process[] processes;
    private int maximumLamportClock = 0;
    private boolean supportsVectorClocks;
    private int eventSize;

    private void updatePartnerClocks() {
        int procId = 0;
        while (procId < this.getNumberOfProcesses()) {
            IProcess process = this.getProcess(procId);
            int i = 0;
            while (i <= process.getMaximumLogicalClock()) {
                Event event = (Event)process.getEventByLogicalClock(i);
                if (event.getType() == EventType.RECV) {
                    IProcess partnerProcess = this.getProcess(event.getPartnerProcessId());
                    Event sendEvent = (Event)partnerProcess.getEventByLogicalClock(event.getPartnerLogicalClock());
                    sendEvent.setPartnerLogicalClock(event.getLogicalClock());
                }
                ++i;
            }
            ++procId;
        }
    }

    private void updateVectorClocks() {
        TreeSet<VecEvent> events = new TreeSet<VecEvent>((Comparator<VecEvent>)new LamportEventComparator());
        try {
            int i = 0;
            while (i < this.processes.length) {
                events.add((VecEvent)this.processes[i].getEventByLogicalClock(0));
                ++i;
            }
            while (!events.isEmpty()) {
                int i2;
                int[] partnerVectorClock;
                VecEvent partner;
                VecEvent first = (VecEvent)((Object)events.first());
                VecEvent next = (VecEvent)first.getNextEvent();
                int[] vectorClock = first.getVectorClock();
                int n = first.getProcessId();
                vectorClock[n] = vectorClock[n] + 1;
                first.setVectorClock(vectorClock);
                if (first.getType() == EventType.SEND && first.getSubType() != 192) {
                    partner = (VecEvent)first.getPartnerEvent();
                    if (partner != null) {
                        partnerVectorClock = partner.getVectorClock();
                        i2 = 0;
                        while (i2 < this.getNumberOfProcesses()) {
                            if (vectorClock[i2] > partnerVectorClock[i2]) {
                                partnerVectorClock[i2] = vectorClock[i2];
                            }
                            ++i2;
                        }
                        partner.setVectorClock(partnerVectorClock);
                    }
                } else if (first.getType() == EventType.RECV && first.getSubType() == 192 && (partner = (VecEvent)first.getPartnerEvent()) != null) {
                    partnerVectorClock = partner.getVectorClock();
                    i2 = 0;
                    while (i2 < this.getNumberOfProcesses()) {
                        if (vectorClock[i2] > partnerVectorClock[i2]) {
                            partnerVectorClock[i2] = vectorClock[i2];
                        }
                        ++i2;
                    }
                    first.setVectorClock(partnerVectorClock);
                }
                if (next != null) {
                    int[] f = first.getVectorClock();
                    int[] n2 = next.getVectorClock();
                    i2 = 0;
                    while (i2 < this.getNumberOfProcesses()) {
                        if (f[i2] > n2[i2]) {
                            n2[i2] = f[i2];
                        }
                        ++i2;
                    }
                    next.setVectorClock(n2);
                    events.add(next);
                }
                events.remove((Object)first);
            }
        }
        catch (IndexOutOfBoundsException exception) {
            Activator.logException(exception);
        }
    }

    public ITrace openTrace(IPath trace, IProgressMonitor monitor) throws IOException {
        this.tracePath = trace.removeLastSegments(1);
        File dir = this.tracePath.toFile();
        this.tracedir = this.tracePath.toPortableString();
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().startsWith("trace") && file.getName().charAt(file.getName().length() - 4) == '.';
            }
        });
        this.processes = new Process[files.length];
        String traceOptions = "";
        this.supportsVectorClocks = Activator.getDefault().getPreferenceStore().getBoolean("vector");
        if (this.supportsVectorClocks()) {
            this.eventSize = 17 + this.getNumberOfProcesses();
            traceOptions = String.valueOf(traceOptions) + "vectorClocks ";
        } else {
            this.eventSize = 17;
        }
        String projectName = "";
        boolean workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf(this.tracePath);
        if (workspace) {
            IPath path = this.tracePath.removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getLocation().segmentCount());
            projectName = path.uptoSegment(1).toPortableString();
            String device = path.getDevice();
            if (device != null) {
                projectName = projectName.substring(device.length());
            }
        }
        long modTime = dir.lastModified();
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = objectArray[n2];
            if (file.lastModified() > modTime) {
                modTime = file.lastModified();
            }
            ++n2;
        }
        monitor.beginTask("Loading trace data", this.processes.length);
        monitor.subTask("Opening trace cache");
        boolean hasCache = this.openCacheDir(dir.getAbsolutePath(), traceOptions, modTime);
        Arrays.sort(files);
        Object[] objectArray2 = files;
        int n3 = files.length;
        n = 0;
        while (n < n3) {
            Process processTrace;
            Object file = objectArray2[n];
            if (monitor.isCanceled()) {
                return null;
            }
            String filename = ((File)file).getName();
            int traceProc = Integer.parseInt(filename.substring(filename.length() - 3));
            monitor.subTask("Loading process " + traceProc);
            this.processes[traceProc] = processTrace = new Process(new File(this.tracedir, filename), traceProc, hasCache, this);
            monitor.worked(1);
            ++n;
        }
        this.enableMemoryMap();
        if (!hasCache) {
            if (monitor.isCanceled()) {
                return null;
            }
            monitor.subTask("Updating logical clocks");
            this.updatePartnerClocks();
            if (monitor.isCanceled()) {
                return null;
            }
            monitor.subTask("Calculating lamport clocks");
            ClockCalculator.calcLamportClock((ILamportTrace)this);
            if (this.supportsVectorClocks) {
                if (monitor.isCanceled()) {
                    return null;
                }
                monitor.subTask("Calculating vector clocks");
                this.updateVectorClocks();
            }
            this.saveCacheMetadata();
        }
        objectArray2 = this.processes;
        n3 = this.processes.length;
        n = 0;
        while (n < n3) {
            Object process = objectArray2[n];
            if (this.maximumLamportClock < process.getMaximumLamportClock()) {
                this.maximumLamportClock = process.getMaximumLamportClock();
            }
            ++n;
        }
        return this;
    }

    public int getNumberOfProcesses() {
        return this.processes.length;
    }

    public IProcess getProcess(int processId) throws IndexOutOfBoundsException {
        return this.processes[processId];
    }

    public String getName() {
        String name = this.tracePath.removeFirstSegments(1).lastSegment();
        int index = name.indexOf(".traces");
        if (index != -1) {
            name = name.substring(0, index);
        }
        return name;
    }

    public int getMaximumLamportClock() {
        return this.maximumLamportClock;
    }

    protected Process[] getProcesses() {
        return this.processes;
    }

    public int getMaximumPhysicalClock() {
        int maxTimeStop = 0;
        Process[] processArray = this.processes;
        int n = this.processes.length;
        int n2 = 0;
        while (n2 < n) {
            Process process = processArray[n2];
            if (maxTimeStop < process.getEventByLogicalClock(process.getMaximumLogicalClock()).getPhysicalStopClock()) {
                maxTimeStop = process.getEventByLogicalClock(process.getMaximumLogicalClock()).getPhysicalStopClock();
            }
            ++n2;
        }
        return maxTimeStop;
    }

    protected boolean supportsVectorClocks() {
        return this.supportsVectorClocks;
    }

    public IPath getPath() {
        return this.tracePath;
    }

    public int getEventSize() {
        return this.eventSize;
    }
}

