/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.statistics;

import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.TraceVisualization;
import eu.geclipse.traceview.statistics.Activator;
import eu.geclipse.traceview.statistics.Messages;
import eu.geclipse.traceview.statistics.StatisticsVisualisationLabelProvider;
import eu.geclipse.traceview.statistics.chartbuilder.AbstractChartBuilder;
import eu.geclipse.traceview.statistics.providers.IStatistics;
import java.util.ArrayList;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;

public class StatisticsVisualisation
extends TraceVisualization {
    protected int x = 0;
    protected int y = 0;
    protected IDeviceRenderer render = null;
    protected Chart chart = null;
    protected GeneratedChartState state = null;
    protected Composite composite = null;
    private Image cachedImage = null;
    private ITrace trace = null;

    public StatisticsVisualisation(Composite parent, int style, IViewSite viewSite, ITrace trace) {
        super(parent, style);
        this.trace = trace;
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData(4, 4, true, true);
        layout.numColumns = 4;
        this.setLayout((Layout)layout);
        this.setLayoutData(layoutData);
        layout = new GridLayout();
        layoutData = new GridData(4, 4, false, true);
        layoutData.horizontalSpan = 1;
        Group selectionGroup = new Group((Composite)this, 0);
        selectionGroup.setText(Messages.getString("StatisticsVisualisation.Statistics"));
        selectionGroup.setLayout((Layout)layout);
        selectionGroup.setLayoutData((Object)layoutData);
        final TreeViewer treeViewer = new TreeViewer((Composite)selectionGroup);
        layout = new GridLayout();
        layoutData = new GridData(4, 4, true, true);
        treeViewer.getTree().setLayout((Layout)layout);
        treeViewer.getTree().setLayoutData((Object)layoutData);
        treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new StatisticsVisualisationLabelProvider());
        this.populateTree(treeViewer);
        Group chartGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layoutData = new GridData(4, 4, true, true);
        chartGroup.setLayout((Layout)layout);
        chartGroup.setLayoutData((Object)layoutData);
        chartGroup.setText(Messages.getString("StatisticsVisualisation.Chart"));
        layoutData.horizontalSpan = 3;
        Group description = new Group((Composite)this, 0);
        layout = new GridLayout();
        layoutData = new GridData(4, 4, true, false);
        layoutData.heightHint = 60;
        layoutData.horizontalSpan = 4;
        description.setLayout((Layout)layout);
        description.setLayoutData((Object)layoutData);
        description.setText(Messages.getString("StatisticsVisualisation.Description"));
        final Text text = new Text((Composite)description, 578);
        text.setEditable(false);
        text.setBackground(this.getDisplay().getSystemColor(22));
        layoutData = new GridData(4, 4, true, true);
        text.setLayoutData((Object)layoutData);
        text.setText(Messages.getString("StatisticsVisualisation.Select"));
        new Label((Composite)chartGroup, 0);
        final ScrolledComposite sc = new ScrolledComposite((Composite)chartGroup, 2816);
        sc.setBackground(this.getDisplay().getSystemColor(1));
        layout = new GridLayout();
        layoutData = new GridData(4, 4, true, true);
        layoutData.verticalIndent = -18;
        sc.setLayout((Layout)layout);
        sc.setLayoutData((Object)layoutData);
        this.composite = new Composite((Composite)sc, 0);
        this.composite.setBackground(this.getDisplay().getSystemColor(1));
        layout = new GridLayout();
        layoutData = new GridData(4, 4, true, true);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)layoutData);
        try {
            PluginSettings ps = PluginSettings.instance();
            this.render = ps.getDevice("dv.SWT");
        }
        catch (ChartException exception) {
            Activator.logException((Exception)((Object)exception));
        }
        sc.setContent((Control)this.composite);
        sc.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                int maxX = Math.max(StatisticsVisualisation.this.x, sc.getClientArea().width);
                int maxY = Math.max(StatisticsVisualisation.this.y, sc.getClientArea().height);
                StatisticsVisualisation.this.composite.setSize(maxX, maxY);
            }
        });
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (StatisticsVisualisation.this.chart != null) {
                    StatisticsVisualisation.this.paint(e);
                }
            }
        });
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StatisticsVisualisation.this.disposeWidget(e);
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeNode treeNode;
                IStructuredSelection structuredSelection;
                if (treeViewer.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)treeViewer.getSelection()).getFirstElement() instanceof TreeNode && (treeNode = (TreeNode)structuredSelection.getFirstElement()).getValue() instanceof IStatistics) {
                    IStatistics statistics = (IStatistics)treeNode.getValue();
                    text.setText(statistics.getDescription());
                }
            }
        });
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                TreeNode treeNode;
                ISelection selection = treeViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && (treeNode = (TreeNode)(structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && treeNode.getValue() instanceof AbstractChartBuilder) {
                    AbstractChartBuilder abstractChartBuilder = (AbstractChartBuilder)treeNode.getValue();
                    IStatistics statistics = (IStatistics)treeNode.getParent().getValue();
                    text.setText(statistics.getDescription());
                    statistics.initialize();
                    abstractChartBuilder.setTitle(statistics.getTitle());
                    abstractChartBuilder.setXSeries(statistics.getXSeries());
                    abstractChartBuilder.setYSeries(statistics.getYSeries());
                    abstractChartBuilder.setZSeries(statistics.getZSeries());
                    abstractChartBuilder.build();
                    StatisticsVisualisation.this.setChart(abstractChartBuilder.getChart());
                    StatisticsVisualisation.this.x = abstractChartBuilder.minWidth();
                    StatisticsVisualisation.this.y = abstractChartBuilder.minHeight();
                    int maxX = Math.max(StatisticsVisualisation.this.x, sc.getClientArea().width);
                    int maxY = Math.max(StatisticsVisualisation.this.y, sc.getClientArea().height);
                    StatisticsVisualisation.this.composite.setSize(maxX, maxY);
                    StatisticsVisualisation.this.composite.redraw();
                }
            }
        });
    }

    private void populateTree(TreeViewer treeViewer) {
        ArrayList<TreeNode> root = new ArrayList<TreeNode>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.statistics.Statistics");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                IStatistics statistics = (IStatistics)configurationElement.createExecutableExtension("class");
                statistics.setTrace(this.trace);
                TreeNode treeNode = new TreeNode((Object)statistics);
                ArrayList<TreeNode> leaf = new ArrayList<TreeNode>();
                IConfigurationElement[] iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.statistics.Visualizations");
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement2 = iConfigurationElementArray2[n4];
                    if (!(statistics.xAxis() != configurationElement2.getAttribute("x") && !statistics.xAxis().equals(configurationElement2.getAttribute("x")) || statistics.yAxis() != configurationElement2.getAttribute("y") && !statistics.yAxis().equals(configurationElement2.getAttribute("y")) || statistics.zAxis() != configurationElement2.getAttribute("z") && !statistics.zAxis().equals(configurationElement2.getAttribute("z")))) {
                        AbstractChartBuilder abstractChartBuilder = (AbstractChartBuilder)configurationElement2.createExecutableExtension("class");
                        TreeNode child = new TreeNode((Object)abstractChartBuilder);
                        child.setParent(treeNode);
                        leaf.add(child);
                    }
                    ++n4;
                }
                treeNode.setChildren(leaf.toArray(new TreeNode[0]));
                root.add(treeNode);
            }
            catch (CoreException coreException) {
                Activator.logException((Exception)((Object)coreException));
            }
            ++n2;
        }
        treeViewer.setInput((Object)root.toArray(new TreeNode[0]));
        treeViewer.expandAll();
    }

    protected void paint(PaintEvent e) {
        Point size = this.composite.getSize();
        if (this.cachedImage != null && !this.cachedImage.isDisposed()) {
            this.cachedImage.dispose();
        }
        this.cachedImage = new Image((Device)Display.getCurrent(), size.x, size.y);
        GC gc = new GC((Drawable)this.cachedImage);
        this.render.setProperty("device.output.context", (Object)gc);
        Generator gr = Generator.instance();
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)size.x, (double)size.y);
        int resolution = this.render.getDisplayServer().getDpiResolution();
        bo.scale(72.0 / (double)resolution);
        try {
            try {
                this.state = gr.build(this.render.getDisplayServer(), this.chart, bo, null);
                gr.render(this.render, this.state);
                if (this.cachedImage != null) {
                    e.gc.drawImage(this.cachedImage, 0, 0, this.cachedImage.getBounds().width, this.cachedImage.getBounds().height, 0, 0, size.x, size.y);
                }
            }
            catch (ChartException exception) {
                Activator.logException((Exception)((Object)exception));
                this.cachedImage.dispose();
            }
        }
        finally {
            this.cachedImage.dispose();
        }
    }

    protected void disposeWidget(DisposeEvent e) {
        if (this.cachedImage != null && !this.cachedImage.isDisposed()) {
            this.cachedImage.dispose();
        }
    }

    public IContributionItem[] getToolBarItems() {
        return new IContributionItem[0];
    }

    public ITrace getTrace() {
        return this.trace;
    }

    protected void setChart(Chart chart) {
        if (this.cachedImage != null) {
            this.cachedImage.dispose();
        }
        this.cachedImage = null;
        this.chart = chart;
    }

    public void printTrace(GC gc) {
    }
}

