/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.statistics.chartbuilder;

import eu.geclipse.traceview.statistics.Activator;
import eu.geclipse.traceview.statistics.Messages;
import eu.geclipse.traceview.statistics.chartbuilder.AbstractChartBuilder;
import java.util.Calendar;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.swt.graphics.Image;

public class StackedChartBuilder
extends AbstractChartBuilder {
    private static Image image = Activator.getImageDescriptor("icons/obj16/stackedbarchart.gif").createImage();
    protected Axis xAxis = null;
    protected Axis yAxis = null;
    private double[][] ySeries = null;
    private String[] names = null;
    private Calendar[] times = null;
    private String[] zSeries = null;

    public String getName() {
        return Messages.getString("StackedChartBuilder.Name");
    }

    public Image getImage() {
        return image;
    }

    public int minHeight() {
        return 100;
    }

    public int minWidth() {
        return 20 * this.ySeries[0].length;
    }

    protected void createChart() {
        this.chart = ChartWithAxesImpl.create();
        this.chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        ((ChartWithAxes)this.chart).setUnitSpacing(30.0);
    }

    public void setXSeries(Object object) {
        if (object instanceof String[]) {
            this.names = (String[])object;
        } else if (object instanceof Calendar[]) {
            this.times = (Calendar[])object;
        }
    }

    public void setYSeries(Object object) {
        this.ySeries = (double[][])object;
    }

    public void setZSeries(Object object) {
        if (object instanceof String[]) {
            this.zSeries = (String[])object;
        }
    }

    protected void buildLegend() {
        Legend lg = this.chart.getLegend();
        lg.getText().getFont().setSize(8.0f);
    }

    protected void buildXAxis() {
        this.xAxis = ((ChartWithAxes)this.chart).getPrimaryBaseAxes()[0];
        if (this.times != null) {
            this.xAxis.setType(AxisType.DATE_TIME_LITERAL);
        } else {
            this.xAxis.setType(AxisType.TEXT_LITERAL);
        }
        this.xAxis.getTitle().getCaption().setValue(this.xTitle);
        this.xAxis.getTitle().setVisible(true);
    }

    protected void buildYAxis() {
        this.yAxis = ((ChartWithAxes)this.chart).getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.getTitle().getCaption().setValue(this.yTitle);
        this.yAxis.getTitle().setVisible(true);
        this.yAxis.getScale().setStepNumber(8);
    }

    protected void buildXSeries() {
        TextDataSet xDataSet = null;
        if (this.times != null) {
            DateTimeDataSetImpl.create((Object)this.times);
        } else {
            if (this.names == null) {
                this.names = new String[this.ySeries[0].length];
                int i = 0;
                while (i < this.ySeries[0].length) {
                    this.names[i] = Integer.toString(i);
                    ++i;
                }
            }
            xDataSet = TextDataSetImpl.create((Object)this.names);
        }
        Series xSeries = SeriesImpl.create();
        xSeries.setDataSet((DataSet)xDataSet);
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeries().add((Object)xSeries);
        this.xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
    }

    protected void buildYSeries() {
        SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
        Palette palette = PaletteImpl.create((int)0, (boolean)false);
        ySeriesDefinition.setSeriesPalette(palette);
        int i = 0;
        while (i < this.zSeries.length) {
            NumberDataSet yDataSet = NumberDataSetImpl.create((Object)this.ySeries[i]);
            BarSeries barSeries = (BarSeries)BarSeriesImpl.create();
            barSeries.setSeriesIdentifier((Object)this.zSeries[i]);
            barSeries.setDataSet((DataSet)yDataSet);
            barSeries.setRiser(RiserType.RECTANGLE_LITERAL);
            barSeries.setStacked(true);
            ySeriesDefinition.getSeries().add((Object)barSeries);
            ++i;
        }
        this.yAxis.getSeriesDefinitions().add((Object)ySeriesDefinition);
    }
}

