/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.statistics.providers;

import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.statistics.Activator;
import eu.geclipse.traceview.statistics.Messages;
import eu.geclipse.traceview.statistics.providers.IStatistics;
import java.util.Hashtable;
import org.eclipse.swt.graphics.Image;

public class FunctionDistributionCombined
implements IStatistics {
    ITrace trace;
    Hashtable<String, Double> functions;

    public String getName() {
        return Messages.getString("FunctionDistributionCombined.Name");
    }

    public String getDescription() {
        return Messages.getString("FunctionDistributionCombined.Description");
    }

    public String getTitle() {
        return this.getName();
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icons/obj16/distribution.gif").createImage();
    }

    public void setTrace(ITrace trace) {
        this.trace = trace;
    }

    public void initialize() {
        this.functions = new Hashtable();
        int i = 0;
        while (i < this.trace.getNumberOfProcesses()) {
            IProcess process = this.trace.getProcess(i);
            int j = 0;
            while (j <= process.getMaximumLogicalClock()) {
                String name = process.getEventByLogicalClock(j).getName();
                Double value = this.functions.get(name);
                if (value == null) {
                    this.functions.put(name, 1.0);
                } else {
                    this.functions.put(name, Double.valueOf(value.intValue() + 1));
                }
                ++j;
            }
            ++i;
        }
    }

    public String xAxis() {
        return "1";
    }

    public String yAxis() {
        return "category";
    }

    public String zAxis() {
        return null;
    }

    public Object getXSeries() {
        String[] result = this.functions.keySet().toArray(new String[0]);
        return result;
    }

    public Object getYSeries() {
        Double[] values = this.functions.values().toArray(new Double[0]);
        double[] dValues = new double[values.length];
        int i = 0;
        while (i < values.length) {
            dValues[i] = values[i];
            ++i;
        }
        return dValues;
    }

    public Object getZSeries() {
        return null;
    }
}

