/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.statistics.providers;

import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.statistics.Activator;
import eu.geclipse.traceview.statistics.Messages;
import eu.geclipse.traceview.statistics.providers.IStatistics;
import org.eclipse.swt.graphics.Image;

public class IndividualTimeConsumption
implements IStatistics {
    private ITrace trace;
    private double[][] y = null;

    public String getName() {
        return Messages.getString("IndividualTimeConsumption.Name");
    }

    public String getDescription() {
        return Messages.getString("IndividualTimeConsumption.Description");
    }

    public String getTitle() {
        return this.getName();
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icons/obj16/clock.gif").createImage();
    }

    public void setTrace(ITrace trace) {
        this.trace = trace;
    }

    public void initialize() {
        if (this.y == null) {
            this.y = new double[2][];
            int runtime = 0;
            double[] calculation = new double[this.trace.getNumberOfProcesses()];
            double[] communication = new double[this.trace.getNumberOfProcesses()];
            try {
                int j = 0;
                while (j < this.trace.getNumberOfProcesses()) {
                    int i = 0;
                    while (i <= this.trace.getProcess(j).getMaximumLogicalClock()) {
                        IPhysicalEvent event = (IPhysicalEvent)this.trace.getProcess(j).getEventByLogicalClock(i);
                        if (i >= this.trace.getProcess(j).getMaximumLogicalClock() || event.getPhysicalStartClock() != ((IPhysicalEvent)this.trace.getProcess(j).getEventByLogicalClock(i + 1)).getPhysicalStartClock()) {
                            runtime += event.getPhysicalStopClock() - event.getPhysicalStartClock();
                        }
                        ++i;
                    }
                    communication[j] = runtime;
                    calculation[j] = ((IPhysicalEvent)this.trace.getProcess(j).getEventByLogicalClock(this.trace.getProcess(j).getMaximumLogicalClock())).getPhysicalStopClock() - runtime;
                    runtime = 0;
                    ++j;
                }
            }
            catch (IndexOutOfBoundsException exception) {
                Activator.logException(exception);
            }
            this.y[0] = calculation;
            this.y[1] = communication;
        }
    }

    public String xAxis() {
        return "1";
    }

    public String yAxis() {
        return "2";
    }

    public String zAxis() {
        return "category";
    }

    public Object getXSeries() {
        return null;
    }

    public Object getYSeries() {
        return this.y;
    }

    public Object getZSeries() {
        String[] names = new String[]{Messages.getString("IndividualTimeConsumption.Calculation"), Messages.getString("IndividualTimeConsumption.Communication")};
        return names;
    }
}

