/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class BufferedRandomAccessFile {
    private static final int BUFFER_SIZE = 65536;
    private static final int PRE_SEEK_BUFFER = 2048;
    private byte[] buffer = new byte[65536];
    private boolean dirty = false;
    private long startOffset = 0L;
    private int size = 0;
    private int bufferPos = 0;
    private RandomAccessFile file;

    public BufferedRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.file = new RandomAccessFile(file, mode);
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public void write(int b) throws IOException {
        if (this.bufferPos == 65536) {
            this.seek(this.startOffset + 65536L);
        }
        this.buffer[this.bufferPos++] = (byte)b;
        if (this.size < this.bufferPos) {
            this.size = this.bufferPos;
        }
        this.dirty = true;
    }

    public int read() throws IOException {
        if (this.bufferPos == 65536) {
            this.seek(this.startOffset + 65536L);
        }
        return this.buffer[this.bufferPos++];
    }

    public void close() throws IOException {
        this.flush();
        this.file.close();
    }

    public void seek(long pos) throws IOException {
        if (pos < this.startOffset || pos >= this.startOffset + 65536L) {
            this.flush();
            this.startOffset = pos - 2048L;
            this.bufferPos = 2048;
            if (this.startOffset < 0L) {
                this.startOffset = 0L;
                this.bufferPos = (int)pos;
            }
            if (this.file.length() > this.startOffset) {
                this.file.seek(this.startOffset);
                this.size = this.file.read(this.buffer);
            } else {
                this.size = 0;
            }
        } else {
            this.bufferPos = (int)(pos - this.startOffset);
        }
    }

    public void flush() throws IOException {
        if (this.dirty) {
            this.file.seek(this.startOffset);
            this.file.write(this.buffer, 0, this.size);
            this.dirty = false;
        }
    }

    public FileChannel getChannel() throws IOException {
        this.flush();
        return this.file.getChannel();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public int readInt() throws IOException {
        int a = this.read();
        int b = this.read();
        int c = this.read();
        int d = this.read();
        return (a << 24) + (b << 16) + (c << 8) + d;
    }

    public void writeInt(int value) throws IOException {
        this.write(value >>> 24 & 0xFF);
        this.write(value >>> 16 & 0xFF);
        this.write(value >>> 8 & 0xFF);
        this.write(value & 0xFF);
    }
}

