/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.IVectorEvent;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import eu.geclipse.traceview.utils.VectorEventComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class CauseEffectMarker
extends AbstractEventMarker {
    static String MARKER_ID = "eu.geclipse.traceview.markers.CauseEffectMarker";
    Color background;

    public Color getBackgroundColor(int type) {
        return this.background;
    }

    public Color getForegroundColor(int type) {
        return Display.getDefault().getSystemColor(2);
    }

    public int mark(IEvent event) {
        IVectorEvent causeEvent = (IVectorEvent)this.trace.getUserData(MARKER_ID);
        int result = 0;
        if (causeEvent != null && event instanceof IVectorEvent) {
            IVectorEvent vectorEvent = (IVectorEvent)event;
            if (causeEvent.getVectorClock().length == vectorEvent.getVectorClock().length) {
                VectorEventComparator c = new VectorEventComparator();
                int compare = c.compare(causeEvent, vectorEvent);
                if (compare == -2) {
                    this.background = Display.getDefault().getSystemColor(5);
                    result = 4;
                } else if (compare < 0) {
                    this.background = Display.getDefault().getSystemColor(3);
                    result = 4;
                } else if (compare > 0) {
                    this.background = Display.getDefault().getSystemColor(9);
                    result = 4;
                } else {
                    this.background = Display.getDefault().getSystemColor(1);
                    result = 4;
                }
            }
        }
        return result;
    }
}

