/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.utils.AbstractEventMarker;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class SourceLineEventMarker
extends AbstractEventMarker {
    Set<IEvent> selectedEvents = new HashSet<IEvent>();

    public SourceLineEventMarker() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener("eu.geclipse.traceview.views.TraceView", new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                StructuredSelection sSel = (StructuredSelection)selection;
                SourceLineEventMarker.this.selectedEvents = new HashSet<IEvent>();
                for (Object obj : sSel.toList()) {
                    if (!(obj instanceof ISourceLocation)) continue;
                    IEvent event = (IEvent)obj;
                    SourceLineEventMarker.this.selectedEvents.add(event);
                }
            }
        });
    }

    public Color getBackgroundColor(int type) {
        return Display.getDefault().getSystemColor(13);
    }

    public Color getForegroundColor(int type) {
        return Display.getDefault().getSystemColor(2);
    }

    public int mark(IEvent event) {
        int result = 0;
        if (event instanceof ISourceLocation) {
            ISourceLocation sourceLocation = (ISourceLocation)((Object)event);
            for (IEvent selectedEvent : this.selectedEvents) {
                ISourceLocation selectedISourceLocation = (ISourceLocation)((Object)selectedEvent);
                if (sourceLocation.getSourceFilename() == null || !sourceLocation.getSourceFilename().equals(selectedISourceLocation.getSourceFilename()) || sourceLocation.getSourceLineNumber() != selectedISourceLocation.getSourceLineNumber() || event.getProcess().getTrace() != selectedEvent.getProcess().getTrace()) continue;
                result = 4;
                break;
            }
        }
        return result;
    }
}

