/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.preferences;

import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.internal.Messages;
import eu.geclipse.traceview.preferences.MarkerEntry;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MarkerPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    Button button;
    private Button upButton;
    private Button downButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        MarkerEntry[] eventMarkers;
        this.setTitle(Messages.getString("MarkerPreferencesPage.pageTitle"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gData = new GridData(1808);
        gData.horizontalSpan = 1;
        gData.verticalSpan = 3;
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 200;
        gData.heightHint = 100;
        final Table table = new Table(composite, 2848);
        MarkerEntry[] markerEntryArray = eventMarkers = this.getEventMarkers();
        int n = eventMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerEntry entry = markerEntryArray[n2];
            TableItem item = new TableItem(table, 0);
            item.setData((Object)entry);
            item.setText(entry.label);
            item.setChecked(entry.checked);
            ++n2;
        }
        table.setLayoutData((Object)gData);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPreferencesPage.this.updateButtonStates(table);
            }
        });
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((MarkerEntry)table.getSelection()[0].getData()).checked = event.detail == 32;
            }
        });
        this.upButton = new Button(composite, 8);
        this.upButton.setText(Messages.getString("MarkerPreferencesPage.up"));
        gData = new GridData(768);
        this.upButton.setLayoutData((Object)gData);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPreferencesPage.this.moveSelectedItem(table, -1);
            }
        });
        this.downButton = new Button(composite, 8);
        this.downButton.setText(Messages.getString("MarkerPreferencesPage.down"));
        gData = new GridData(768);
        this.downButton.setLayoutData((Object)gData);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPreferencesPage.this.moveSelectedItem(table, 1);
            }
        });
        return composite;
    }

    MarkerEntry[] getEventMarkers() {
        ArrayList<MarkerEntry> eventMarkers = new ArrayList<MarkerEntry>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("eu.geclipse.traceview.EventMarker");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            eventMarkers.add(new MarkerEntry(configurationElement.getAttribute("id"), configurationElement.getAttribute("label"), true));
            ++n2;
        }
        return eventMarkers.toArray(new MarkerEntry[0]);
    }

    void moveSelectedItem(Table table, int offset) {
        int index = table.getSelectionIndex();
        TableItem item = table.getItem(index);
        boolean checked = item.getChecked();
        MarkerEntry entry = (MarkerEntry)item.getData();
        table.remove(index);
        TableItem newItem = new TableItem(table, 0, index + offset);
        newItem.setChecked(checked);
        newItem.setData((Object)entry);
        newItem.setText(entry.label);
        table.setSelection(index + offset);
        this.updateButtonStates(table);
    }

    void updateButtonStates(Table table) {
        this.upButton.setEnabled(table.getSelectionIndex() != 0);
        this.downButton.setEnabled(table.getSelectionIndex() != table.getItemCount() - 1);
    }
}

