/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.utils;

import eu.geclipse.traceview.internal.Activator;
import eu.geclipse.traceview.utils.AbstractTrace;
import eu.geclipse.traceview.utils.TraceCacheFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTraceFileCache
extends AbstractTrace {
    private static String metaDataFilename = "cache.data";
    protected TraceCacheFile[] cacheFiles;
    protected int[] procsInFile;
    protected File cacheDir;
    protected File dataFile;
    protected Properties metaData;
    protected int[] cacheFileNr;
    protected int[] cacheIndex;
    protected int[] maxLogClk;
    protected Map<String, Integer> sourceFilenames = new HashMap<String, Integer>();
    private int cacheFileCount;

    public abstract int getEventSize();

    public boolean openCacheDir(String tracefileName, String traceOptions, long lastModified) throws IOException {
        boolean cacheLoaded = false;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        File tmpDir = new File(store.getString("cacheDir"));
        this.cacheDir = new File(tmpDir, "tracecache_" + Integer.toHexString(traceOptions.hashCode() + tracefileName.hashCode()));
        this.dataFile = new File(this.cacheDir, metaDataFilename);
        this.cacheFileNr = new int[this.getNumberOfProcesses()];
        this.cacheIndex = new int[this.getNumberOfProcesses()];
        this.maxLogClk = new int[this.getNumberOfProcesses()];
        this.metaData = new Properties();
        if (this.cacheDir.exists() && this.dataFile.exists()) {
            long modTime = this.dataFile.lastModified();
            this.loadCacheMetadata();
            this.cacheFileCount = Integer.parseInt((String)this.metaData.get("cachefilecount"));
            this.procsInFile = new int[this.cacheFileCount];
            int fileNr = 0;
            while (fileNr < this.cacheFileCount) {
                long cacheModTime = new File(this.cacheDir, "cachefile_" + fileNr).lastModified();
                if (cacheModTime < modTime) {
                    modTime = cacheModTime;
                }
                ++fileNr;
            }
            if (modTime > lastModified) {
                fileNr = 0;
                while (fileNr < this.cacheFileCount) {
                    String mapping = (String)this.metaData.get("file_" + fileNr);
                    StringTokenizer tok = new StringTokenizer(mapping, ",");
                    int idx = 0;
                    while (tok.hasMoreTokens()) {
                        String token = tok.nextToken();
                        int procNr = Integer.parseInt(token);
                        this.cacheFileNr[procNr] = fileNr;
                        this.cacheIndex[procNr] = idx++;
                        this.procsInFile[fileNr] = idx;
                    }
                    ++fileNr;
                }
                String filename = "";
                int i = 0;
                while (filename != null) {
                    filename = (String)this.metaData.get("sourcefile_" + i);
                    if (filename != null) {
                        this.sourceFilenames.put(filename, i);
                    }
                    ++i;
                }
                cacheLoaded = true;
            }
        } else {
            this.cacheDir.mkdir();
        }
        if (!cacheLoaded) {
            this.createCacheFileMapping();
        }
        this.openCacheFiles();
        return cacheLoaded;
    }

    protected void createCacheFileMapping() {
        Vector<Integer> factors = this.factorize(this.getNumberOfProcesses());
        this.cacheFileCount = 1;
        int i = factors.size() - 1;
        while (i >= 0) {
            int factor = factors.get(i);
            if (this.cacheFileCount * factor <= 32) {
                this.cacheFileCount *= factor;
            }
            --i;
        }
        int procsPerFile = this.getNumberOfProcesses() / this.cacheFileCount;
        this.procsInFile = new int[this.cacheFileCount];
        int fileNr = 0;
        while (fileNr < this.cacheFileCount) {
            this.procsInFile[fileNr] = procsPerFile;
            ++fileNr;
        }
        this.cacheFileNr = new int[this.getNumberOfProcesses()];
        this.cacheIndex = new int[this.getNumberOfProcesses()];
        int i2 = 0;
        while (i2 < this.getNumberOfProcesses()) {
            this.cacheFileNr[i2] = i2 / procsPerFile;
            this.cacheIndex[i2] = i2 % procsPerFile;
            ++i2;
        }
    }

    private Vector<Integer> factorize(int x) {
        Vector<Integer> resultVector = new Vector<Integer>();
        int d = 2;
        do {
            if (x % d != 0) {
                ++d;
                continue;
            }
            resultVector.add(d);
            x /= d;
            d = 2;
        } while (x != 1);
        return resultVector;
    }

    private void openCacheFiles() throws FileNotFoundException {
        this.cacheFiles = new TraceCacheFile[this.cacheFileCount];
        int fileNr = 0;
        while (fileNr < this.cacheFileCount) {
            this.cacheFiles[fileNr] = new TraceCacheFile(this.cacheDir, fileNr);
            ++fileNr;
        }
    }

    private void loadCacheMetadata() throws IOException {
        this.metaData = new Properties();
        FileInputStream in = new FileInputStream(this.dataFile);
        this.metaData.load(in);
        in.close();
        int i = 0;
        while (i < this.getNumberOfProcesses()) {
            String count = (String)this.metaData.get("eventcount_" + i);
            if (count != null) {
                this.maxLogClk[i] = Integer.parseInt(count);
            }
            ++i;
        }
    }

    protected void saveCacheMetadata() throws IOException {
        try {
            int i = 0;
            while (i < this.getNumberOfProcesses()) {
                this.metaData.put("eventcount_" + i, Integer.toString(this.maxLogClk[i]));
                ++i;
            }
            this.metaData.put("cachefilecount", Integer.toString(this.cacheFileCount));
            int fileNr = 0;
            while (fileNr < this.cacheFileCount) {
                StringBuilder mapping = new StringBuilder();
                int procNr = 0;
                while (procNr < this.getNumberOfProcesses()) {
                    if (this.cacheFileNr[procNr] == fileNr) {
                        if (mapping.length() != 0) {
                            mapping.append(',');
                        }
                        mapping.append(procNr);
                    }
                    ++procNr;
                }
                this.metaData.put("file_" + fileNr, mapping.toString());
                ++fileNr;
            }
            FileOutputStream out = new FileOutputStream(this.dataFile);
            this.metaData.store(out, "Trace file cache meta data");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void write(int processId, int logicalClock, int offset, int value) {
        int eventOffset = this.calcEventOffset(processId, logicalClock, offset);
        try {
            this.cacheFiles[this.cacheFileNr[processId]].write(eventOffset, value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void write(int processId, int logicalClock, int offset, int[] value) {
        int eventOffset = this.calcEventOffset(processId, logicalClock, offset);
        try {
            this.cacheFiles[this.cacheFileNr[processId]].write(eventOffset, value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    int read(int processId, int logicalClock, int offset) {
        try {
            int eventOffset = this.calcEventOffset(processId, logicalClock, offset);
            return this.cacheFiles[this.cacheFileNr[processId]].read(eventOffset);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    void read(int processId, int logicalClock, int offset, int[] data) {
        try {
            int eventOffset = this.calcEventOffset(processId, logicalClock, offset);
            this.cacheFiles[this.cacheFileNr[processId]].read(eventOffset, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int calcEventOffset(int processId, int logicalClock, int offset) {
        return this.getEventSize() * (this.cacheIndex[processId] + this.procsInFile[this.cacheFileNr[processId]] * logicalClock) + offset;
    }

    int getMaximumLogicalClock(int processNr) {
        return this.maxLogClk[processNr];
    }

    void setMaximumLogicalClock(int processNr, int value) {
        this.maxLogClk[processNr] = value;
    }

    String getSourceFilenameForIndex(int index) {
        return (String)this.metaData.get("sourcefile_" + index);
    }

    int addSourceFilename(String filename) {
        int index;
        if (this.sourceFilenames.containsKey(filename)) {
            index = this.sourceFilenames.get(filename);
        } else {
            index = this.sourceFilenames.size();
            this.metaData.put("sourcefile_" + index, filename);
            this.sourceFilenames.put(filename, index);
        }
        return index;
    }

    protected void enableMemoryMap() throws IOException {
        int fileNr = 0;
        while (fileNr < this.cacheFileCount) {
            this.cacheFiles[fileNr].enableMemoryMap();
            ++fileNr;
        }
    }
}

