/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.ui.IAuthTokenUIFactory;
import eu.geclipse.ui.ISimpleTestUIFactory;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.properties.IPropertiesFactory;
import eu.geclipse.ui.views.jobdetails.IJobDetailsFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extensions {
    public static final String EFS_POINT = "eu.geclipse.ui.efs";
    public static final String EFS_FILESYSTEM_ELEMENT = "filesystem";
    public static final String EFS_SCHEME_ATT = "scheme";
    public static final String EFS_VALIDATOR_ATT = "validator";
    public static final String EFS_PROCESSOR_ATT = "processor";
    public static final String EFS_URI_ATT = "uri";
    public static final String EFS_SCHEME_SPEC_PART_ATT = "scheme-specific-part";
    public static final String EFS_AUTHORITY_ATT = "authority";
    public static final String EFS_USER_INFO_ATT = "user-info";
    public static final String EFS_HOST_ATT = "host";
    public static final String EFS_PORT_ATT = "port";
    public static final String EFS_PATH_ATT = "path";
    public static final String EFS_QUERY_ATT = "query";
    public static final String EFS_FRAGMENT_ATT = "fragment";
    public static final String EFS_URI_RAW = "raw";
    public static final String EFS_URI_OPAQUE = "opaque";
    public static final String EFS_URI_HIERARCHICAL = "hierarchical";
    public static final String EFS_URI_SERVER = "server";
    public static final String AUTH_TOKEN_UI_POINT = "eu.geclipse.ui.authTokenUI";
    public static final String AUTH_TOKEN_FACTORY_ELEMENT = "factory";
    public static final String AUTH_TOKEN_FACTORY_EXECUTABLE = "class";
    public static final String CONNECTION_WIZARD_POINT = "eu.geclipse.ui.connectionWizard";
    public static final String SIMPLE_TEST_POINT = "eu.geclipse.core.simpleTests";
    public static final String SIMPLE_TEST_UI_POINT = "eu.geclipse.ui.simpleTestUI";
    public static final String SIMPLE_TEST_ELEMENT = "test";
    public static final String SIMPLE_TEST_NAME_ATTRIBUTE = "name";
    public static final String SIMPLE_TEST_FACTORY_ELEMENT = "factory";
    public static final String SIMPLE_TEST_FACTORY_EXECUTABLE = "class";
    public static final String WIZARD_EXTENSION_ELEMENT = "wizard";
    public static final String WIZARD_EXTENSION_REFID_ATTRIBUTE = "refid";
    public static final String WIZARD_EXTENSION_EXECUTABLE = "class";
    private static final String PROPERTIES_FACTORY_POINT = "eu.geclipse.ui.propertiesFactory";
    private static final String PROPERTIES_FACTORY_ELEMENT = "PropertiesFactory";
    private static final String PROPERTIES_FACTORY_SOURCECLASS_ATTR = "sourceObjectClass";
    private static final String PROPERTIES_FACTORY_CLASS_ATTR = "class";
    private static final String JOBDETAILS_FACTORY_POINT = "eu.geclipse.ui.jobDetailsFactory";
    private static final String JOBDETAILS_FACTORY_ELEMENT = "JobDetailsFactory";
    private static final String JOBDETAILS_FACTORY_SOURCEJOB_CLASS = "sourceJobClass";
    private static final String JOBDETAILS_FACTORY_SOURCEJOBSTATUS_CLASS = "sourceJobStatusClass";
    private static final String JOBDETAILS_FACTORY_IMPLEMENTATION_CLASS = "class";
    private static List<String> simpleTestNames;

    public static List<IAuthTokenUIFactory> getRegisteredAuthTokenUIFactories() {
        ArrayList<IAuthTokenUIFactory> resultList = new ArrayList<IAuthTokenUIFactory>();
        ExtensionManager browser = new ExtensionManager();
        List objectList = browser.getExecutableExtensions(AUTH_TOKEN_UI_POINT, "factory", "class");
        for (Object o : objectList) {
            if (!(o instanceof IAuthTokenUIFactory)) continue;
            resultList.add((IAuthTokenUIFactory)o);
        }
        return resultList;
    }

    public static IConfigurationElement getRegisteredEFSExtension(String scheme) {
        IConfigurationElement result = null;
        List<IConfigurationElement> registeredEFSExtensions = Extensions.getRegisteredEFSExtensions();
        for (IConfigurationElement element : registeredEFSExtensions) {
            if (!element.getAttribute(EFS_SCHEME_ATT).equals(scheme)) continue;
            result = element;
            break;
        }
        return result;
    }

    public static List<IConfigurationElement> getRegisteredEFSExtensions() {
        ExtensionManager manager = new ExtensionManager();
        List filesystems = manager.getConfigurationElements(EFS_POINT, EFS_FILESYSTEM_ELEMENT);
        return filesystems;
    }

    public static List<IPropertiesFactory> getPropertiesFactories(Class<?> sourceObjectClass) {
        ArrayList<IPropertiesFactory> propertiesFactoryList = new ArrayList<IPropertiesFactory>();
        ExtensionManager extManager = new ExtensionManager();
        List confElementsList = extManager.getConfigurationElements(PROPERTIES_FACTORY_POINT, PROPERTIES_FACTORY_ELEMENT);
        for (IConfigurationElement element : confElementsList) {
            String currentSourceObjectString = element.getAttribute(PROPERTIES_FACTORY_SOURCECLASS_ATTR);
            if (currentSourceObjectString != null) {
                try {
                    if (!Extensions.isInstanceOf(sourceObjectClass, currentSourceObjectString)) continue;
                    IPropertiesFactory factory = (IPropertiesFactory)element.createExecutableExtension("class");
                    propertiesFactoryList.add(factory);
                }
                catch (CoreException exception) {
                    Activator.logException(exception);
                }
                continue;
            }
            Activator.logStatus((IStatus)new Status(4, "eu.geclipse.ui", 4, "Attribute sourceObjectClass not found", null));
        }
        return propertiesFactoryList;
    }

    private static boolean isInstanceOf(Class<?> checkedObjectClass, String fullyClassNameString) {
        boolean isInstance = false;
        if (checkedObjectClass.getName().equals(fullyClassNameString)) {
            isInstance = true;
        } else {
            boolean bl = isInstance = Extensions.findInterface(checkedObjectClass, fullyClassNameString) != null;
        }
        if (!isInstance && checkedObjectClass.getSuperclass() != null) {
            isInstance = Extensions.isInstanceOf(checkedObjectClass.getSuperclass(), fullyClassNameString);
        }
        return isInstance;
    }

    private static Class<?> findInterface(Class<?> checkedObjectClass, String fullyInterfaceNameString) {
        Class<?> foundInterface = null;
        Class<?>[] interfaces = checkedObjectClass.getInterfaces();
        int index = 0;
        while (index < interfaces.length && foundInterface == null) {
            foundInterface = interfaces[index].getName().equals(fullyInterfaceNameString) ? interfaces[index] : Extensions.findInterface(interfaces[index], fullyInterfaceNameString);
            ++index;
        }
        return foundInterface;
    }

    public static List<IJobDetailsFactory> getJobDetailsFactories(Class<?> gridJobClass, Class<?> gridJobStatusClass) {
        ArrayList<IJobDetailsFactory> propertiesFactoryList = new ArrayList<IJobDetailsFactory>();
        ExtensionManager extManager = new ExtensionManager();
        List confElementsList = extManager.getConfigurationElements(JOBDETAILS_FACTORY_POINT, JOBDETAILS_FACTORY_ELEMENT);
        for (IConfigurationElement element : confElementsList) {
            String currentSourceObjectString = element.getAttribute(JOBDETAILS_FACTORY_SOURCEJOB_CLASS);
            if (currentSourceObjectString != null) {
                try {
                    if (!Extensions.isInstanceOf(gridJobClass, currentSourceObjectString) || !Extensions.isSupportJobStatus(element, gridJobStatusClass)) continue;
                    IJobDetailsFactory factory = (IJobDetailsFactory)element.createExecutableExtension("class");
                    propertiesFactoryList.add(factory);
                }
                catch (CoreException exception) {
                    Activator.logException(exception);
                }
                continue;
            }
            Activator.logStatus((IStatus)new Status(4, "eu.geclipse.ui", 4, "Attribute sourceJobClass not found", null));
        }
        return propertiesFactoryList;
    }

    private static boolean isSupportJobStatus(IConfigurationElement configElement, Class<?> jobStatusClass) {
        boolean support = true;
        String factoryStatusClass = configElement.getAttribute(JOBDETAILS_FACTORY_SOURCEJOBSTATUS_CLASS);
        if (factoryStatusClass != null) {
            support = jobStatusClass != null && Extensions.isInstanceOf(jobStatusClass, factoryStatusClass);
        }
        return support;
    }

    public static List<String> getRegisteredSimpleTestNames() {
        if (simpleTestNames == null) {
            ArrayList<String> resultList = new ArrayList<String>();
            ExtensionManager manager = new ExtensionManager();
            List cElements = manager.getConfigurationElements(SIMPLE_TEST_POINT, SIMPLE_TEST_ELEMENT);
            for (IConfigurationElement element : cElements) {
                String name = element.getAttribute(SIMPLE_TEST_NAME_ATTRIBUTE);
                if (name == null) continue;
                resultList.add(name);
            }
            Collections.sort(resultList);
            simpleTestNames = resultList;
        }
        return simpleTestNames;
    }

    public static List<ISimpleTestUIFactory> getRegisteredSimpleTestUIFactories() {
        ArrayList<ISimpleTestUIFactory> resultList = new ArrayList<ISimpleTestUIFactory>();
        ExtensionManager browser = new ExtensionManager();
        List objectList = browser.getExecutableExtensions(SIMPLE_TEST_UI_POINT, "factory", "class");
        for (Object o : objectList) {
            if (!(o instanceof ISimpleTestUIFactory)) continue;
            resultList.add((ISimpleTestUIFactory)o);
        }
        return resultList;
    }
}

