/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.comparators;

import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeColumnComparator
extends ViewerComparator {
    private TreeViewer treeViewer;
    private Tree tree;
    private ITableLabelProvider labelProvider;
    private TreeColumn defaultSortColumn;

    public TreeColumnComparator(TreeColumn defaultSortColumn) {
        this.defaultSortColumn = defaultSortColumn;
    }

    public int category(Object element) {
        IAdaptable adaptable;
        int type = 0;
        IResource res = null;
        if (element instanceof IFileStore) {
            IFileInfo info = ((IFileStore)element).fetchInfo();
            type = info.isDirectory() ? 0 : 1;
        } else if (element instanceof IAdaptable && (res = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
            type = -res.getType();
        }
        return type;
    }

    public int compare(Viewer viewer, Object element1, Object element2) {
        int cat2;
        int cat1;
        int result;
        if (this.labelProvider == null) {
            this.initialize(viewer);
        }
        if ((result = (cat1 = this.category(element1)) - (cat2 = this.category(element2))) == 0) {
            int col = this.tree.getSortColumn() == null ? 0 : this.tree.indexOf(this.tree.getSortColumn());
            int order = this.tree.getSortDirection() == 1024 ? 1024 : 128;
            String value1 = this.labelProvider.getColumnText(element1, col);
            String value2 = this.labelProvider.getColumnText(element2, col);
            int n = result = order == 128 ? value1.compareToIgnoreCase(value2) : value2.compareToIgnoreCase(value1);
        }
        if (result == 0) {
            int sCol = this.tree.indexOf(this.defaultSortColumn);
            String value1 = this.labelProvider.getColumnText(element1, sCol);
            String value2 = this.labelProvider.getColumnText(element2, sCol);
            result = value1.compareToIgnoreCase(value2);
        }
        return result;
    }

    private void initialize(Viewer viewer) {
        assert (viewer instanceof TreeViewer);
        this.treeViewer = (TreeViewer)viewer;
        this.tree = this.treeViewer.getTree();
        IBaseLabelProvider lProvider = this.treeViewer.getLabelProvider();
        if (lProvider instanceof ITableLabelProvider) {
            this.labelProvider = (ITableLabelProvider)lProvider;
        }
    }
}

